// blinn Textured.vs
//

attribute vec4 mcPosition;
attribute vec3 mcNormal;
attribute vec4 texCoord1;
uniform float repeatS; // repeat scale factor for texture coords
uniform float repeatT;
uniform float offsetS; // offset for texture coords
uniform float offsetT;

varying vec4 texCoord;
varying float LightIntensity;
const float specularContribution = 0.1;
const float diffuseContribution = 1.0 - specularContribution;

void main(void)
{
    vec3 ecPosition = vec3(gl_ModelViewMatrix * mcPosition);
    vec3 ecNormal = normalize(gl_NormalMatrix * mcNormal);
     
    vec3 lightVec = normalize(vec3(gl_LightSource[0].position) - ecPosition);
    vec3 reflectVec = reflect(-lightVec, ecNormal);
    vec3 viewVec = normalize(-ecPosition);
    
    float spec = clamp(dot(reflectVec, viewVec), 0.0, 1.0);
    spec = pow(spec, 16.0);
    
    LightIntensity = diffuseContribution * max(dot(lightVec, ecNormal), 0.0)
                   + specularContribution * spec;
                   
   // texCoord = texCoord1;
    texCoord.s = offsetS + repeatS * texCoord1.s;
    texCoord.t = offsetT + repeatT * texCoord1.t;
    texCoord.p = texCoord1.p;
    texCoord.q = texCoord1.q;
   
   
    // vertex MVP transform
    gl_Position = gl_ModelViewProjectionMatrix * mcPosition;
     
}
