

//varying float LightIntensity;
//varying vec4 color;

varying vec3 ecPosition;
varying vec3 ecNormal;
varying vec3 ecLightVec;
varying vec4 color;

//uniform sampler2D diffuseSampler;

void main(void)
{
   
   const float specularExp = 4.0;
   
   
   vec3 N = normalize(ecNormal);    // normalized normal
   vec3 L = normalize(ecLightVec);  // normalized light vector
   
   vec3 V = normalize(-ecPosition); // normalized view vector
   vec3 H = normalize(L + V);       // Blinn half vector
   
   float intensity = max(0.0, dot(N, L)); // Lambert intensity
   vec4 diffuseColor = intensity * color;
   float specIntensity = 0.0;
   if (intensity > 0)
   {
      specIntensity = pow(max(0.0, dot(N, H)), specularExp);
   }
   
   
   float spec = 0.6;
   vec3 specularColor = specIntensity * vec3(spec, spec, spec); 
   
 
    // sum the diffuse and specular components
    gl_FragColor.rgb = diffuseColor.rgb + specularColor;
    gl_FragColor.a = 1.0;
}