/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml;

import hmi.xml.XMLNameSpace;
import hmi.xml.XMLNameSpaceStack;
import hmi.xml.XMLScanException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTokenizer {
    public static final boolean SKIPDOCTYPE = true;
    public static final boolean SKIPCOMMENT = true;
    public static final boolean SKIPPI = true;
    public static final boolean RECOGNIZENAMESPACES = true;
    public static final boolean LOG = false;
    public static final int SECTIONBUFSIZE = 4096;
    public static final int DISCARDED_TOKEN_LIMIT = 5;
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.xml.XMLTokenizer");
    public static final int ERRORTOKENLINE = 1;
    public static final int ERRORTOKENPOS = 2;
    public static final int ERRORLINE = 4;
    public static final int ERRORPOS = 8;
    public static final int ERRORFILE = 16;
    public static final int ERRORURL = 32;
    public static final int ERRORFULL = 63;
    public static final int ERRORFILELINE = 52;
    public static final int NOERRORPOSITION = 0;
    private int defaultScanExceptionMode = 63;
    private static final int ERRORBUFSIZE = 40;
    private static final int CDATABUFFERSIZE = 100;
    private static final int DOCTYPEBUFFERSIZE = 20;
    private static boolean debug = false;
    public static final int NULLTOKEN = 0;
    public static final int STAG = 1;
    public static final int ETAG = 4;
    public static final int CHARDATA = 8;
    public static final int CDSECT = 9;
    public static final int COMMENT = 10;
    public static final int PI = 11;
    public static final int DECL = 12;
    public static final int DOCTYPE = 13;
    public static final int ENDOFDOCUMENT = 14;
    public static final int ERRORTOKEN = 15;
    private boolean skipDoctype;
    private boolean skipComment;
    private boolean skipPI;
    private boolean recognizeNamespaces;
    private BufferedReader in;
    private URL url;
    private File file;
    private int ci;
    private char ch;
    private int line;
    private int charPos;
    private int tokenLine;
    private int tokenCharPos;
    private int token;
    private StringBuilder sectionBuffer = new StringBuilder(4096);
    private boolean sectionBuffering;
    private boolean tokenConsumed;
    private boolean tokenBuffered;
    private int tokenMode;
    private String tagName;
    private String tagPrefix;
    private String tagNamespace;
    private String defaultNamespace = null;
    private String attributeName;
    private String attributePrefix;
    private String doctypeName;
    private String pubidLiteral;
    private String systemLiteral;
    private static final int BUFSIZESMALL = 16;
    private static final int BUFSIZELARGE = 128;
    private StringBuilder tagNameBuffer = new StringBuilder(16);
    private StringBuilder attributeNameBuffer = new StringBuilder(16);
    private StringBuilder attributeValueBuffer = new StringBuilder(128);
    private StringBuilder charDataBuffer = new StringBuilder(128);
    private StringBuilder cDataBuffer = new StringBuilder(128);
    private StringBuilder piDataBuffer = new StringBuilder(16);
    private StringBuilder commentDataBuffer = new StringBuilder(128);
    private StringBuilder buf;
    private static final int TAGSTACKSIZE = 32;
    private ArrayList<String> tagStack = new ArrayList(32);
    private XMLNameSpaceStack namespaceStack = new XMLNameSpaceStack();
    private ArrayList<Integer> xmlnsCountStack = new ArrayList();
    private ArrayList<TokenizerState> tokenizerStateStack;
    private boolean popOnEndOfDocument = false;
    private HashMap<String, String> attributes = new LinkedHashMap<String, String>();
    private static final int CHARDATA_MODE = 1;
    private static final int PENDING_ETAG_MODE = 4;
    private static final int ENDOFDOCUMENT_MODE = 5;
    public static final int EOS = -1;
    public static final int CONSUMED = -2;

    public XMLTokenizer(Reader in) {
        this.setDefaultModes();
        this.setReader(in);
    }

    public XMLTokenizer(InputStream in) {
        this(new BufferedReader(new InputStreamReader(in)));
    }

    public XMLTokenizer() {
        this((Reader)null);
    }

    public XMLTokenizer(String xmlString) {
        this(new BufferedReader(new StringReader(xmlString)));
    }

    public XMLTokenizer(File inFile) throws FileNotFoundException {
        this((Reader)null);
        this.setFile(inFile);
    }

    public XMLTokenizer(URL url) {
        this((Reader)null);
        try {
            this.setURL(url);
        }
        catch (IOException e) {
            throw new XMLScanException("Could not set XMLTokenizer URL: " + e);
        }
    }

    public void setFile(File inFile) throws FileNotFoundException {
        this.setReader(new BufferedReader(new FileReader(inFile)));
        this.file = inFile;
        try {
            this.setBaseURL(inFile.toURI().toURL());
        }
        catch (MalformedURLException me) {
            logger.error("Malformed file URL: " + me);
        }
    }

    public final File getFile() {
        return this.file;
    }

    public void setBaseURL(URL url) {
        this.url = url;
    }

    public void setBaseURL(String urlSpec) {
        try {
            URL newUrl = new URL(this.url, urlSpec);
            if (newUrl != null) {
                this.url = newUrl;
            }
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL: " + urlSpec);
            throw this.getXMLScanException("Malformed URL: " + urlSpec);
        }
    }

    public void setURL(URL url) throws IOException {
        if (url == null) {
            throw new XMLScanException("XMLTokenizer: null URL specified");
        }
        InputStream is = url.openStream();
        BufferedReader ir = new BufferedReader(new InputStreamReader(is));
        this.url = url;
        this.setReader(ir);
    }

    public void setURL(String urlSpec) throws IOException {
        try {
            URL newUrl = new URL(this.url, urlSpec);
            if (newUrl != null) {
                InputStream is = newUrl.openStream();
                BufferedReader ir = new BufferedReader(new InputStreamReader(is));
                this.url = newUrl;
                this.setReader(ir);
            }
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL: " + urlSpec);
            throw this.getXMLScanException("Malformed URL: " + urlSpec);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public final BufferedReader setReader(Reader in) {
        BufferedReader oldreader = this.in;
        this.in = in == null ? null : (in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in));
        this.initState();
        return oldreader;
    }

    public final Reader getReader() {
        return this.in;
    }

    public final void pushReader(BufferedReader in) {
        this.pushState();
        this.setReader(in);
        this.file = null;
        this.url = null;
    }

    public final void pushReader(String urlSpec) throws IOException {
        this.pushState();
        try {
            this.setURL(urlSpec);
            this.file = null;
        }
        catch (IOException ie) {
            this.popState();
            throw ie;
        }
    }

    public final void popReader() {
        this.popState();
    }

    public void setXMLScanExceptionMode(int mode) {
        if (mode > 63) {
            logger.error("XMLTokenizer: Illegal error mode");
        } else {
            this.defaultScanExceptionMode = mode;
        }
    }

    public XMLScanException getXMLScanException(String message) {
        return this.getXMLScanException(message, this.defaultScanExceptionMode);
    }

    public XMLScanException getXMLScanException(String message, int mode) {
        String fileName = this.file != null ? this.file.getName() : null;
        String urlString = this.url != null ? this.url.toString() : null;
        return new XMLScanException(this.getErrorMessage(message, mode), fileName, urlString, this.tokenLine, this.tokenCharPos, this.line, this.charPos);
    }

    public String getErrorMessage(String message) {
        return this.getErrorMessage(message, this.defaultScanExceptionMode);
    }

    public String getErrorMessage(String message, int mode) {
        StringBuilder msg = new StringBuilder(40);
        if (message != null) {
            msg.append(message);
        }
        if ((mode & 0x10) != 0 && this.file != null) {
            msg.append(", file: ");
            msg.append(this.file.getName());
        } else if ((mode & 0x20) != 0 && this.url != null) {
            msg.append(", URL: ");
            msg.append(this.url.toString());
        }
        if ((mode & 1) != 0) {
            msg.append(", token line: ");
            msg.append(this.getTokenLine());
        }
        if ((mode & 2) != 0) {
            msg.append(", position: ");
            msg.append(this.getTokenCharPos());
        }
        if ((mode & 4) != 0) {
            msg.append(", error line: ");
            msg.append(this.getLine());
        }
        if ((mode & 8) != 0) {
            msg.append(", position: ");
            msg.append(this.getCharPos());
        }
        return msg.toString();
    }

    public final int getLine() {
        return this.line;
    }

    public final int getCharPos() {
        return this.charPos;
    }

    public final int getTokenLine() {
        return this.tokenLine;
    }

    public final int getTokenCharPos() {
        return this.tokenCharPos;
    }

    public final int currentToken() {
        return this.token;
    }

    public final String currentTokenString() {
        if (this.token == 1 || this.token == 4) {
            return XMLTokenizer.tokenString(this.token) + " " + this.tagName;
        }
        return XMLTokenizer.tokenString(this.token);
    }

    public final boolean recoverAtSTag(String stag) {
        return this.recoverAtSTag(stag, 5);
    }

    public final boolean recoverAtSTag(String stag, int tokenLimit) {
        int skipCount = 0;
        try {
            while (!this.atEndOfDocument() && !this.atSTag(stag)) {
                this.nextToken();
                if (skipCount < tokenLimit) {
                    if (this.token == 1 || this.token == 4) {
                        logger.warn("Skipping " + XMLTokenizer.tokenString(this.token) + " token: " + this.tagName);
                    } else {
                        logger.warn("Skipping " + XMLTokenizer.tokenString(this.token) + "token");
                    }
                } else if (skipCount == tokenLimit) {
                    logger.warn("Skipping tokens ....");
                }
                ++skipCount;
            }
            return this.atSTag(stag);
        }
        catch (IOException e) {
            logger.error("Exception while recovering for " + stag + " STAG: " + e);
            return false;
        }
    }

    public final boolean recoverAfterETag(String etag) {
        return this.recoverAfterETag(etag, 5);
    }

    public final boolean recoverAfterETag(String etag, int tokenLimit) {
        int skipCount = 0;
        try {
            while (!this.atEndOfDocument() && !this.atETag(etag)) {
                this.nextToken();
                if (skipCount < tokenLimit) {
                    if (this.token == 1 || this.token == 4) {
                        logger.warn("Skipping " + XMLTokenizer.tokenString(this.token) + " token: " + this.tagName);
                    } else {
                        logger.warn("Skipping " + XMLTokenizer.tokenString(this.token) + "token");
                    }
                } else if (skipCount == tokenLimit) {
                    logger.warn("Skipping tokens ....");
                }
                ++skipCount;
            }
            if (this.atETag(etag)) {
                this.takeETag();
                return true;
            }
            return false;
        }
        catch (IOException e) {
            logger.error("Exception while recovering for " + etag + " ETAG: " + e);
            return false;
        }
    }

    public final void skipTag() throws IOException {
        if (!this.atSTag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG at start of skipTag action");
        }
        String skipTagName = this.getTagName();
        int skipStackSize = this.tagStack.size();
        do {
            this.nextToken();
            if (!this.atEndOfDocument()) continue;
            logger.warn("ENDOFDOCUMENT reached while skipping tag: " + skipTagName);
            this.token = 14;
            return;
        } while (!this.atETag() || this.tagStack.size() >= skipStackSize);
        this.tokenConsumed = true;
    }

    public final String getXMLSection() throws IOException {
        if (!this.atSTag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG at start of getXMLSection action");
        }
        this.in.reset();
        this.setSectionBuffering(true);
        this.clearSectionBuffer();
        this.sectionBuffer.append('<');
        int skipStackSize = this.tagStack.size();
        do {
            this.nextToken();
            if (!this.atEndOfDocument()) continue;
            throw new XMLScanException("ENDOFDOCUMENT reached");
        } while (!this.atETag() || this.tagStack.size() >= skipStackSize);
        this.tokenConsumed = true;
        String result = this.getSectionBuffer();
        this.setSectionBuffering(false);
        return result;
    }

    public final String getXMLSectionContent() throws IOException {
        this.nextChar();
        while (this.ci == 32 || this.ci == 9) {
            this.nextChar();
        }
        if (this.ci == 13 || this.ci == 10) {
            this.nextChar();
        }
        this.setSectionBuffering(true);
        this.clearSectionBuffer();
        int skipStackSize = this.tagStack.size();
        do {
            this.nextToken();
            if (!this.atEndOfDocument()) continue;
            throw new XMLScanException("ENDOFDOCUMENT reached");
        } while (!this.atETag() || this.tagStack.size() >= skipStackSize);
        String result = this.getStrippedSectionBuffer();
        this.setSectionBuffering(false);
        return result;
    }

    private final int nextToken() throws IOException, XMLScanException {
        try {
            while (true) {
                this.tokenConsumed = false;
                if (this.tokenBuffered) {
                    this.tokenBuffered = false;
                    return this.token;
                }
                switch (this.tokenMode) {
                    case 1: {
                        this.parseCharData();
                        break;
                    }
                    case 4: {
                        this.token = 4;
                        this.tokenMode = 1;
                        this.popTag(this.tagName);
                        break;
                    }
                    case 5: {
                        this.token = 14;
                        break;
                    }
                    default: {
                        throw this.getXMLScanException("unknown XMLTokenizer processing mode");
                    }
                }
                if (this.token != 14 || !this.popOnEndOfDocument || this.tokenizerStateStack.size() <= 0) break;
                this.popState();
            }
            return this.token;
        }
        catch (RuntimeException re) {
            this.token = 15;
            throw re;
        }
    }

    private int parseCharData() throws IOException {
        while (this.ci != -1) {
            if (this.ci == -2) {
                this.nextParsedChar();
            }
            while (this.isSpaceChar()) {
                this.nextParsedChar();
            }
            this.setTokenPos();
            this.in.mark(4096);
            if (this.ci == 60) {
                int markup = this.parseMarkup();
                if (markup > 0) {
                    return markup;
                }
                this.setTokenPos();
                continue;
            }
            if (this.ci == -1) {
                this.token = 14;
                this.tokenMode = 5;
                this.setTokenPos();
                return this.token;
            }
            this.clearBuffer(this.charDataBuffer);
            while (this.ci != 60 && this.ci != -1) {
                this.charDataBuffer.append(this.ch);
                this.nextParsedChar();
            }
            this.token = 8;
            return this.token;
        }
        this.token = 14;
        this.tokenMode = 5;
        this.setTokenPos();
        this.checkEmptyTagStack();
        return this.token;
    }

    private int parseMarkup() throws IOException {
        this.setTokenPos();
        this.nextChar();
        if (this.ci == 33) {
            return this.parseDeclaration();
        }
        if (this.ci == 63) {
            int piState = this.parsePI();
            if (piState >= 0) {
                return piState;
            }
            return -1;
        }
        if (this.ci == 47) {
            return this.parseETag();
        }
        if (this.isNameStartChar()) {
            return this.parseSTag();
        }
        return -1;
    }

    private int parseSTag() throws IOException {
        this.clearBuffer(this.tagNameBuffer);
        this.tagPrefix = null;
        int namespaceDeclarationCount = 0;
        Object xmlnsNameSpace = null;
        this.attributes.clear();
        while (this.isNameChar()) {
            this.tagNameBuffer.append((char)this.ci);
            this.nextChar();
        }
        if (this.isNamespaceSepChar()) {
            this.tagPrefix = this.tagNameBuffer.toString().intern();
            this.clearBuffer(this.tagNameBuffer);
            this.nextChar();
            while (this.isNameChar()) {
                this.tagNameBuffer.append((char)this.ci);
                this.nextChar();
            }
        }
        this.tagName = this.tagNameBuffer.toString();
        this.skipSpaceChars();
        while (this.ci != 62 && this.ci != -1) {
            if (this.ci == 47) {
                this.nextChar();
                if (this.ci != 62) {
                    throw this.getXMLScanException("'>' character after '/' expected instead of '" + (char)this.ci + "'");
                }
                this.tokenMode = 4;
                continue;
            }
            if (!this.isNameStartChar()) {
                throw this.getXMLScanException("XML attribute name expected");
            }
            this.parseAttribute();
            if (this.attributePrefix != null && this.attributePrefix.equals("xmlns")) {
                String nameSpace = this.attributeValueBuffer.toString();
                String namespacePrefix = this.attributeName;
                XMLNameSpace ns = new XMLNameSpace(namespacePrefix, nameSpace);
                this.namespaceStack.pushXMLNameSpace(ns);
                ++namespaceDeclarationCount;
                this.attributePrefixFixup(namespacePrefix, nameSpace);
            } else if (this.attributeName.equals("xmlns")) {
                String nsp = this.attributeValueBuffer.toString().intern();
                if (nsp == "") {
                    nsp = null;
                }
                XMLNameSpace ns = new XMLNameSpace("", nsp);
                this.namespaceStack.pushXMLNameSpace(ns);
                ++namespaceDeclarationCount;
                this.defaultNamespace = nsp;
            } else if (this.attributePrefix != null) {
                String attributeNameSpace = this.namespaceStack.getNameSpace(this.attributePrefix);
                if (attributeNameSpace == null) {
                    this.attributes.put(this.attributePrefix + ":" + this.attributeName, this.attributeValueBuffer.toString());
                } else {
                    this.attributes.put(attributeNameSpace + ":" + this.attributeName, this.attributeValueBuffer.toString());
                }
            } else {
                this.attributes.put(this.attributeName, this.attributeValueBuffer.toString());
            }
            this.skipSpaceChars();
        }
        if (this.ci != 62) {
            throw this.getXMLScanException("'>' expected at end of XML STAG");
        }
        this.ci = -2;
        this.token = 1;
        this.tagNamespace = this.tagPrefix == null ? this.defaultNamespace : this.namespaceStack.getNameSpace(this.tagPrefix);
        this.pushTag(this.tagName, namespaceDeclarationCount);
        if (this.tokenMode != 4) {
            this.tokenMode = 1;
        }
        return this.token;
    }

    private void attributePrefixFixup(String nsPrefix, String ns) {
        Set<String> attributeNames = this.attributes.keySet();
        for (String attrName : attributeNames) {
            String attrPrefix;
            int colPos = attrName.indexOf(58);
            if (colPos < 0 || !(attrPrefix = attrName.substring(0, colPos)).equals(nsPrefix)) continue;
            String nameTail = attrName.substring(colPos);
            String newName = ns + nameTail;
            String attrValue = this.attributes.get(attrName);
            this.attributes.remove(attrName);
            this.attributes.put(newName, attrValue);
        }
    }

    private int parseETag() throws IOException {
        this.clearBuffer(this.tagNameBuffer);
        this.tagPrefix = null;
        this.tagNamespace = this.defaultNamespace;
        this.nextChar();
        while (this.isNameChar()) {
            this.tagNameBuffer.append((char)this.ci);
            this.nextChar();
        }
        if (this.isNamespaceSepChar()) {
            this.tagPrefix = this.tagNameBuffer.toString().intern();
            this.tagNamespace = this.namespaceStack.getNameSpace(this.tagPrefix);
            this.clearBuffer(this.tagNameBuffer);
            this.nextChar();
            while (this.isNameChar()) {
                this.tagNameBuffer.append((char)this.ci);
                this.nextChar();
            }
        }
        if (this.ci != 62) {
            throw this.getXMLScanException("'>' character at end of ETAG expected, instead of '" + (char)this.ci + "'");
        }
        this.ci = -2;
        this.token = 4;
        this.tagName = this.tagNameBuffer.toString();
        this.popTag(this.tagName);
        return this.token;
    }

    private void parseAttribute() throws IOException {
        this.clearBuffer(this.attributeNameBuffer);
        this.clearBuffer(this.attributeValueBuffer);
        this.attributePrefix = null;
        while (this.isNameChar()) {
            this.attributeNameBuffer.append((char)this.ci);
            this.nextChar();
        }
        if (this.isNamespaceSepChar()) {
            this.attributePrefix = this.attributeNameBuffer.toString().intern();
            this.clearBuffer(this.attributeNameBuffer);
            this.nextChar();
            while (this.isNameChar()) {
                this.attributeNameBuffer.append((char)this.ci);
                this.nextChar();
            }
        }
        this.attributeName = this.attributeNameBuffer.toString();
        this.skipSpaceChars();
        if (this.ci != 61) {
            throw this.getXMLScanException("'=' character expected in XML attribute instead of '" + (char)this.ci + "'");
        }
        this.nextChar();
        this.parseString(this.attributeValueBuffer);
    }

    private int parseString(StringBuilder buf) throws IOException {
        this.skipSpaceChars();
        if (this.ci != 34 && this.ci != 39) {
            return -1;
        }
        boolean aposmode = this.ci == 39;
        this.nextParsedChar();
        int len = 0;
        while (!(!aposmode && this.ci == 34 || aposmode && this.ci == 39 || this.ci == -1)) {
            buf.append(this.ch);
            ++len;
            this.nextParsedChar();
        }
        if (this.ci == -1) {
            throw this.getXMLScanException("missing \" or ': end-of-data reached");
        }
        this.nextChar();
        return len;
    }

    private int parseDeclaration() throws IOException {
        this.nextChar();
        if (this.ci == 45) {
            return this.parseComment();
        }
        if (this.ci == 68) {
            return this.parseDoctype();
        }
        if (this.ci == 91) {
            return this.parseCDSect();
        }
        throw this.getXMLScanException("Unknown declaration type");
    }

    private int parseCDSect() throws IOException {
        if (this.nextChar() != 67) {
            throw this.getXMLScanException("Wrong format at CDATA section");
        }
        if (this.nextChar() != 68) {
            throw this.getXMLScanException("Wrong format at CDATA section");
        }
        if (this.nextChar() != 65) {
            throw this.getXMLScanException("Wrong format at CDATA section");
        }
        if (this.nextChar() != 84) {
            throw this.getXMLScanException("Wrong format at CDATA section");
        }
        if (this.nextChar() != 65) {
            throw this.getXMLScanException("Wrong format at CDATA section");
        }
        if (this.nextChar() != 91) {
            throw this.getXMLScanException("Wrong format at CDATA section");
        }
        this.cDataBuffer = new StringBuilder(100);
        this.nextChar();
        boolean endCData = false;
        while (!endCData) {
            if (this.ci != 93 && this.ci != -1) {
                this.cDataBuffer.append((char)this.ci);
                this.nextChar();
                continue;
            }
            if (this.ci != -1) {
                this.nextChar();
            }
            if (this.ci != 93 && this.ci != -1) {
                this.cDataBuffer.append(']');
                this.cDataBuffer.append((char)this.ci);
                this.nextChar();
                continue;
            }
            if (this.ci != -1) {
                this.nextChar();
            }
            while (this.ci == 93 && this.ci != -1) {
                this.cDataBuffer.append(']');
                this.nextChar();
            }
            if (this.ci != 62 && this.ci != -1) {
                this.cDataBuffer.append(']');
                this.cDataBuffer.append(']');
                this.cDataBuffer.append((char)this.ci);
                this.nextChar();
                continue;
            }
            if (this.ci == -1) {
                throw this.getXMLScanException("Wrong format at CDATA section: unexpected EOS");
            }
            endCData = true;
            this.ci = -2;
            this.token = 9;
            return this.token;
        }
        throw this.getXMLScanException("'Impossible' situation in CDATA section: ran out of loops");
    }

    private int parseComment() throws IOException {
        if (this.nextChar() != 45) {
            return -1;
        }
        this.nextChar();
        if (!this.skipComment) {
            this.clearBuffer(this.commentDataBuffer);
        }
        while (this.ci != 45 && this.ci != -1) {
            while (this.ci != 45 && this.ci != -1) {
                if (!this.skipComment) {
                    this.commentDataBuffer.append((char)this.ci);
                }
                this.nextChar();
            }
            this.nextChar();
            if (this.skipComment || this.ci == 45 || this.ci == -1) continue;
            this.commentDataBuffer.append('-');
        }
        if (this.ci == 45) {
            this.nextChar();
        }
        if (this.ci != 62) {
            throw this.getXMLScanException("'>' expected at end of XML comment instead of '" + (char)this.ci + "'");
        }
        this.ci = -2;
        if (this.skipComment) {
            return -1;
        }
        this.token = 10;
        return this.token;
    }

    private void skipDoctype() throws IOException {
        int brackLevel = 1;
        while (brackLevel > 0 && this.ci != -1) {
            this.nextChar();
            if (this.ci == 60) {
                ++brackLevel;
            }
            if (this.ci != 62) continue;
            --brackLevel;
        }
        if (this.ci == 62) {
            this.ci = -2;
        }
    }

    private int parseDoctype() throws IOException {
        this.checkSequence("DOCTYPE");
        if (this.skipDoctype) {
            this.skipDoctype();
            return -1;
        }
        if (this.doctypeName != null) {
            throw this.getXMLScanException("redeclaration of DOCTYPE not allowed");
        }
        this.buf = new StringBuilder(20);
        this.skipSpaceChars();
        if (!this.isNameStartChar()) {
            throw this.getXMLScanException("Illegal character at start of DOCTYPE name: " + (char)this.ci);
        }
        while (this.isNameChar()) {
            this.buf.append((char)this.ci);
            this.nextChar();
        }
        this.doctypeName = this.buf.toString();
        this.skipSpaceChars();
        if (this.ci == 83) {
            this.checkSequence("SYSTEM");
            this.clearBuffer(this.buf);
            this.parseString(this.buf);
            this.systemLiteral = this.buf.toString();
        } else if (this.ci == 80) {
            this.checkSequence("PUBLIC");
            this.clearBuffer(this.buf);
            this.parseString(this.buf);
            this.pubidLiteral = this.buf.toString();
            this.clearBuffer(this.buf);
            this.parseString(this.buf);
            this.systemLiteral = this.buf.toString();
        }
        if (this.ci != 62 && this.ci == 91) {
            throw this.getXMLScanException("\"[....]\" inside DOCTYPE not supported");
        }
        this.skipSpaceChars();
        if (this.ci != 62) {
            throw this.getXMLScanException("Unexpected character at end of DOCTYPE declaration");
        }
        this.ci = -2;
        this.token = 13;
        return this.token;
    }

    private void checkSequence(String seq) throws IOException {
        if (this.ci == -2) {
            this.nextChar();
        }
        for (int i = 0; i < seq.length(); ++i) {
            if (this.ci != seq.charAt(i)) {
                throw this.getXMLScanException(seq.charAt(i) + " character expected in " + seq + " instead of '" + (char)this.ci + "'");
            }
            this.nextChar();
        }
    }

    private int parsePI() throws IOException {
        this.nextChar();
        this.clearBuffer(this.piDataBuffer);
        while (this.ci != 62 && this.ci != -1) {
            while (this.ci != 63 && this.ci != -1) {
                this.piDataBuffer.append((char)this.ci);
                this.nextChar();
            }
            this.nextChar();
            if (this.ci == 62 || this.ci == -1) continue;
            this.piDataBuffer.append('?');
        }
        if (this.ci == 62) {
            this.ci = -2;
        }
        if (this.skipPI) {
            return -1;
        }
        this.token = 11;
        return this.token;
    }

    public final boolean setSkipPI(boolean skipped) {
        boolean oldvalue = this.skipPI;
        this.skipPI = skipped;
        return oldvalue;
    }

    public final boolean setSkipComment(boolean skipped) {
        boolean oldvalue = this.skipComment;
        this.skipComment = skipped;
        return oldvalue;
    }

    public final boolean setSkipDoctype(boolean skipped) {
        boolean oldvalue = this.skipDoctype;
        this.skipDoctype = skipped;
        return oldvalue;
    }

    public final boolean getRecognizeNamespaces() {
        return this.recognizeNamespaces;
    }

    public final boolean setRecognizeNamespaces(boolean recnsp) {
        boolean oldvalue = this.recognizeNamespaces;
        this.recognizeNamespaces = recnsp;
        return oldvalue;
    }

    private final void setSectionBuffering(boolean buffering) {
        this.sectionBuffering = buffering;
    }

    private final void clearSectionBuffer() {
        this.sectionBuffer.delete(0, this.sectionBuffer.length());
    }

    private final String getStrippedSectionBuffer() {
        int endPos;
        if (this.sectionBuffer == null) {
            return "";
        }
        for (endPos = this.sectionBuffer.length() - 1; endPos >= 0 && this.sectionBuffer.charAt(endPos) != '<'; --endPos) {
        }
        --endPos;
        while (endPos >= 0 && this.sectionBuffer.charAt(endPos) == ' ') {
            --endPos;
        }
        return this.sectionBuffer.substring(0, endPos + 1);
    }

    private final String getSectionBuffer() {
        if (this.sectionBuffer == null) {
            return "";
        }
        return this.sectionBuffer.toString();
    }

    public final boolean atSTag() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token == 1;
    }

    public final boolean atSTag(String tagName) throws IOException {
        return this.atSTag() && this.tagName.equals(tagName);
    }

    public final boolean atETag() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token == 4;
    }

    public final boolean atETag(String tName) throws IOException {
        return this.atETag() && this.tagName.equals(tName);
    }

    public final boolean atPI() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token == 11;
    }

    public final boolean atComment() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token == 10;
    }

    public final boolean atDoctype() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token == 13;
    }

    public final boolean atCDSect() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token == 9;
    }

    public final boolean atDoctype(String name) throws IOException {
        return this.atDoctype() && this.doctypeName.equals(name);
    }

    public final boolean atCharData() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token == 8;
    }

    public final boolean atEndOfDocument() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token == 14;
    }

    public final int getToken() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return this.token;
    }

    public final String getTokenString() throws IOException {
        if (this.tokenConsumed) {
            this.nextToken();
        }
        return XMLTokenizer.tokenString(this.token);
    }

    public final String getTagName() throws IOException {
        if (!this.atSTag() && !this.atETag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG or an ETAG");
        }
        return this.tagName;
    }

    public final String getNamespace() throws IOException {
        if (!this.atSTag() && !this.atETag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG or an ETAG");
        }
        return this.tagNamespace;
    }

    public final String getComment() throws IOException {
        if (!this.atComment()) {
            throw this.getXMLScanException("The XMLTokenizer was not at a COMMENT token");
        }
        return this.commentDataBuffer.toString();
    }

    public final String getDoctypeName() {
        return this.doctypeName;
    }

    public final String getPubidLiteral() {
        return this.pubidLiteral;
    }

    public final String getSystemLiteral() {
        return this.systemLiteral;
    }

    public final String getPI() throws IOException {
        if (!this.atPI()) {
            throw this.getXMLScanException("The XMLTokenizer was not at a PI token");
        }
        return this.piDataBuffer.toString();
    }

    public final String getCharData() throws IOException {
        if (!this.atCharData()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an CHARDATA token");
        }
        return this.charDataBuffer.toString();
    }

    public final String getOptionalCharData() throws IOException {
        if (this.atCharData()) {
            return this.charDataBuffer.toString();
        }
        if (this.atETag()) {
            return "";
        }
        throw this.getXMLScanException("The XMLTokenizer was not at a CHARDATA position");
    }

    public final String getTrimmedCharData() throws IOException {
        return this.getCharData().trim();
    }

    public final String getCDSect() throws IOException {
        if (!this.atCDSect()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an CDATA token");
        }
        String cData = this.cDataBuffer.toString();
        return cData;
    }

    public final HashMap<String, String> getAttributes() throws IOException {
        if (!this.atSTag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG");
        }
        return this.attributes;
    }

    public final String getAttribute(String attributeName) throws IOException {
        if (!this.atSTag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG");
        }
        return this.attributes.get(attributeName);
    }

    public final Iterator getAttributeIterator() throws IOException {
        if (!this.atSTag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG");
        }
        return this.attributes.entrySet().iterator();
    }

    public final String takeSTag() throws IOException {
        if (!this.atSTag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG token");
        }
        String result = this.getTagName();
        this.tokenConsumed = true;
        return result;
    }

    public final void takeSTag(String tagName) throws IOException {
        if (!this.atSTag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an STAG token");
        }
        if (!this.getTagName().equals(tagName)) {
            throw this.getXMLScanException(tagName + " tag expected, found: " + this.getTagName());
        }
        this.tokenConsumed = true;
    }

    public final String takeETag() throws IOException {
        String result = this.getTagName();
        if (!this.atETag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an ETAG token");
        }
        this.tokenConsumed = true;
        return result;
    }

    public final void takeETag(String tagName) throws IOException {
        if (!this.atETag()) {
            throw this.getXMLScanException("The XMLTokenizer was not at an ETAG token");
        }
        if (!this.getTagName().equals(tagName)) {
            throw this.getXMLScanException("ETAG " + tagName + " expected, but found : " + this.getTagName());
        }
        this.tokenConsumed = true;
    }

    public final String takeCharData() throws IOException {
        String result = this.getCharData();
        this.tokenConsumed = true;
        return result;
    }

    public final String takeOptionalCharData() throws IOException {
        if (this.atCharData()) {
            this.tokenConsumed = true;
            return this.charDataBuffer.toString();
        }
        if (this.atETag()) {
            return "";
        }
        throw this.getXMLScanException("The XMLTokenizer was not at a CHARDATA position");
    }

    public final String takeTrimmedCharData() throws IOException {
        String result = this.getTrimmedCharData();
        this.tokenConsumed = true;
        return result;
    }

    public final String takeCDSect() throws IOException {
        String result = this.getCDSect();
        this.tokenConsumed = true;
        return result;
    }

    public final String takePI() throws IOException {
        String result = this.getPI();
        this.tokenConsumed = true;
        return result;
    }

    public final String takeComment() throws IOException {
        String result = this.getComment();
        this.tokenConsumed = true;
        return result;
    }

    public String takeTextElement(String tagName) throws IOException {
        this.takeSTag(tagName);
        String result = "";
        if (this.atCharData()) {
            result = this.takeCharData();
        }
        this.takeETag(tagName);
        return result.trim();
    }

    public int takeIntElement(String tagName) throws IOException {
        return Integer.parseInt(this.takeTextElement(tagName));
    }

    public long takeLongElement(String tagName) throws IOException {
        return Long.parseLong(this.takeTextElement(tagName));
    }

    public float takeFloatElement(String tagName) throws IOException {
        return Float.parseFloat(this.takeTextElement(tagName));
    }

    public double takeDoubleElement(String tagName) throws IOException {
        return Double.parseDouble(this.takeTextElement(tagName));
    }

    public HashMap<String, String> takeEmptyElement(String tagName) throws IOException {
        HashMap<String, String> result = this.getAttributes();
        this.takeSTag(tagName);
        this.takeETag(tagName);
        return result;
    }

    public final int read() throws IOException {
        if (this.ci == -2) {
            this.nextChar();
        }
        int result = this.ci;
        this.ci = -2;
        return result;
    }

    public final String takeString(int len) throws IOException {
        if (len <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(len);
        if (this.ci == -2) {
            this.nextChar();
        }
        buf.append((char)this.ci);
        for (int i = 1; i < len; ++i) {
            this.nextChar();
            if (this.ci < 0) {
                throw this.getXMLScanException("takeString(" + len + ") : EOS while reading String character nr " + i);
            }
            buf.append((char)this.ci);
        }
        this.ci = -2;
        return buf.toString();
    }

    private boolean isNameChar() {
        return 97 <= this.ci && this.ci <= 122 || 65 <= this.ci && this.ci <= 90 || 48 <= this.ci && this.ci <= 57 || this.ci == 95 || this.ci == 45 || this.ci == 46 || !this.recognizeNamespaces && this.ci == 58;
    }

    private boolean isNamespaceSepChar() {
        return this.ci == 58;
    }

    private boolean isNameStartChar() {
        return 97 <= this.ci && this.ci <= 122 || 65 <= this.ci && this.ci <= 90 || this.ci == 95 || !this.recognizeNamespaces && this.ci == 58;
    }

    private boolean isSpaceChar() {
        return this.ci == 32 || this.ci == 10 || this.ci == 9 || this.ci == 13;
    }

    private void skipSpaceChars() throws IOException {
        while (this.ci == 32 || this.ci == 10 || this.ci == 9 || this.ci == 13) {
            this.nextChar();
        }
    }

    private int nextChar() throws IOException {
        this.ci = this.in.read();
        ++this.charPos;
        if (this.sectionBuffering) {
            this.sectionBuffer.append((char)this.ci);
        }
        if (this.ci == 10) {
            ++this.line;
            this.charPos = 0;
        }
        return this.ci;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void nextParsedChar() throws IOException {
        this.nextChar();
        if (this.ci == 38) {
            this.nextChar();
            switch (this.ci) {
                case 108: {
                    if (this.nextChar() != 116 || this.nextChar() != 59) {
                        throw this.getXMLScanException("error in \"&lt;\" reference (char:" + (char)this.ci + ") ");
                    }
                    this.ch = (char)60;
                    return;
                }
                case 103: {
                    if (this.nextChar() != 116 || this.nextChar() != 59) {
                        throw this.getXMLScanException("error in \"&gt;\" reference(char:" + (char)this.ci + ") ");
                    }
                    this.ch = (char)62;
                    return;
                }
                case 113: {
                    if (this.nextChar() != 117 || this.nextChar() != 111 || this.nextChar() != 116 || this.nextChar() != 59) {
                        throw this.getXMLScanException("error in \"&quot;\"  ");
                    }
                    this.ch = (char)34;
                    return;
                }
                case 97: {
                    this.nextChar();
                    if (this.ci == 109) {
                        if (this.nextChar() != 112 || this.nextChar() != 59) {
                            throw this.getXMLScanException("error in \"&amp;\" reference(char:" + (char)this.ci + ") ");
                        }
                        this.ch = (char)38;
                        return;
                    } else {
                        if (this.ci != 112) throw this.getXMLScanException("error in \"$amp;\" or \"&apos;\" reference(char:" + (char)this.ci + ") ");
                        if (this.nextChar() != 111 || this.nextChar() != 115 || this.nextChar() != 59) {
                            throw this.getXMLScanException("error in \"&apos;\" reference(char:" + (char)this.ci + ") ");
                        }
                        this.ch = (char)39;
                    }
                    return;
                }
                default: {
                    throw this.getXMLScanException("unexpected character after '&'(char:" + (char)this.ci + ") ");
                }
            }
        }
        this.ch = (char)this.ci;
    }

    private void setTokenPos() {
        this.tokenLine = this.line;
        this.tokenCharPos = this.charPos;
        if (this.ci == -2) {
            ++this.tokenCharPos;
        }
    }

    private void clearBuffer(StringBuilder b) {
        b.delete(0, b.length());
    }

    private void pushTag(String tag, int namespaceDeclarationCount) {
        this.tagStack.add(tag);
        this.xmlnsCountStack.add(namespaceDeclarationCount);
    }

    private String topTag() {
        if (this.tagStack.isEmpty()) {
            return "";
        }
        return this.tagStack.get(this.tagStack.size() - 1);
    }

    private void popTag(String tag) {
        if (this.tagStack.isEmpty()) {
            String msg = "XML document not wellformed: ETAG \"" + tag + "\" without corresponding STAG";
            throw this.getXMLScanException(msg);
        }
        int topIndex = this.tagStack.size() - 1;
        String top = this.tagStack.get(topIndex);
        int namespaceDeclarationCount = this.xmlnsCountStack.get(topIndex);
        this.tagStack.remove(topIndex);
        this.xmlnsCountStack.remove(topIndex);
        for (int i = 0; i < namespaceDeclarationCount; ++i) {
            XMLNameSpace ns = this.namespaceStack.popXMLNameSpace();
            if (ns.getPrefix() != "") continue;
            this.defaultNamespace = null;
        }
        if (!top.equals(tag)) {
            throw this.getXMLScanException("XML document not wellformed: \"/" + tag + "\" read, while expecting: /" + top);
        }
    }

    private void checkEmptyTagStack() {
        int stackSize = this.tagStack.size();
        if (stackSize > 0) {
            throw this.getXMLScanException("XML document not wellformed: Open tag " + this.tagStack.get(stackSize - 1) + " at end of document");
        }
    }

    public final void setpopOnEndOfDocument(boolean mode) {
        this.popOnEndOfDocument = mode;
    }

    public final boolean getpopOnEndOfDocument() {
        return this.popOnEndOfDocument;
    }

    public static String tokenString(int token) {
        switch (token) {
            case 0: {
                return "NULLTOKEN";
            }
            case 1: {
                return "STAG";
            }
            case 4: {
                return "ETAG";
            }
            case 8: {
                return "CHARDATA";
            }
            case 9: {
                return "CDSECT";
            }
            case 10: {
                return "COMMENT";
            }
            case 11: {
                return "PI";
            }
            case 12: {
                return "DECL";
            }
            case 13: {
                return "DocType";
            }
            case 14: {
                return "ENDOFDOCUMENT";
            }
            case 15: {
                return "XML Error";
            }
        }
        return "";
    }

    public static void setDebug(boolean mode) {
        debug = mode;
    }

    public final void setDefaultModes() {
        this.skipDoctype = true;
        this.skipComment = true;
        this.skipPI = true;
        this.recognizeNamespaces = true;
    }

    private void initState() {
        this.ci = -2;
        if (this.in == null) {
            this.token = 14;
            this.tokenMode = 5;
        } else {
            this.token = 0;
            this.tokenMode = 1;
        }
        this.tokenConsumed = true;
        this.tokenBuffered = false;
        this.line = 1;
        this.charPos = 0;
        this.setTokenPos();
    }

    public final void pushState() {
        if (this.tokenizerStateStack == null) {
            this.tokenizerStateStack = new ArrayList();
        }
        TokenizerState currentState = new TokenizerState();
        currentState.copyState();
        this.tokenizerStateStack.add(currentState);
    }

    public final void popState() {
        int stackSize = this.tokenizerStateStack.size();
        TokenizerState savedState = this.tokenizerStateStack.get(stackSize - 1);
        this.tokenizerStateStack.remove(stackSize - 1);
        savedState.restoreState();
    }

    public final void showTokenizerStack() {
        this.showTokenizerStack("TokenizerStack:\n");
    }

    public final void showTokenizerStack(String message) {
        if (this.tokenizerStateStack == null) {
            logger.info("Null TokenizerStateStack");
        } else {
            logger.info(message + "\n" + this.tokenizerStateStack.toString());
        }
    }

    public final void showTokenizerState() {
        this.showTokenizerState("TokenizerState:\n");
    }

    public final void showTokenizerState(String message) {
        TokenizerState currentState = new TokenizerState();
        currentState.copyState();
        logger.info(message + currentState);
    }

    private class TokenizerState {
        private BufferedReader inState;
        private URL urlState;
        private File fileState;
        private int ciState;
        private char chState;
        private int lineState;
        private int charPosState;
        private int tokenCharPosState;
        private int tokenState;
        private int tokenModeState;
        private boolean tokenConsumedState;
        private boolean tokenBufferedState;
        private String tagNameState;
        private String namespaceState;
        private boolean popOnEndOfDocumentState;

        private TokenizerState() {
        }

        void copyState() {
            this.inState = XMLTokenizer.this.in;
            this.urlState = XMLTokenizer.this.url;
            this.fileState = XMLTokenizer.this.file;
            this.ciState = XMLTokenizer.this.ci;
            this.chState = XMLTokenizer.this.ch;
            this.lineState = XMLTokenizer.this.line;
            this.charPosState = XMLTokenizer.this.charPos;
            this.tokenCharPosState = XMLTokenizer.this.tokenCharPos;
            this.tokenState = XMLTokenizer.this.token;
            this.tokenModeState = XMLTokenizer.this.tokenMode;
            this.tokenConsumedState = XMLTokenizer.this.tokenConsumed;
            this.tokenBufferedState = XMLTokenizer.this.tokenBuffered;
            this.tagNameState = XMLTokenizer.this.tagName;
            this.namespaceState = XMLTokenizer.this.tagNamespace;
            this.popOnEndOfDocumentState = XMLTokenizer.this.popOnEndOfDocument;
        }

        public void restoreState() {
            XMLTokenizer.this.in = this.inState;
            XMLTokenizer.this.url = this.urlState;
            XMLTokenizer.this.file = this.fileState;
            XMLTokenizer.this.ci = this.ciState;
            XMLTokenizer.this.ch = this.chState;
            XMLTokenizer.this.line = this.lineState;
            XMLTokenizer.this.charPos = this.charPosState;
            XMLTokenizer.this.tokenCharPos = this.tokenCharPosState;
            XMLTokenizer.this.token = this.tokenState;
            XMLTokenizer.this.tokenMode = this.tokenModeState;
            XMLTokenizer.this.tagName = this.tagNameState;
            XMLTokenizer.this.tagNamespace = this.namespaceState;
            XMLTokenizer.this.tokenConsumed = this.tokenConsumedState;
            XMLTokenizer.this.tokenBuffered = this.tokenBufferedState;
            XMLTokenizer.this.popOnEndOfDocument = this.popOnEndOfDocumentState;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("[");
            buf.append("url: ");
            buf.append(this.urlState);
            buf.append("file: ");
            buf.append(this.fileState);
            buf.append(" ch: ");
            buf.append(this.chState);
            buf.append(" ci: ");
            buf.append(this.ciState);
            buf.append(" line: ");
            buf.append(this.lineState);
            buf.append(" charPos: ");
            buf.append(this.charPosState);
            buf.append(" tokenCharPos: ");
            buf.append(this.tokenCharPosState);
            buf.append(" token: ");
            buf.append(XMLTokenizer.tokenString(this.tokenState));
            buf.append(" tagName: ");
            buf.append(this.tagNameState);
            buf.append(" consumed: ");
            buf.append(this.tokenConsumedState);
            buf.append(" buffered: ");
            buf.append(this.tokenBufferedState);
            buf.append(" popEOD: ");
            buf.append(this.popOnEndOfDocumentState);
            buf.append(']');
            return buf.toString();
        }
    }
}

