/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml;

import hmi.xml.XMLNameSpace;
import hmi.xml.XMLNameSpaceStack;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLFormatting {
    private ArrayList<Integer> tabStack = new ArrayList();
    private XMLNameSpaceStack namespaceStack = new XMLNameSpaceStack();
    public static final int TAB = 3;
    private int tab;
    private int tabIncrement = 3;
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.xml.XMLStructure");

    public XMLFormatting() {
    }

    public XMLFormatting(int tab) {
        this.tab = tab;
    }

    public int getTab() {
        return this.tab;
    }

    public int getIndentedTab() {
        return this.tab + this.tabIncrement;
    }

    public void setTabIncrement(int increment) {
        this.tabIncrement = increment;
    }

    public int getTabIncrement() {
        return this.tabIncrement;
    }

    public String getNamespacePrefix(String namespace) {
        return this.namespaceStack.getPrefix(namespace);
    }

    public XMLFormatting pushXMLNameSpace(XMLNameSpace xmlNamespace) {
        this.namespaceStack.pushXMLNameSpace(xmlNamespace);
        return this;
    }

    public XMLFormatting popXMLNameSpace() {
        this.namespaceStack.popXMLNameSpace();
        return this;
    }

    public XMLFormatting indent(int tabIncrement) {
        this.tabStack.add(this.tab);
        this.tab += tabIncrement;
        return this;
    }

    public XMLFormatting unIndent() {
        int topindex = this.tabStack.size() - 1;
        if (topindex >= 0) {
            this.tab = this.tabStack.get(topindex);
            this.tabStack.remove(topindex);
        } else {
            topindex = 0;
            logger.warn("XMLFormatting.unIndent: negative indent level");
        }
        return this;
    }

    public XMLFormatting indent() {
        return this.indent(this.tabIncrement);
    }
}

