/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class XMLAttributeMap
implements XMLStructure {
    private static final int ENCODEBUFSIZE = 100;
    private LinkedHashMap<String, Object> attr;
    private static final int BUFLEN = 40;
    private String encoding;
    private StringBuilder buf;
    public static final int TAB = 3;
    public static final String ATTRIBUTEMAPTAG = "AttributeMap";
    private static final String XMLTAG = "AttributeMap";
    public static final String CLASSNAME = "parlevink.xml.XMLAttributeMap";
    public static final String WRAPPEDCLASSNAME = "parlevink.xml.XMLAttributeMap";

    public XMLAttributeMap() {
        this.attr = new LinkedHashMap();
    }

    public XMLAttributeMap(int initialCapacity) {
        this.attr = new LinkedHashMap(initialCapacity);
    }

    public Object setAttribute(String key, Object value) {
        return this.attr.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attr.get(key);
    }

    public Object setString(String key, String value) {
        return this.attr.put(key, value);
    }

    public String getString(String key) {
        return (String)this.attr.get(key);
    }

    public boolean hasAttribute(String key) {
        return this.attr.get(key) != null;
    }

    public Iterator<String> attributeNames() {
        return this.attr.keySet().iterator();
    }

    public Iterator<Object> attributeValues() {
        return this.attr.values().iterator();
    }

    protected Iterator<Map.Entry<String, Object>> iterator() {
        return this.attr.entrySet().iterator();
    }

    private void appendSpace(StringBuilder buf, int nsp) {
        for (int i = 0; i < nsp; ++i) {
            buf.append(' ');
        }
    }

    private void encode(int tab) {
        this.clearBuf(100);
        this.appendSpace(this.buf, tab);
        this.buf.append("<");
        this.buf.append(this.getXMLTag());
        this.buf.append(">");
        Iterator<Map.Entry<String, Object>> iter = this.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> elem = iter.next();
            String idStr = elem.getKey().toString();
            this.buf.append('\n');
            this.appendSpace(this.buf, tab + 3);
            this.buf.append("<Attribute id=\"");
            this.buf.append(idStr);
            this.buf.append('\"');
            Object attrValue = elem.getValue();
            if (attrValue instanceof String) {
                this.buf.append(" String=\"");
                this.buf.append(attrValue);
                this.buf.append("\"/>");
                continue;
            }
            if (attrValue instanceof Integer) {
                this.buf.append(" Integer=\"");
                this.buf.append(attrValue);
                this.buf.append("\"/>");
                continue;
            }
            if (attrValue instanceof Long) {
                this.buf.append(" Long=\"");
                this.buf.append(attrValue);
                this.buf.append("\"/>");
                continue;
            }
            if (attrValue instanceof Float) {
                this.buf.append(" Float=\"");
                this.buf.append(attrValue);
                this.buf.append("\"/>");
                continue;
            }
            if (attrValue instanceof Double) {
                this.buf.append(" Double=\"");
                this.buf.append(attrValue);
                this.buf.append("\"/>");
                continue;
            }
            if (attrValue instanceof Boolean) {
                this.buf.append(" Boolean=\"");
                this.buf.append(attrValue);
                this.buf.append("\"/>");
                continue;
            }
            this.buf.append(">\n");
            this.appendSpace(this.buf, tab + 3);
            this.buf.append("</Attribute>");
        }
        this.buf.append('\n');
        this.appendSpace(this.buf, tab);
        this.buf.append("</");
        this.buf.append(this.getXMLTag());
        this.buf.append(">");
        this.encoding = this.buf.toString();
    }

    @Override
    public XMLStructure readXML(String s) {
        return this.readXML(new XMLTokenizer(s));
    }

    @Override
    public XMLStructure readXML(Reader in) throws IOException {
        if (in instanceof BufferedReader) {
            return this.readXML(new XMLTokenizer((BufferedReader)in));
        }
        return this.readXML(new XMLTokenizer(new BufferedReader(in)));
    }

    @Override
    public XMLStructure readXML(XMLTokenizer tokenizer) {
        this.attr.clear();
        try {
            tokenizer.takeSTag(this.getXMLTag());
            while (tokenizer.atSTag()) {
                HashMap<String, String> xmlAttributes = tokenizer.getAttributes();
                Iterator<Map.Entry<String, String>> iter = xmlAttributes.entrySet().iterator();
                String idStr = null;
                Object value = null;
                while (iter.hasNext()) {
                    Map.Entry<String, String> e = iter.next();
                    String as = e.getKey();
                    String stringVal = e.getValue();
                    if (as.equals("id")) {
                        idStr = stringVal;
                        continue;
                    }
                    if (as.equals("String") || as.equals("value")) {
                        value = stringVal;
                        continue;
                    }
                    if (as.equals("Integer") || as.equals("int")) {
                        value = Integer.valueOf(stringVal);
                        continue;
                    }
                    if (as.equals("Long") || as.equals("long")) {
                        value = Long.valueOf(stringVal);
                        continue;
                    }
                    if (as.equals("Float") || as.equals("float")) {
                        value = Float.valueOf(stringVal);
                        continue;
                    }
                    if (as.equals("Double") || as.equals("double")) {
                        value = Double.valueOf(stringVal);
                        continue;
                    }
                    if (!as.equals("Boolean") && !as.equals("boolean") && !as.equals("bool")) continue;
                    value = Boolean.valueOf(stringVal);
                }
                tokenizer.takeSTag();
                if (idStr == null) {
                    throw new RuntimeException("\"id\" attribute missing in Attribute tag");
                }
                tokenizer.takeETag("Attribute");
                this.attr.put(idStr, value);
            }
            tokenizer.takeETag(this.getXMLTag());
        }
        catch (IOException e) {
            throw new RuntimeException("XMLAttributeMap: " + e);
        }
        return this;
    }

    @Override
    public void writeXML(PrintWriter out) {
        this.encode(0);
        out.write(this.encoding);
    }

    @Override
    public void writeXML(PrintWriter out, int tab) {
        this.encode(tab);
        out.write(this.encoding);
    }

    @Override
    public void writeXML(PrintWriter out, XMLFormatting fmt) {
        this.encode(fmt.getTab());
        out.write(this.encoding);
    }

    @Override
    public StringBuilder appendXML(StringBuilder buf) {
        this.encode(0);
        buf.append(this.encoding);
        return buf;
    }

    @Override
    public StringBuilder appendXML(StringBuilder buf, XMLFormatting fmt) {
        return this.appendXML(buf, fmt.getTab());
    }

    @Override
    public StringBuilder appendXML(StringBuilder buf, int tab) {
        this.encode(tab);
        buf.append(this.encoding);
        return buf;
    }

    @Override
    public String toXMLString() {
        this.encode(0);
        return this.encoding;
    }

    @Override
    public String toXMLString(XMLFormatting fmt) {
        return this.toXMLString(fmt.getTab());
    }

    @Override
    public String toXMLString(int tab) {
        this.encode(tab);
        return this.encoding;
    }

    public String toString() {
        return this.toXMLString();
    }

    public boolean equals(Object attributeMap) {
        if (attributeMap == null) {
            return false;
        }
        if (attributeMap instanceof XMLAttributeMap) {
            LinkedHashMap<String, Object> attr2 = ((XMLAttributeMap)attributeMap).attr;
            return this.attr.equals(attr2);
        }
        return false;
    }

    public int hashCode() {
        return this.attr.hashCode();
    }

    private void clearBuf(int len) {
        if (this.buf == null) {
            this.buf = new StringBuilder(len);
        } else {
            this.buf.delete(0, this.buf.length());
        }
    }

    @Override
    public String getXMLTag() {
        return "AttributeMap";
    }

    public static String xmlTag() {
        return "AttributeMap";
    }
}

