/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml.wrap;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import hmi.xml.wrap.XMLWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class XMLBasicValue<T>
implements XMLWrapper<T> {
    private String encoding;
    private StringBuilder buffer;
    private int ciPos;
    private int ci;
    private int bufLen;
    private int curtab;
    public static final int BUFFERSIZE = 25;
    private static final int EOS = -1;

    @Override
    public String getXMLTag() {
        return null;
    }

    @Override
    public T unwrap() {
        return null;
    }

    private void clearBuffer(int len) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder(len);
        } else {
            this.buffer.delete(0, this.buffer.length());
            if (len > this.buffer.length()) {
                this.buffer.ensureCapacity(len);
            }
        }
    }

    protected void appendSpace(int nsp) {
        int i = 0;
        while (i < nsp) {
            this.buffer.append(' ');
            ++i;
        }
    }

    private void decode() {
        int tagEnd;
        this.ciPos = 0;
        this.ci = this.buffer.charAt(this.ciPos);
        this.bufLen = this.buffer.length();
        if (this.ci != 60) {
            throw new RuntimeException("Missing < character at start of XMLBasicValue");
        }
        String xmlTag = this.getXMLTag();
        if (!xmlTag.equals(this.buffer.substring(1, tagEnd = xmlTag.length() + 1))) {
            throw new RuntimeException("Wrong XML tag in XMLBasicValue: " + this.buffer);
        }
        this.ciPos = tagEnd;
        this.nextChar();
        this.skipSpaceChars();
        while (this.ci != 47 && this.ci != -1) {
            String attrName = this.getAttributeName();
            String attrValue = this.getAttributeValue();
            this.decodeAttribute(attrName, attrValue, null);
            this.skipSpaceChars();
        }
        if (this.ci == -1) {
            throw new RuntimeException("Missing / character at end of XMLBasicValue");
        }
        this.nextChar();
        if (this.ci != 62) {
            throw new RuntimeException("Missing > character at end of XMLBasicValue");
        }
        this.nextChar();
        this.skipSpaceChars();
        if (this.ci != -1) {
            throw new RuntimeException("extra characters at end of XMLBasicValue");
        }
    }

    @Override
    public XMLStructure readXML(Reader in) throws IOException {
        this.clearBuffer(25);
        int ci = in.read();
        this.buffer.append((char)ci);
        ci = in.read();
        while (ci != -1 && ci != 60) {
            this.buffer.append((char)ci);
            ci = in.read();
        }
        this.decode();
        return this;
    }

    @Override
    public XMLStructure readXML(String s) {
        this.buffer = new StringBuilder(s);
        this.decode();
        return this;
    }

    @Override
    public XMLStructure readXML(XMLTokenizer tokenizer) {
        try {
            if (!tokenizer.atSTag(this.getXMLTag())) {
                throw tokenizer.getXMLScanException("Erroneous XML encoding, expected: " + this.getXMLTag() + ", encountered: " + tokenizer.getTagName());
            }
            HashMap<String, String> attrMap = tokenizer.getAttributes();
            for (Map.Entry<String, String> attr : attrMap.entrySet()) {
                this.decodeAttribute(attr.getKey(), attr.getValue(), tokenizer);
            }
            tokenizer.takeSTag();
            tokenizer.takeETag();
            return this;
        }
        catch (IOException e) {
            throw tokenizer.getXMLScanException("IOException in XMLTokenizer: " + e);
        }
    }

    @Override
    public void writeXML(PrintWriter out) {
        out.write(this.toXMLString(0));
    }

    @Override
    public void writeXML(PrintWriter out, int tab) {
        out.write(this.toXMLString(tab));
    }

    @Override
    public void writeXML(PrintWriter out, XMLFormatting fmt) {
        out.write(this.toXMLString(fmt.getTab()));
    }

    @Override
    public StringBuilder appendXML(StringBuilder buf) {
        buf.append(this.toXMLString(0));
        return buf;
    }

    @Override
    public StringBuilder appendXML(StringBuilder buf, int tab) {
        buf.append(this.toXMLString(tab));
        return buf;
    }

    @Override
    public StringBuilder appendXML(StringBuilder buf, XMLFormatting fmt) {
        buf.append(this.toXMLString(fmt.getTab()));
        return buf;
    }

    @Override
    public String toXMLString() {
        return this.toXMLString(0);
    }

    @Override
    public String toXMLString(int tab) {
        if (this.encoding != null && this.curtab == tab) {
            return this.encoding;
        }
        this.clearBuffer(25);
        this.curtab = tab;
        this.appendSpace(tab);
        this.buffer.append('<');
        this.buffer.append(this.getXMLTag());
        this.buffer.append(' ');
        this.appendAttributeString(this.buffer);
        this.buffer.append("/>");
        this.encoding = this.buffer.toString();
        return this.encoding;
    }

    @Override
    public String toXMLString(XMLFormatting fmt) {
        return this.toXMLString(fmt.getTab());
    }

    public String toAttributeString() {
        return this.appendAttributeString(new StringBuilder()).toString();
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        return buf;
    }

    public StringBuilder appendAttribute(StringBuilder buf, String attrName, String attrValue) {
        buf.append(attrName);
        buf.append("=\"");
        buf.append(attrValue);
        buf.append('\"');
        return buf;
    }

    public StringBuilder appendAttribute(StringBuilder buf, String attrName, Object attrValue) {
        buf.append(attrName);
        buf.append("=\"");
        buf.append(attrValue.toString());
        buf.append('\"');
        return buf;
    }

    public void decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
    }

    public void decodeAttribute(String attrName, String attrValue) {
    }

    protected final String getAttributeValue() {
        this.skipSpaceChars();
        if (this.ci != 61) {
            throw new RuntimeException("'=' character expected in attribute");
        }
        this.nextChar();
        if (this.ci != 34 && this.ci != 39) {
            throw new RuntimeException("\" or ' character expected at start of attribute value");
        }
        boolean aposmode = this.ci == 39;
        this.nextChar();
        int valStart = this.ciPos;
        while (!(!aposmode && this.ci == 34 || aposmode && this.ci == 39 || this.ci == -1)) {
            this.nextChar();
        }
        if (this.ci == -1) {
            throw new RuntimeException("\" or ' character expected at end of attribute value");
        }
        int valEnd = this.ciPos;
        this.nextChar();
        return this.buffer.substring(valStart, valEnd);
    }

    protected final String getAttributeName() {
        this.skipSpaceChars();
        if (!this.isNameChar()) {
            throw new RuntimeException("XMLBasicValue: Attribute name expected");
        }
        int nameStart = this.ciPos;
        while (this.isNameChar()) {
            this.nextChar();
        }
        if (this.ci == -1) {
            throw new RuntimeException("\" or ' character expected at end of attribute value");
        }
        int nameEnd = this.ciPos;
        return this.buffer.substring(nameStart, nameEnd);
    }

    private void skipSpaceChars() {
        while (this.ci == 32 || this.ci == 10 || this.ci == 9 || this.ci == 13) {
            int n = this.ci = ++this.ciPos < this.bufLen ? (int)this.buffer.charAt(this.ciPos) : -1;
        }
    }

    private boolean isNameChar() {
        return 97 <= this.ci && this.ci <= 122 || 65 <= this.ci && this.ci <= 90 || 48 <= this.ci && this.ci <= 57 || this.ci == 95 || this.ci == 45 || this.ci == 46 || this.ci == 58;
    }

    private int nextChar() {
        this.ci = ++this.ciPos < this.bufLen ? (int)this.buffer.charAt(this.ciPos) : -1;
        return this.ci;
    }
}

