/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml;

import hmi.util.Resources;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XMLTokenizerTest {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void basics() {
        XMLTokenizer tokenizer = new XMLTokenizer();
    }

    @Test
    public void basics2() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader basictest1 = testRes.getReader("basictest1.xml");
        Assert.assertTrue((basictest1 != null ? 1 : 0) != 0);
        XMLTokenizer tokenizer = new XMLTokenizer(basictest1);
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("tg"));
            tokenizer.takeSTag("tg");
            Assert.assertTrue((boolean)tokenizer.atCharData());
            tokenizer.takeCharData();
            Assert.assertTrue((boolean)tokenizer.atETag("tg"));
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atCharData());
            tokenizer.takeCharData();
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("XMLTokenizerTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testFileConstructor() {
        String udir = System.getProperty("user.dir");
        System.out.println("user.dir = " + udir);
        File testFile = new File(String.valueOf(udir) + "/test/resource/XmlTokenizerTests/basictest1.xml");
        try {
            XMLTokenizer tokenizer = new XMLTokenizer(testFile);
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("tg"));
            tokenizer.takeSTag("tg");
            Assert.assertTrue((boolean)tokenizer.atCharData());
            tokenizer.takeCharData();
            Assert.assertTrue((boolean)tokenizer.atETag("tg"));
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atCharData());
            tokenizer.takeCharData();
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("XMLTokenizerTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void namespace1a() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader namespacetest1 = testRes.getReader("namespacetest1.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(namespacetest1);
        tokenizer.setRecognizeNamespaces(false);
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("ns:test"));
            tokenizer.takeSTag("ns:test");
            Assert.assertTrue((boolean)tokenizer.atSTag("ns:innertag"));
            tokenizer.takeSTag("ns:innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("ns:innertag"));
            tokenizer.takeETag("ns:innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("ns:test"));
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("XMLTokenizerTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void namespace1b() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader namespacetest1 = testRes.getReader("namespacetest1.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(namespacetest1);
        tokenizer.setRecognizeNamespaces(true);
        String expectedNamespace = "http://hmi.ns.test";
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNamespace ? 1 : 0) != 0);
            tokenizer.takeETag("innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("XMLTokenizerTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void namespace2() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader namespacetest2 = testRes.getReader("namespacetest2.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(namespacetest2);
        tokenizer.setRecognizeNamespaces(true);
        String expectedNamespace = "http://hmi.ns.test";
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNamespace ? 1 : 0) != 0);
            tokenizer.takeETag("innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("XMLTokenizerTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void namespace3() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader namespacetest3 = testRes.getReader("namespacetest3.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(namespacetest3);
        tokenizer.setRecognizeNamespaces(true);
        String expectedDefaultNamespace = "http://hmi.ns.test";
        String expectedNSNamespace = "ns-namespace";
        String expectedEXNamespace = "ex-namespace";
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNSNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNSNamespace ? 1 : 0) != 0);
            tokenizer.takeETag("innertag");
            Assert.assertTrue((boolean)tokenizer.atSTag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag("innertag");
            Assert.assertTrue((boolean)tokenizer.atSTag("sometag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("sometag");
            Assert.assertTrue((boolean)tokenizer.atETag("sometag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atSTag("extratag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedEXNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("extratag");
            Assert.assertTrue((boolean)tokenizer.atETag("extratag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedEXNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("XMLTokenizerTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void namespace5() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader namespacetest5 = testRes.getReader("namespacetest5.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(namespacetest5);
        tokenizer.setRecognizeNamespaces(true);
        String expectedDefaultNamespace = "default-namespace";
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == null ? 1 : 0) != 0);
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("innertag");
            Assert.assertTrue((boolean)tokenizer.atSTag("sometag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("sometag");
            tokenizer.takeETag("sometag");
            Assert.assertTrue((boolean)tokenizer.atETag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag("innertag");
            Assert.assertTrue((boolean)tokenizer.atSTag("nonamespace"));
            Assert.assertTrue((tokenizer.getNamespace() == null ? 1 : 0) != 0);
            tokenizer.takeSTag("nonamespace");
            Assert.assertTrue((boolean)tokenizer.atSTag("sometag"));
            Assert.assertTrue((tokenizer.getNamespace() == null ? 1 : 0) != 0);
            tokenizer.takeSTag("sometag");
            tokenizer.takeETag("sometag");
            Assert.assertTrue((boolean)tokenizer.atETag("nonamespace"));
            Assert.assertTrue((tokenizer.getNamespace() == null ? 1 : 0) != 0);
            tokenizer.takeETag("nonamespace");
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == null ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("XMLTokenizerTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void attributeNamespace() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader attributeNamespacetest = testRes.getReader("attributeNamespacetest.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(attributeNamespacetest);
        tokenizer.setRecognizeNamespaces(true);
        String expectedDefaultNamespace = "http://hmi.ns.test";
        String expectedNSNamespace = "ns-namespace";
        String expectedEXNamespace = "ex-namespace";
        String expectedAttr0 = "value0";
        String expectedAttr1 = "value1";
        String expectedAttr2NS = "value2";
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNSNamespace ? 1 : 0) != 0);
            String val0 = tokenizer.getAttribute(String.valueOf(expectedNSNamespace) + ":atr0");
            Assert.assertTrue((val0 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)val0.equals(expectedAttr0));
            String val1 = tokenizer.getAttribute("atr1");
            Assert.assertTrue((val1 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)val1.equals(expectedAttr1));
            String val2 = tokenizer.getAttribute(String.valueOf(expectedNSNamespace) + ":atr2");
            Assert.assertTrue((val2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)val2.equals(expectedAttr2NS));
            tokenizer.takeSTag("innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedNSNamespace ? 1 : 0) != 0);
            tokenizer.takeETag("innertag");
            Assert.assertTrue((boolean)tokenizer.atSTag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("innertag");
            Assert.assertTrue((boolean)tokenizer.atETag("innertag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag("innertag");
            Assert.assertTrue((boolean)tokenizer.atSTag("sometag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("sometag");
            Assert.assertTrue((boolean)tokenizer.atETag("sometag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atSTag("extratag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedEXNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("extratag");
            Assert.assertTrue((boolean)tokenizer.atETag("extratag"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedEXNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("XMLTokenizerTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void skipTagTest() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader xmlsection = testRes.getReader("getXMLSectionTest.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(xmlsection);
        tokenizer.setRecognizeNamespaces(true);
        String expectedDefaultNamespace = "http://hmi.ns.test";
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("preamble"));
            tokenizer.takeSTag("preamble");
            Assert.assertTrue((boolean)tokenizer.atCharData());
            tokenizer.takeCharData();
            tokenizer.takeSTag("nested");
            tokenizer.takeETag("nested");
            tokenizer.takeETag("preamble");
            Assert.assertTrue((boolean)tokenizer.atSTag("skippedtag"));
            tokenizer.skipTag();
            Assert.assertTrue((boolean)tokenizer.atSTag("moretags"));
            tokenizer.takeSTag();
            tokenizer.takeCharData();
            tokenizer.takeETag("moretags");
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("skipTagTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void getXMLSectionTest() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader xmlsection = testRes.getReader("getXMLSectionTest.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(xmlsection);
        tokenizer.setRecognizeNamespaces(true);
        String expectedDefaultNamespace = "http://hmi.ns.test";
        String expectedSection = "<ns:skippedtag attr=\"val\" xmlns:ns=\"http://ns\">\r\n      <innertag> chardata \r\n         <nestedtag> chardata\r\n             <ns:skippedtag>\r\n                 more data\r\n             </ns:skippedtag>\r\n         </nestedtag>\r\n      </innertag>\r\n      <sometag xmlns:some=\"some-namespace\"/>\r\n      <ns:extratag > moredata </ns:extratag>\r\n   </ns:skippedtag>";
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("preamble"));
            tokenizer.takeSTag("preamble");
            Assert.assertTrue((boolean)tokenizer.atCharData());
            tokenizer.takeCharData();
            tokenizer.takeSTag("nested");
            tokenizer.takeETag("nested");
            tokenizer.takeETag("preamble");
            Assert.assertTrue((boolean)tokenizer.atSTag("skippedtag"));
            String skipped = tokenizer.getXMLSection();
            Assert.assertTrue((boolean)skipped.equals(expectedSection));
            Assert.assertTrue((boolean)tokenizer.atSTag("moretags"));
            tokenizer.takeSTag();
            tokenizer.takeCharData();
            tokenizer.takeETag("moretags");
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("getXMLSectionTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void getXMLSectionContentTest() {
        Resources testRes = new Resources("XmlTokenizerTests");
        BufferedReader xmlsection = testRes.getReader("getXMLSectionTest.xml");
        XMLTokenizer tokenizer = new XMLTokenizer(xmlsection);
        tokenizer.setRecognizeNamespaces(true);
        String expectedDefaultNamespace = "http://hmi.ns.test";
        String expectedSection = "      <innertag> chardata \r\n         <nestedtag> chardata\r\n             <ns:skippedtag>\r\n                 more data\r\n             </ns:skippedtag>\r\n         </nestedtag>\r\n      </innertag>\r\n      <sometag xmlns:some=\"some-namespace\"/>\r\n      <ns:extratag > moredata </ns:extratag>\r\n";
        try {
            Assert.assertTrue((boolean)tokenizer.atSTag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeSTag("test");
            Assert.assertTrue((boolean)tokenizer.atSTag("preamble"));
            tokenizer.takeSTag("preamble");
            Assert.assertTrue((boolean)tokenizer.atCharData());
            tokenizer.takeCharData();
            tokenizer.takeSTag("nested");
            tokenizer.takeETag("nested");
            tokenizer.takeETag("preamble");
            Assert.assertTrue((boolean)tokenizer.atSTag("skippedtag"));
            String skipped = tokenizer.getXMLSectionContent();
            Assert.assertTrue((boolean)skipped.equals(expectedSection));
            tokenizer.takeETag("skippedtag");
            Assert.assertTrue((boolean)tokenizer.atSTag("moretags"));
            tokenizer.takeSTag();
            tokenizer.takeCharData();
            tokenizer.takeETag("moretags");
            Assert.assertTrue((boolean)tokenizer.atETag("test"));
            Assert.assertTrue((tokenizer.getNamespace() == expectedDefaultNamespace ? 1 : 0) != 0);
            tokenizer.takeETag();
            Assert.assertTrue((boolean)tokenizer.atEndOfDocument());
        }
        catch (Exception e) {
            System.out.println("getXMLSectionContentTest: " + e);
            Assert.assertTrue((boolean)false);
        }
    }
}

