/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XMLStructureAdapterTest {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void basics() {
        XMLStructureAdapter xa = new XMLStructureAdapter();
        String xmlEncoding = xa.toXMLString();
        String expectedCoding = "<null>\n</null>";
        Assert.assertTrue((boolean)xmlEncoding.equals(expectedCoding));
    }

    @Test
    public void writeTag() {
        XMLStructureAdapter xa = new XMLStructureAdapter(){

            @Override
            public String getXMLTag() {
                return "test";
            }
        };
        String xmlEncoding = xa.toXMLString();
        String expectedCoding = "<test>\n</test>";
        Assert.assertTrue((boolean)xmlEncoding.equals(expectedCoding));
    }

    @Test
    public void writeNamespaceTag() {
        XMLStructureAdapter xa = new XMLStructureAdapter(){

            @Override
            public String getXMLTag() {
                return "test";
            }

            @Override
            public String getNamespace() {
                return "http://hmi.ns.test";
            }
        };
        StringBuilder buf = new StringBuilder();
        XMLFormatting fmt = new XMLFormatting();
        xa.appendXML(buf, fmt, "ns", "http://hmi.ns.test");
        String xmlEncoding = buf.toString();
        String expectedCoding = "<ns:test xmlns:ns=\"http://hmi.ns.test\">\n</ns:test>";
        Assert.assertTrue((boolean)xmlEncoding.equals(expectedCoding));
    }

    @Test
    public void writeNamespaceTag2() {
        XMLStructureAdapter xa = new XMLStructureAdapter(){

            @Override
            public String getXMLTag() {
                return "test";
            }

            @Override
            public String getNamespace() {
                return "http://hmi.ns.test";
            }
        };
        String xmlEncoding = xa.toXMLString("ns", "http://hmi.ns.test");
        String expectedCoding = "<ns:test xmlns:ns=\"http://hmi.ns.test\">\n</ns:test>";
        System.out.println("xa3: \n" + xmlEncoding + "\n expected: \n" + expectedCoding);
        Assert.assertTrue((boolean)xmlEncoding.equals(expectedCoding));
    }

    @Test
    public void writeNamespaceTag3() {
        XMLStructureAdapter xa = new XMLStructureAdapter(){

            @Override
            public String getXMLTag() {
                return "test";
            }

            @Override
            public String getNamespace() {
                return "http://hmi.ns.test";
            }
        };
        String xmlEncoding = xa.toXMLString("ns", "http://hmi.ns.test");
        String expectedCoding = "<ns:test xmlns:ns=\"http://hmi.ns.test\">\n</ns:test>";
        System.out.println("xa3: \n" + xmlEncoding + "\n expected: \n" + expectedCoding);
        Assert.assertTrue((boolean)xmlEncoding.equals(expectedCoding));
    }

    @Test
    public void testDefaultNS() {
        XMLStructureAdapter test = new XMLStructureAdapter(){
            XMLStructureAdapter test1 = new XMLStructureAdapter(){

                @Override
                public String getXMLTag() {
                    return "test1";
                }

                @Override
                public String getNamespace() {
                    return "http://hmi.ns1.test";
                }
            };
            XMLStructureAdapter test2 = new XMLStructureAdapter(){

                @Override
                public String getXMLTag() {
                    return "test2";
                }
            };

            @Override
            public String getXMLTag() {
                return "test";
            }

            @Override
            public void decodeContent(XMLTokenizer tokenizer) throws IOException {
                while (tokenizer.atSTag()) {
                    String tag = tokenizer.getTagName();
                    if (tag.equals("test1")) {
                        this.test1.readXML(tokenizer);
                        continue;
                    }
                    if (!tag.equals("test2")) continue;
                    this.test2.readXML(tokenizer);
                }
            }
        };
        test.readXML("<test><test1  xmlns=\"http://hmi.ns1.test\"></test1><test2/></test>");
    }

    @Test
    public void testAmpInAttribute() {
        class TestAmpXML
        extends XMLStructureAdapter {
            public String attr;
            public static final String XMLTAG = "TestXMLAmp";

            TestAmpXML() {
            }

            @Override
            public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
                this.attr = this.getRequiredAttribute("attr", attrMap, tokenizer);
            }

            @Override
            public String getXMLTag() {
                return XMLTAG;
            }
        }
        TestAmpXML test = new TestAmpXML();
        test.readXML("<TestXMLAmp attr=\"&gt;&amp;&amp;&lt;&quot;\"/>");
        Assert.assertEquals((Object)">&&<\"", (Object)test.attr);
    }
}

