/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml;

import hmi.xml.XMLScanException;

public class CharDataConversion {
    public static String encode(String value) {
        int len = value.length();
        StringBuffer buf = new StringBuffer(len + 10);
        int i = 0;
        while (i < len) {
            char ch = value.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else if (ch == '&') {
                buf.append("&amp;");
            } else if (ch == '\"') {
                buf.append("&quot;");
            } else if (ch == '\'') {
                buf.append("&apos;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String decode(String value) {
        int len = value.length();
        StringBuffer buf = new StringBuffer(len + 10);
        int i = 0;
        while (i < len) {
            char ch;
            if ((ch = value.charAt(i++)) != '&') {
                buf.append(ch);
                continue;
            }
            switch (value.charAt(i++)) {
                case 'l': {
                    if (value.charAt(i++) != 't' || value.charAt(i++) != ';') {
                        throw new XMLScanException("error in \"&lt;\" reference");
                    }
                    buf.append('<');
                    break;
                }
                case 'g': {
                    if (value.charAt(i++) != 't' || value.charAt(i++) != ';') {
                        throw new XMLScanException("error in \"&gt;\" reference");
                    }
                    buf.append('>');
                    break;
                }
                case 'q': {
                    if (value.charAt(i++) != 'u' || value.charAt(i++) != 'o' || value.charAt(i++) != 't' || value.charAt(i++) != ';') {
                        throw new XMLScanException("error in \"&quot;\" reference");
                    }
                    buf.append('\"');
                    break;
                }
                case 'a': {
                    if (value.charAt(i) == 'm') {
                        int n = ++i;
                        ++i;
                        if (value.charAt(n) != 'p' || value.charAt(i++) != ';') {
                            throw new XMLScanException("error in \"&amp;\" reference");
                        }
                        buf.append('&');
                        break;
                    }
                    if (value.charAt(i) == 'p') {
                        int n = ++i;
                        ++i;
                        if (value.charAt(n) != 'o' || value.charAt(i++) != 's' || value.charAt(i++) != ';') {
                            throw new XMLScanException("error in \"&apos;\" reference");
                        }
                        buf.append('\'');
                        break;
                    }
                    throw new XMLScanException("error in \"$amp;\" or \"&apos;\" reference");
                }
                default: {
                    throw new XMLScanException("unexpected character after '&' : " + value.charAt(i - 1));
                }
            }
        }
        return buf.toString();
    }
}

