/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml;

import hmi.xml.XMLFormatting;
import hmi.xml.XMLNameSpace;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructure;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLStructureAdapter
implements XMLStructure {
    public static final boolean DEFAULT_RECOVER_MODE = false;
    private static boolean recoverMode = false;
    private static final String XMLTAG = null;
    private static final String NAMESPACE = null;
    private int tagLine = -1;
    private boolean recover = recoverMode;
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.xml.XMLStructure");
    private static boolean consoleAttributeEnabled = true;
    private static StringBuilder lotsOfSpaces = new StringBuilder("               ");
    public static final int TAB = 3;
    public static final String TAB_STRING = "   ";
    public static final String NEWLINE = "\n";
    public static final String SYSTEMNEWLINE = System.getProperty("line.separator");
    public static final String ATTRIBUTE_TOKEN_DELIMITERS = " \t\n\r\f";
    public static final String LINE_DELIMITERS = "\n\r\f";
    public static final String COMMA_SEPARATOR = ", \t\n\r\f";
    public static final int DECODEDARRAYSIZE = 4;

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public boolean hasContent() {
        return true;
    }

    public final int getTagLine() {
        return this.tagLine;
    }

    public XMLStructure readXML(File inFile) throws IOException {
        return this.readXML(new XMLTokenizer(new BufferedReader(new FileReader(inFile))));
    }

    public XMLStructure readXML(File dir, String fileName) throws IOException {
        return this.readXML(new XMLTokenizer(new BufferedReader(new FileReader(new File(dir, fileName)))));
    }

    @Override
    public XMLStructure readXML(Reader in) throws IOException {
        if (in instanceof BufferedReader) {
            return this.readXML(new XMLTokenizer((BufferedReader)in));
        }
        return this.readXML(new XMLTokenizer(new BufferedReader(in)));
    }

    @Override
    public XMLStructure readXML(String s) {
        try {
            return this.readXML(new StringReader(s));
        }
        catch (IOException e) {
            System.err.println("Unexpected IOException while reading a String: " + e);
            return null;
        }
    }

    public boolean decodeAttribute(String attrName, String attrValue) {
        return this.decodeAttribute(attrName, attrValue, null);
    }

    public boolean decodeAttribute(String attrName, String attrValue, XMLTokenizer tokenizer) {
        String tokenLine;
        String string = tokenLine = tokenizer == null ? "?" : "" + tokenizer.getTokenLine();
        if (consoleAttributeEnabled && attrName.equals("console")) {
            if (attrValue.equals("")) {
                logger.info("XML at line " + tokenLine);
            } else {
                logger.info("XML at line " + tokenLine + ": " + attrValue);
            }
            return true;
        }
        logger.warn(this.getXMLTag() + ": unknown XML attribute at line: " + tokenLine + ", attribute: " + attrName);
        return false;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
    }

    public static void setDefaultRecoverMode(boolean defaultMode) {
        recoverMode = defaultMode;
    }

    public void setRecoverMode(boolean mode) {
        this.recover = mode;
    }

    @Override
    public XMLStructure readXML(XMLTokenizer tokenizer) throws IOException {
        block10: {
            String tag = this.getXMLTag();
            try {
                if (!tokenizer.atSTag(tag)) {
                    if (!tokenizer.atSTag()) {
                        String extraText = "";
                        if (tokenizer.atCharData()) {
                            extraText = ": " + tokenizer.getCharData();
                            if (extraText.length() > 50) {
                                // empty if block
                            }
                            extraText = extraText.substring(0, 50) + " ...";
                        }
                        throw tokenizer.getXMLScanException("Erroneous XML encoding, expected: " + this.getXMLTag() + ", encountered: " + tokenizer.currentTokenString() + extraText);
                    }
                    throw tokenizer.getXMLScanException("Erroneous XML encoding, expected: " + this.getXMLTag() + ", encountered: " + tokenizer.getTagName());
                }
                if (tokenizer.getNamespace() != this.getNamespace()) {
                    throw tokenizer.getXMLScanException("Erroneous XML encoding, expected namespaced: " + this.getNamespace() + ", encountered: " + tokenizer.getNamespace());
                }
                this.preProcess(tokenizer);
                HashMap<String, String> attrMap = tokenizer.getAttributes();
                this.decodeAttributes(attrMap, tokenizer);
                tokenizer.takeSTag();
                this.decodeContent(tokenizer);
                if (tokenizer.atETag(tag)) {
                    tokenizer.takeETag();
                    break block10;
                }
                if (this.recover) {
                    logger.error(tokenizer.getErrorMessage("Expected: </" + tag + ">, skipping tokens..."));
                    boolean recovered = tokenizer.recoverAfterETag(tag);
                    if (recovered) {
                        logger.error(tokenizer.getErrorMessage(" found </" + tag + ">"));
                        break block10;
                    }
                    throw tokenizer.getXMLScanException("Unable to recover, could not find </" + tag + ">");
                }
                throw new XMLScanException(tokenizer.getErrorMessage("Expected: </" + tag + ">"));
            }
            catch (IOException e) {
                throw tokenizer.getXMLScanException("XMLTokenizer IOException: " + e);
            }
        }
        this.postProcess(tokenizer);
        return this;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        for (Map.Entry<String, String> attr : attrMap.entrySet()) {
            this.decodeAttribute(attr.getKey(), attr.getValue(), tokenizer);
        }
    }

    public boolean hasAttribute(String attrName, HashMap<String, String> attrMap) {
        return attrMap.containsKey(attrName);
    }

    public String getRequiredAttribute(String attrName, HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String attrValue = attrMap.get(attrName);
        if (attrValue != null) {
            attrMap.remove(attrName);
            return attrValue;
        }
        if (tokenizer != null) {
            throw tokenizer.getXMLScanException(this.getXMLTag() + " - required attribute missing: " + attrName);
        }
        throw new RuntimeException("XMLElement " + this.getXMLTag() + " - required attribute missing: " + attrName);
    }

    public String getOptionalAttribute(String attrName, HashMap<String, String> attrMap) {
        String attrValue = attrMap.get(attrName);
        if (attrValue != null) {
            attrMap.remove(attrName);
        }
        return attrValue;
    }

    public String getOptionalAttribute(String attrName, HashMap<String, String> attrMap, String defaultValue) {
        String attrValue = attrMap.get(attrName);
        if (attrValue != null) {
            attrMap.remove(attrName);
            return attrValue;
        }
        return defaultValue;
    }

    public int getRequiredIntAttribute(String attrName, HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        return Integer.parseInt(this.getRequiredAttribute(attrName, attrMap, tokenizer));
    }

    public int getOptionalIntAttribute(String attrName, HashMap<String, String> attrMap, int defaultValue) {
        String attrValue = attrMap.get(attrName);
        if (attrValue != null) {
            attrMap.remove(attrName);
            return Integer.parseInt(attrValue);
        }
        return defaultValue;
    }

    public long getRequiredLongAttribute(String attrName, HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        return Long.parseLong(this.getRequiredAttribute(attrName, attrMap, tokenizer));
    }

    public long getOptionalLongAttribute(String attrName, HashMap<String, String> attrMap, long defaultValue) {
        String attrValue = attrMap.get(attrName);
        if (attrValue != null) {
            attrMap.remove(attrName);
            return Long.parseLong(attrValue);
        }
        return defaultValue;
    }

    public float getRequiredFloatAttribute(String attrName, HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        return Float.parseFloat(this.getRequiredAttribute(attrName, attrMap, tokenizer));
    }

    public float getOptionalFloatAttribute(String attrName, HashMap<String, String> attrMap, float defaultValue) {
        String attrValue = attrMap.get(attrName);
        if (attrValue != null) {
            attrMap.remove(attrName);
            return Float.parseFloat(attrValue);
        }
        return defaultValue;
    }

    public double getRequiredDoubleAttribute(String attrName, HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        return Double.parseDouble(this.getRequiredAttribute(attrName, attrMap, tokenizer));
    }

    public double getOptionalDoubleAttribute(String attrName, HashMap<String, String> attrMap, double defaultValue) {
        String attrValue = attrMap.get(attrName);
        if (attrValue != null) {
            attrMap.remove(attrName);
            return Double.parseDouble(attrValue);
        }
        return defaultValue;
    }

    public boolean getRequiredBooleanAttribute(String attrName, HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        return Boolean.valueOf(this.getRequiredAttribute(attrName, attrMap, tokenizer));
    }

    public boolean getOptionalBooleanAttribute(String attrName, HashMap<String, String> attrMap, boolean defaultValue) {
        String attrValue = attrMap.get(attrName);
        if (attrValue != null) {
            attrMap.remove(attrName);
            return Boolean.valueOf(attrValue);
        }
        return defaultValue;
    }

    public void preProcess(XMLTokenizer tokenizer) {
        this.tagLine = tokenizer.getTokenLine();
    }

    public void postProcess(XMLTokenizer tokenizer) {
    }

    public final void writeXML(File outFile) {
        try {
            PrintWriter out = new PrintWriter(outFile);
            StringBuilder buf = new StringBuilder();
            this.appendXML(buf);
            out.print(buf);
            out.println();
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("writeXML: " + e);
        }
    }

    @Override
    public final void writeXML(PrintWriter out) {
        StringBuilder buf = new StringBuilder();
        this.appendXML(buf);
        out.print(buf);
    }

    @Override
    public final void writeXML(PrintWriter out, int tab) {
        this.writeXML(out, new XMLFormatting(tab));
    }

    @Override
    public final void writeXML(PrintWriter out, XMLFormatting fmt) {
        StringBuilder buf = new StringBuilder();
        this.appendXML(buf, fmt);
        out.print(buf);
    }

    public final void writeXML(PrintWriter out, XMLFormatting fmt, XMLNameSpace xmlNamespace) {
        StringBuilder buf = new StringBuilder();
        this.appendXML(buf, fmt, xmlNamespace);
        out.print(buf);
    }

    @Override
    public final String toXMLString() {
        StringBuilder buf = new StringBuilder();
        this.appendXML(buf);
        return buf.toString();
    }

    @Override
    public final String toXMLString(int tab) {
        return this.toXMLString(new XMLFormatting(tab));
    }

    @Override
    public final String toXMLString(XMLFormatting fmt) {
        StringBuilder buf = new StringBuilder();
        this.appendXML(buf, fmt);
        return buf.toString();
    }

    public final String toXMLString(XMLFormatting fmt, XMLNameSpace xmlNamespace) {
        StringBuilder buf = new StringBuilder();
        this.appendXML(buf, fmt, xmlNamespace);
        return buf.toString();
    }

    public final String toXMLString(XMLFormatting fmt, String prefix, String namespace) {
        return this.toXMLString(fmt, new XMLNameSpace(prefix, namespace));
    }

    public final String toXMLString(String prefix, String namespace) {
        return this.toXMLString(new XMLFormatting(), new XMLNameSpace(prefix, namespace));
    }

    public String toString() {
        return this.toXMLString();
    }

    @Override
    public final StringBuilder appendXML(StringBuilder buf, int tab) {
        return this.appendXML(buf, new XMLFormatting(tab));
    }

    public final StringBuilder appendXML(StringBuilder buf, XMLFormatting fmt, String prefix, String namespace) {
        XMLNameSpace xmlNamespace = new XMLNameSpace(prefix, namespace);
        return this.appendXML(buf, fmt, xmlNamespace);
    }

    @Override
    public final StringBuilder appendXML(StringBuilder buf, XMLFormatting fmt) {
        return this.appendXML(buf, fmt, null);
    }

    public StringBuilder appendXML(StringBuilder buf, XMLFormatting fmt, XMLNameSpace xmlNamespace) {
        int tab;
        if (xmlNamespace != null) {
            fmt.pushXMLNameSpace(xmlNamespace);
        }
        if ((tab = fmt.getTab()) > 0) {
            XMLStructureAdapter.appendSpaces(buf, tab);
        }
        buf.append('<');
        String prefix = fmt.getNamespacePrefix(this.getNamespace());
        if (prefix != null) {
            buf.append(prefix);
            buf.append(':');
        }
        String tag = this.getXMLTag();
        buf.append(tag);
        this.appendAttributeString(buf, fmt);
        if (xmlNamespace != null) {
            buf.append(' ');
            buf.append("xmlns:");
            buf.append(xmlNamespace.getPrefix());
            buf.append("=\"");
            buf.append(xmlNamespace.getNamespace());
            buf.append('\"');
        }
        if (this.hasContent()) {
            buf.append('>');
            this.appendContent(buf, fmt.indent());
            fmt.unIndent();
            buf.append('\n');
            if (tab > 0) {
                XMLStructureAdapter.appendSpaces(buf, tab);
            }
            buf.append("</");
            if (prefix != null) {
                buf.append(prefix);
                buf.append(':');
            }
            buf.append(tag);
            buf.append('>');
        } else {
            buf.append("/>");
        }
        if (xmlNamespace != null) {
            fmt.popXMLNameSpace();
        }
        return buf;
    }

    @Override
    public final StringBuilder appendXML(StringBuilder buf) {
        return this.appendXML(buf, 0);
    }

    public StringBuilder appendContent(StringBuilder buf) {
        return buf;
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        return buf;
    }

    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        return this.appendAttributeString(buf);
    }

    public StringBuilder appendAttributeString(StringBuilder buf) {
        this.appendAttributes(buf);
        return buf;
    }

    public StringBuilder appendAttributes(StringBuilder buf) {
        return buf;
    }

    public StringBuilder appendXMLStructure(StringBuilder buf, XMLFormatting fmt, XMLStructure xmlStruct) {
        if (xmlStruct != null) {
            buf.append('\n');
            xmlStruct.appendXML(buf, fmt);
        }
        return buf;
    }

    public static final String spaces(int tab) {
        while (lotsOfSpaces.length() < tab) {
            lotsOfSpaces.append("         ");
        }
        return lotsOfSpaces.substring(0, tab);
    }

    public static final StringBuilder appendSpaces(StringBuilder buf, XMLFormatting fmt) {
        return XMLStructureAdapter.appendSpaces(buf, fmt.getTab());
    }

    public static final StringBuilder appendSpaces(StringBuilder buf, int tab) {
        if (tab <= 0) {
            return buf;
        }
        while (lotsOfSpaces.length() < tab) {
            lotsOfSpaces.append("         ");
        }
        return buf.append(lotsOfSpaces.substring(0, tab));
    }

    public static final StringBuilder appendTab(StringBuilder buf) {
        return buf.append(TAB_STRING);
    }

    public static final StringBuilder appendComment(StringBuilder buf, String comment) {
        buf.append("<!-- ");
        buf.append(comment);
        buf.append(" -->");
        return buf;
    }

    public static final StringBuilder appendOpenSTag(StringBuilder buf, String tagName) {
        buf.append('<');
        buf.append(tagName);
        return buf;
    }

    public static final StringBuilder appendOpenSTag(StringBuilder buf, String tagName, XMLFormatting fmt) {
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt);
        buf.append('<');
        buf.append(tagName);
        return buf;
    }

    public static final StringBuilder appendCloseSTag(StringBuilder buf) {
        buf.append('>');
        return buf;
    }

    public static final StringBuilder appendCloseEmptyTag(StringBuilder buf) {
        buf.append("/>");
        return buf;
    }

    public static final StringBuilder appendSTag(StringBuilder buf, String tagName) {
        buf.append('<');
        buf.append(tagName);
        buf.append('>');
        return buf;
    }

    public static final StringBuilder appendSTag(StringBuilder buf, String tagName, XMLFormatting fmt) {
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt);
        buf.append('<');
        buf.append(tagName);
        buf.append('>');
        return buf;
    }

    public static final StringBuilder appendSTag(StringBuilder buf, String tagName, HashMap attributes) {
        buf.append('<');
        buf.append(tagName);
        if (attributes != null) {
            XMLStructureAdapter.appendAttributes(buf, attributes);
        }
        buf.append('>');
        return buf;
    }

    public static final StringBuilder appendEmptyTag(StringBuilder buf, String tagName) {
        buf.append('<');
        buf.append(tagName);
        buf.append("/>");
        return buf;
    }

    public static final StringBuilder appendEmptyTag(StringBuilder buf, XMLFormatting fmt, String tagName, String attrName, String attrValue) {
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt);
        buf.append('<');
        buf.append(tagName);
        if (attrValue != null) {
            buf.append(' ');
            buf.append(attrName);
            buf.append("=\"");
            buf.append(attrValue);
            buf.append('\"');
        }
        buf.append("/>");
        return buf;
    }

    public static final StringBuilder appendEmptyTag(StringBuilder buf, XMLFormatting fmt, String tagName, String attrName1, String attrValue1, String attrName2, String attrValue2) {
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt);
        buf.append('<');
        buf.append(tagName);
        if (attrValue1 != null) {
            buf.append(' ');
            buf.append(attrName1);
            buf.append("=\"");
            buf.append(attrValue1);
            buf.append('\"');
        }
        if (attrValue2 != null) {
            buf.append(' ');
            buf.append(attrName2);
            buf.append("=\"");
            buf.append(attrValue2);
            buf.append('\"');
        }
        buf.append("/>");
        return buf;
    }

    public static final StringBuilder appendEmptyTag(StringBuilder buf, XMLFormatting fmt, String tagName, String attrName1, String attrValue1, String attrName2, String attrValue2, String attrName3, String attrValue3) {
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt);
        buf.append('<');
        buf.append(tagName);
        if (attrValue1 != null) {
            buf.append(' ');
            buf.append(attrName1);
            buf.append("=\"");
            buf.append(attrValue1);
            buf.append('\"');
        }
        if (attrValue2 != null) {
            buf.append(' ');
            buf.append(attrName2);
            buf.append("=\"");
            buf.append(attrValue2);
            buf.append('\"');
        }
        if (attrValue3 != null) {
            buf.append(' ');
            buf.append(attrName3);
            buf.append("=\"");
            buf.append(attrValue3);
            buf.append('\"');
        }
        buf.append("/>");
        return buf;
    }

    public static final StringBuilder appendEmptyTag(StringBuilder buf, String tagName, HashMap attributes) {
        buf.append('<');
        buf.append(tagName);
        if (attributes != null) {
            XMLStructureAdapter.appendAttributes(buf, attributes);
        }
        buf.append("/>");
        return buf;
    }

    public static final StringBuilder appendEmptyTag(StringBuilder buf, XMLFormatting fmt, String tagName, HashMap attributes) {
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt);
        buf.append('<');
        buf.append(tagName);
        if (attributes != null) {
            XMLStructureAdapter.appendAttributes(buf, attributes);
        }
        buf.append("/>");
        return buf;
    }

    public static final <T extends XMLStructure> StringBuilder appendXMLStructureList(StringBuilder buf, XMLFormatting fmt, List<T> elements) {
        if (elements == null) {
            return buf;
        }
        for (XMLStructure elem : elements) {
            XMLStructureAdapter.appendNewLine(buf);
            elem.appendXML(buf, fmt);
        }
        return buf;
    }

    public static final <T extends XMLStructure> List<T> decodeXMLStructureList(XMLTokenizer tokenizer, String tagName, Class<T> structureClass) throws IOException {
        ArrayList<XMLStructure> result = new ArrayList<XMLStructure>();
        try {
            while (tokenizer.atSTag(tagName)) {
                XMLStructure elem = (XMLStructure)structureClass.newInstance();
                elem.readXML(tokenizer);
                result.add(elem);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Decoding XMLStructure List: " + e);
        }
        return result;
    }

    public static final StringBuilder appendXMLTextElementList(StringBuilder buf, XMLFormatting fmt, String tagName, List<String> elements) {
        if (elements == null) {
            return buf;
        }
        for (String elem : elements) {
            XMLStructureAdapter.appendTextElement(buf, tagName, elem, fmt);
        }
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, String attrValue) {
        if (attrValue == null) {
            return buf;
        }
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        buf.append(attrValue);
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, String attrValue1, String attrValue2) {
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        buf.append(attrValue1 == null ? "NULL" : attrValue1);
        buf.append(' ');
        buf.append(attrValue2 == null ? "NULL" : attrValue2);
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, String attrValue1, String attrValue2, String attrValue3) {
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        buf.append(attrValue1 == null ? "NULL" : attrValue1);
        buf.append(' ');
        buf.append(attrValue2 == null ? "NULL" : attrValue2);
        buf.append(' ');
        buf.append(attrValue3 == null ? "NULL" : attrValue3);
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, String attrValue1, String attrValue2, String attrValue3, String attrValue4) {
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        buf.append(attrValue1 == null ? "NULL" : attrValue1);
        buf.append(' ');
        buf.append(attrValue2 == null ? "NULL" : attrValue2);
        buf.append(' ');
        buf.append(attrValue3 == null ? "NULL" : attrValue3);
        buf.append(' ');
        buf.append(attrValue4 == null ? "NULL" : attrValue4);
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, int intValue) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Integer.toString(intValue));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, int intValue1, int intValue2) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Integer.toString(intValue1), Integer.toString(intValue2));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, int intValue1, int intValue2, int intValue3) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Integer.toString(intValue1), Integer.toString(intValue2), Integer.toString(intValue3));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, int intValue1, int intValue2, int intValue3, int intValue4) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Integer.toString(intValue1), Integer.toString(intValue2), Integer.toString(intValue3), Integer.toString(intValue4));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, long longValue) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Long.toString(longValue));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, long longValue1, long longValue2) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Long.toString(longValue1), Long.toString(longValue2));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, long longValue1, long longValue2, long longValue3) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Long.toString(longValue1), Long.toString(longValue2), Long.toString(longValue3));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, long longValue1, long longValue2, long longValue3, long longValue4) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Long.toString(longValue1), Long.toString(longValue2), Long.toString(longValue3), Long.toString(longValue4));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, float floatValue) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Float.toString(floatValue));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, float floatValue1, float floatValue2) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Float.toString(floatValue1), Float.toString(floatValue2));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, float floatValue1, float floatValue2, float floatValue3) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Float.toString(floatValue1), Float.toString(floatValue2), Float.toString(floatValue3));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, float floatValue1, float floatValue2, float floatValue3, float floatValue4) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Float.toString(floatValue1), Float.toString(floatValue2), Float.toString(floatValue3), Float.toString(floatValue4));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, double doubleValue) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Double.toString(doubleValue));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, double doubleValue1, double doubleValue2) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Double.toString(doubleValue1), Double.toString(doubleValue2));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, double doubleValue1, double doubleValue2, double doubleValue3) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Double.toString(doubleValue1), Double.toString(doubleValue2), Double.toString(doubleValue3));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, double doubleValue1, double doubleValue2, double doubleValue3, double doubleValue4) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Double.toString(doubleValue1), Double.toString(doubleValue2), Double.toString(doubleValue3), Double.toString(doubleValue4));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, boolean boolValue) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Boolean.toString(boolValue));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, boolean boolValue1, boolean boolValue2) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Boolean.toString(boolValue1), Boolean.toString(boolValue2));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, boolean boolValue1, boolean boolValue2, boolean boolValue3) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Boolean.toString(boolValue1), Boolean.toString(boolValue2), Boolean.toString(boolValue3));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, boolean boolValue1, boolean boolValue2, boolean boolValue3, boolean boolValue4) {
        return XMLStructureAdapter.appendAttribute(buf, attrName, Boolean.toString(boolValue1), Boolean.toString(boolValue2), Boolean.toString(boolValue3), Boolean.toString(boolValue4));
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, int[] ints, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (ints == null) {
            return buf;
        }
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        XMLStructureAdapter.appendInts(buf, ints, separator, fmt, nrElementsPerLine);
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendInts(StringBuilder buf, int[] ints, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (ints == null || ints.length == 0) {
            return buf;
        }
        int tabCounter = nrElementsPerLine;
        buf.append(ints[0]);
        --tabCounter;
        for (int i = 1; i < ints.length; ++i) {
            if (tabCounter == 0) {
                buf.append('\n');
                XMLStructureAdapter.appendSpaces(buf, fmt);
                tabCounter = nrElementsPerLine;
            } else {
                buf.append(separator);
            }
            buf.append(ints[i]);
            --tabCounter;
        }
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, float[] floats, char separator) {
        if (floats == null) {
            return buf;
        }
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        if (floats != null && floats.length > 0) {
            buf.append(floats[0]);
            for (int i = 1; i < floats.length; ++i) {
                buf.append(separator);
                buf.append(floats[i]);
            }
        }
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, float[] floats, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (floats == null) {
            return buf;
        }
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        XMLStructureAdapter.appendFloats(buf, floats, separator, fmt, nrElementsPerLine);
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendFloats(StringBuilder buf, float[] floats, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (floats == null || floats.length == 0) {
            return buf;
        }
        int tabCounter = nrElementsPerLine;
        buf.append(floats[0]);
        --tabCounter;
        for (int i = 1; i < floats.length; ++i) {
            if (tabCounter == 0) {
                buf.append('\n');
                XMLStructureAdapter.appendSpaces(buf, fmt);
                tabCounter = nrElementsPerLine;
            } else {
                buf.append(separator);
            }
            buf.append(floats[i]);
            --tabCounter;
        }
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, String[] strings, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (strings == null) {
            return buf;
        }
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        XMLStructureAdapter.appendStrings(buf, strings, separator, fmt, nrElementsPerLine);
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendStrings(StringBuilder buf, String[] strings, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (strings == null || strings.length == 0) {
            return buf;
        }
        int tabCounter = nrElementsPerLine;
        buf.append(strings[0]);
        --tabCounter;
        for (int i = 1; i < strings.length; ++i) {
            if (tabCounter == 0) {
                buf.append('\n');
                XMLStructureAdapter.appendSpaces(buf, fmt);
                tabCounter = nrElementsPerLine;
            } else {
                buf.append(separator);
            }
            buf.append(strings[i]);
            --tabCounter;
        }
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, boolean[] bools, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (bools == null) {
            return buf;
        }
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        XMLStructureAdapter.appendBooleans(buf, bools, separator, fmt, nrElementsPerLine);
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendBooleans(StringBuilder buf, boolean[] bools, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (bools == null || bools.length == 0) {
            return buf;
        }
        int tabCounter = nrElementsPerLine;
        buf.append(bools[0]);
        --tabCounter;
        for (int i = 1; i < bools.length; ++i) {
            if (tabCounter == 0) {
                buf.append('\n');
                XMLStructureAdapter.appendSpaces(buf, fmt);
                tabCounter = nrElementsPerLine;
            } else {
                buf.append(separator);
            }
            buf.append(bools[i]);
            --tabCounter;
        }
        return buf;
    }

    public static final StringBuilder appendAttribute(StringBuilder buf, String attrName, double[] doubles, char separator) {
        if (doubles == null) {
            return buf;
        }
        buf.append(' ');
        buf.append(attrName);
        buf.append("=\"");
        if (doubles != null && doubles.length > 0) {
            buf.append(doubles[0]);
            for (int i = 1; i < doubles.length; ++i) {
                buf.append(separator);
                buf.append(doubles[i]);
            }
        }
        buf.append('\"');
        return buf;
    }

    public static final StringBuilder appendAttributes(StringBuilder buf, HashMap attributes) {
        if (attributes == null) {
            return buf;
        }
        for (Map.Entry entry : attributes.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            buf.append(' ');
            buf.append(key);
            buf.append("=\"");
            buf.append(value == null ? "NULL" : value);
            buf.append('\"');
        }
        return buf;
    }

    public static final StringBuilder appendETag(StringBuilder buf, String tagName) {
        buf.append("</");
        buf.append(tagName);
        buf.append('>');
        return buf;
    }

    public static final StringBuilder appendETag(StringBuilder buf, String tagName, XMLFormatting fmt) {
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt);
        buf.append("</");
        buf.append(tagName);
        buf.append('>');
        return buf;
    }

    public static final StringBuilder appendSystemNewLine(StringBuilder buf) {
        buf.append(SYSTEMNEWLINE);
        return buf;
    }

    public static final StringBuilder appendNewLine(StringBuilder buf) {
        buf.append('\n');
        return buf;
    }

    public static final StringBuilder appendNewLine(StringBuilder buf, int tab) {
        buf.append('\n');
        while (lotsOfSpaces.length() < tab) {
            lotsOfSpaces.append("         ");
        }
        return buf.append(lotsOfSpaces.substring(0, tab));
    }

    public static final StringBuilder appendNewLine(StringBuilder buf, XMLFormatting fmt) {
        return XMLStructureAdapter.appendNewLine(buf, fmt.getTab());
    }

    public static final StringBuilder appendTextElement(StringBuilder buf, String tagName, String value, XMLFormatting fmt) {
        if (value == null) {
            return buf;
        }
        XMLStructureAdapter.appendSTag(buf, tagName, fmt);
        buf.append(value);
        XMLStructureAdapter.appendETag(buf, tagName);
        return buf;
    }

    public static final StringBuilder appendIntElement(StringBuilder buf, String tagName, int value, XMLFormatting fmt) {
        return XMLStructureAdapter.appendTextElement(buf, tagName, Integer.toString(value), fmt);
    }

    public static final StringBuilder appendOptionalIntElement(StringBuilder buf, String tagName, int value, int unspecified, XMLFormatting fmt) {
        return value == unspecified ? buf : XMLStructureAdapter.appendTextElement(buf, tagName, Integer.toString(value), fmt);
    }

    public static final StringBuilder appendLongElement(StringBuilder buf, String tagName, long value, XMLFormatting fmt) {
        return XMLStructureAdapter.appendTextElement(buf, tagName, Long.toString(value), fmt);
    }

    public static final StringBuilder appendOptionalLongElement(StringBuilder buf, String tagName, long value, long unspecified, XMLFormatting fmt) {
        return value == unspecified ? buf : XMLStructureAdapter.appendTextElement(buf, tagName, Long.toString(value), fmt);
    }

    public static final StringBuilder appendFloatElement(StringBuilder buf, String tagName, float value, XMLFormatting fmt) {
        return XMLStructureAdapter.appendTextElement(buf, tagName, Float.toString(value), fmt);
    }

    public static final StringBuilder appendOptionalFloatElement(StringBuilder buf, String tagName, float value, float unspecified, XMLFormatting fmt) {
        return value == unspecified ? buf : XMLStructureAdapter.appendTextElement(buf, tagName, Float.toString(value), fmt);
    }

    public static final StringBuilder appendDoubleElement(StringBuilder buf, String tagName, double value, XMLFormatting fmt) {
        return XMLStructureAdapter.appendTextElement(buf, tagName, Double.toString(value), fmt);
    }

    public static final StringBuilder appendOptionalDoubleElement(StringBuilder buf, String tagName, double value, double unspecified, XMLFormatting fmt) {
        return value == unspecified ? buf : XMLStructureAdapter.appendTextElement(buf, tagName, Double.toString(value), fmt);
    }

    public static final StringBuilder appendIntArrayElement(StringBuilder buf, String tagName, int[] values, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (values == null) {
            return buf;
        }
        XMLStructureAdapter.appendOpenSTag(buf, tagName, fmt);
        XMLStructureAdapter.appendAttribute(buf, "count", values.length);
        XMLStructureAdapter.appendCloseSTag(buf);
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt.indent());
        XMLStructureAdapter.appendInts(buf, values, separator, fmt, nrElementsPerLine);
        XMLStructureAdapter.appendETag(buf, tagName, fmt.unIndent());
        return buf;
    }

    public static final StringBuilder appendFloatArrayElement(StringBuilder buf, String tagName, float[] values, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (values == null) {
            return buf;
        }
        XMLStructureAdapter.appendOpenSTag(buf, tagName, fmt);
        XMLStructureAdapter.appendAttribute(buf, "count", values.length);
        XMLStructureAdapter.appendCloseSTag(buf);
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt.indent());
        XMLStructureAdapter.appendFloats(buf, values, separator, fmt, nrElementsPerLine);
        XMLStructureAdapter.appendETag(buf, tagName, fmt.unIndent());
        return buf;
    }

    public static final String encodeStringArray(String[] str) {
        return XMLStructureAdapter.encodeStringArray(str, ", ");
    }

    public static final String encodeStringArray(String[] str, String separator) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length - 1; ++i) {
            buf.append(str[i]);
            buf.append(separator);
        }
        if (str.length > 0) {
            buf.append(str[str.length - 1]);
        }
        return buf.toString();
    }

    public static final String encodeStringList(List<String> str) {
        return XMLStructureAdapter.encodeStringList(str, ", ");
    }

    public static final String encodeStringList(List<String> str, String separator) {
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.size() - 1; ++i) {
            buf.append(str.get(i));
            buf.append(separator);
        }
        if (str.size() > 0) {
            buf.append(str.get(str.size() - 1));
        }
        return buf.toString();
    }

    public static final StringBuilder appendStringArrayElement(StringBuilder buf, String tagName, String[] values, char separator, XMLFormatting fmt, int nrElementsPerLine) {
        if (values == null) {
            return buf;
        }
        XMLStructureAdapter.appendOpenSTag(buf, tagName, fmt);
        XMLStructureAdapter.appendAttribute(buf, "count", values.length);
        XMLStructureAdapter.appendCloseSTag(buf);
        buf.append('\n');
        XMLStructureAdapter.appendSpaces(buf, fmt.indent());
        XMLStructureAdapter.appendStrings(buf, values, separator, fmt, nrElementsPerLine);
        XMLStructureAdapter.appendETag(buf, tagName, fmt.unIndent());
        return buf;
    }

    public static final String decodeXMLValueElement(String tagName, XMLTokenizer tokenizer) throws IOException {
        return tokenizer.takeTextElement(tagName);
    }

    public static final int decodeInt(String encoding) {
        return Integer.parseInt(encoding);
    }

    public static final long decodeLong(String encoding) {
        return Long.parseLong(encoding);
    }

    public static final float decodeFloat(String encoding) {
        return Float.parseFloat(encoding);
    }

    public static final double decodeDouble(String encoding) {
        return Double.parseDouble(encoding);
    }

    public static final boolean decodeBoolean(String encoding) {
        return encoding.trim().toLowerCase().equals("true");
    }

    public static final int countTokens(String encoding, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(encoding, delimiters);
        return tokenizer.countTokens();
    }

    public static final int countTokens(String encoding) {
        StringTokenizer tokenizer = new StringTokenizer(encoding, ATTRIBUTE_TOKEN_DELIMITERS);
        return tokenizer.countTokens();
    }

    public static final boolean[] decodeBooleanArray(String encoding) {
        return XMLStructureAdapter.decodeBooleanArray(encoding, null, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final boolean[] decodeBooleanArray(String encoding, String delimiters) {
        return XMLStructureAdapter.decodeBooleanArray(encoding, null, delimiters);
    }

    public static final boolean[] decodeBooleanArray(String encoding, boolean[] bools) {
        return XMLStructureAdapter.decodeBooleanArray(encoding, bools, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final boolean[] decodeBooleanArray(String encoding, boolean[] bools, String delimiters) {
        int decode = 0;
        StringTokenizer tokenizer = new StringTokenizer(encoding, delimiters);
        if (bools == null) {
            bools = new boolean[tokenizer.countTokens()];
        }
        while (tokenizer.hasMoreTokens()) {
            if (decode >= bools.length) {
                throw new RuntimeException("More booleans than expected: " + decode);
            }
            bools[decode++] = Boolean.parseBoolean(tokenizer.nextToken());
        }
        return bools;
    }

    public static final int[] decodeIntArray(String encoding) {
        return XMLStructureAdapter.decodeIntArray(encoding, null, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final int[] decodeIntArray(String encoding, String delimiters) {
        return XMLStructureAdapter.decodeIntArray(encoding, null, delimiters);
    }

    public static final int[] decodeIntArray(String encoding, int[] ints) {
        return XMLStructureAdapter.decodeIntArray(encoding, ints, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final int[] decodeIntArray(String encoding, int[] ints, String delimiters) {
        int decode = 0;
        StringTokenizer tokenizer = new StringTokenizer(encoding, delimiters);
        if (ints == null) {
            ints = new int[tokenizer.countTokens()];
        }
        while (tokenizer.hasMoreTokens()) {
            if (decode >= ints.length) {
                throw new RuntimeException("More ints than expected: " + decode);
            }
            ints[decode++] = Integer.parseInt(tokenizer.nextToken());
        }
        return ints;
    }

    public static final float[] decodeFloatArray(String encoding) {
        return XMLStructureAdapter.decodeFloatArray(encoding, null, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final float[] decodeFloatArray(String encoding, String delimiters) {
        return XMLStructureAdapter.decodeFloatArray(encoding, null, delimiters);
    }

    public static final float[] decodeFloatArray(String encoding, float[] floats) {
        return XMLStructureAdapter.decodeFloatArray(encoding, floats, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final float[] decodeFloatArray(String encoding, float[] floats, String delimiters) {
        int decode = 0;
        StringTokenizer tokenizer = new StringTokenizer(encoding, delimiters);
        if (floats == null) {
            floats = new float[tokenizer.countTokens()];
        }
        while (tokenizer.hasMoreTokens()) {
            if (decode >= floats.length) {
                throw new RuntimeException("More floats than expected: " + decode);
            }
            floats[decode++] = Float.parseFloat(tokenizer.nextToken());
        }
        return floats;
    }

    public static final double[] decodeDoubleArray(String encoding) {
        return XMLStructureAdapter.decodeDoubleArray(encoding, null, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final double[] decodeDoubleArray(String encoding, String delimiters) {
        return XMLStructureAdapter.decodeDoubleArray(encoding, null, delimiters);
    }

    public static final double[] decodeDoubleArray(String encoding, double[] doubles) {
        return XMLStructureAdapter.decodeDoubleArray(encoding, doubles, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final double[] decodeDoubleArray(String encoding, double[] doubles, String delimiters) {
        int decode = 0;
        StringTokenizer tokenizer = new StringTokenizer(encoding, delimiters);
        if (doubles == null) {
            doubles = new double[tokenizer.countTokens()];
        }
        while (tokenizer.hasMoreTokens()) {
            if (decode >= doubles.length) {
                throw new RuntimeException("More doubles than expected: " + decode);
            }
            doubles[decode++] = Double.parseDouble(tokenizer.nextToken());
        }
        return doubles;
    }

    public static final String[] decodeStringArray(String encoding) {
        return XMLStructureAdapter.decodeStringArray(encoding, null, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final String[] decodeStringArray(String encoding, String delimiters) {
        return XMLStructureAdapter.decodeStringArray(encoding, null, delimiters);
    }

    public static final String[] decodeStringArray(String encoding, String[] strings) {
        return XMLStructureAdapter.decodeStringArray(encoding, strings, ATTRIBUTE_TOKEN_DELIMITERS);
    }

    public static final String[] decodeStringArray(String encoding, String[] strings, String delimiters) {
        int decode = 0;
        StringTokenizer tokenizer = new StringTokenizer(encoding, delimiters);
        if (strings == null) {
            strings = new String[tokenizer.countTokens()];
        }
        while (tokenizer.hasMoreTokens()) {
            if (decode >= strings.length) {
                throw new RuntimeException("More Strings than expected: " + decode);
            }
            strings[decode++] = tokenizer.nextToken();
        }
        return strings;
    }

    public static final List<String> decodeStringList(String encoding) {
        return XMLStructureAdapter.decodeStringList(encoding, COMMA_SEPARATOR);
    }

    public static final List<String> decodeStringList(String encoding, String delimiters) {
        if (encoding == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(encoding, delimiters);
        ArrayList<String> strings = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            strings.add(tokenizer.nextToken());
        }
        return strings;
    }

    public static final String[] decodeStringArrayElement(String tagName, XMLTokenizer tokenizer) throws IOException {
        String attrValue = tokenizer.getAttribute("count");
        if (attrValue == null) {
            throw tokenizer.getXMLScanException(tagName + " - count attribute missing");
        }
        int count = Integer.parseInt(attrValue);
        String[] result = new String[count];
        tokenizer.takeSTag(tagName);
        XMLStructureAdapter.decodeStringArray(tokenizer.takeOptionalCharData(), result);
        tokenizer.takeETag(tagName);
        return result;
    }

    public static final int[] decodeIntArrayElement(String tagName, XMLTokenizer tokenizer) throws IOException {
        String attrValue = tokenizer.getAttribute("count");
        if (attrValue == null) {
            throw tokenizer.getXMLScanException(tagName + " - count attribute missing");
        }
        int count = Integer.parseInt(attrValue);
        int[] result = new int[count];
        tokenizer.takeSTag(tagName);
        XMLStructureAdapter.decodeIntArray(tokenizer.takeOptionalCharData(), result);
        tokenizer.takeETag(tagName);
        return result;
    }

    public static final float[] decodeFloatArrayElement(String tagName, XMLTokenizer tokenizer) throws IOException {
        String attrValue = tokenizer.getAttribute("count");
        if (attrValue == null) {
            throw tokenizer.getXMLScanException(tagName + " - count attribute missing");
        }
        int count = Integer.parseInt(attrValue);
        float[] result = new float[count];
        tokenizer.takeSTag(tagName);
        XMLStructureAdapter.decodeFloatArray(tokenizer.takeOptionalCharData(), result);
        tokenizer.takeETag(tagName);
        return result;
    }

    public static void setConsoleAttributeEnabled(boolean b) {
        consoleAttributeEnabled = b;
    }

    public static <T extends XMLStructureAdapter> T parseXMLElement(Class<T> tClass, XMLTokenizer tokenizer) {
        try {
            XMLStructureAdapter result = (XMLStructureAdapter)tClass.newInstance();
            result.readXML(tokenizer);
            return (T)result;
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("InstantiationException while recreating XMLStructure: \n" + ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("IllegalAccessException while recreating XMLStructure: \n" + iae);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while recreating XMLStructure: \n" + e);
        }
    }
}

