/*
 * Decompiled with CFR 0.152.
 */
package hmi.xml;

import hmi.xml.XMLScanException;

public final class CharDataConversion {
    private CharDataConversion() {
    }

    public static String encode(String value) {
        int len = value.length();
        StringBuffer buf = new StringBuffer(len + 10);
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (ch == '\'') {
                buf.append("&apos;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String decode(String value) {
        int len = value.length();
        StringBuffer buf = new StringBuffer(len + 10);
        int i = 0;
        block6: while (i < len) {
            char ch;
            if ((ch = value.charAt(i++)) != '&') {
                buf.append(ch);
                continue;
            }
            switch (value.charAt(i++)) {
                case 'l': {
                    if (value.charAt(i++) != 't' || value.charAt(i++) != ';') {
                        throw new XMLScanException("error in \"&lt;\" reference");
                    }
                    buf.append('<');
                    continue block6;
                }
                case 'g': {
                    if (value.charAt(i++) != 't' || value.charAt(i++) != ';') {
                        throw new XMLScanException("error in \"&gt;\" reference");
                    }
                    buf.append('>');
                    continue block6;
                }
                case 'q': {
                    if (value.charAt(i++) != 'u' || value.charAt(i++) != 'o' || value.charAt(i++) != 't' || value.charAt(i++) != ';') {
                        throw new XMLScanException("error in \"&quot;\" reference");
                    }
                    buf.append('\"');
                    continue block6;
                }
                case 'a': {
                    if (value.charAt(i) == 'm') {
                        int n = ++i;
                        ++i;
                        if (value.charAt(n) != 'p' || value.charAt(i++) != ';') {
                            throw new XMLScanException("error in \"&amp;\" reference");
                        }
                        buf.append('&');
                        continue block6;
                    }
                    if (value.charAt(i) == 'p') {
                        int n = ++i;
                        ++i;
                        if (value.charAt(n) != 'o' || value.charAt(i++) != 's' || value.charAt(i++) != ';') {
                            throw new XMLScanException("error in \"&apos;\" reference");
                        }
                        buf.append('\'');
                        continue block6;
                    }
                    throw new XMLScanException("error in \"$amp;\" or \"&apos;\" reference");
                }
            }
            throw new XMLScanException("unexpected character after '&' : " + value.charAt(i - 1));
        }
        return buf.toString();
    }
}

