/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.ClockListener;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class SystemClock {
    private Thread clockThread;
    private long nanoTickSize = 0L;
    private long currentTimeBaseTime = System.nanoTime();
    private volatile long mediaTime;
    private volatile double rate = 1.0;
    private volatile boolean listenersModified = false;
    private ArrayList<ClockListener> listeners = new ArrayList();
    private ArrayList<ClockListener> newListeners = new ArrayList();
    private static final int INIT = 0;
    private static final int RUNNING = 1;
    private static final int PAUSED = 2;
    private static final int TERMINATED = 3;
    private volatile int clockState = 0;
    private Semaphore runSem = new Semaphore(0);
    private String threadName = null;
    private static final long NANOSPERSMILLISECOND = 1000000L;
    private static final double NANOSPERSECOND = 1.0E9;
    private static final double MILLISPERSECOND = 1000.0;

    public SystemClock() {
        this(0L);
    }

    public SystemClock(long tickSize) {
        this(tickSize, null);
    }

    public SystemClock(String threadName) {
        this(0L, threadName);
    }

    public SystemClock(long tickSize, String threadName) {
        this.threadName = threadName;
        this.mediaTime = 0L;
        this.clockState = 0;
        this.nanoTickSize = tickSize * 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClockListener(ClockListener listener) {
        ArrayList<ClockListener> arrayList = this.newListeners;
        synchronized (arrayList) {
            this.newListeners.add(listener);
            this.listenersModified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners() {
        if (this.listenersModified) {
            ArrayList<ClockListener> arrayList = this.newListeners;
            synchronized (arrayList) {
                this.listeners.addAll(this.newListeners);
                this.newListeners.clear();
                this.listenersModified = false;
            }
        }
    }

    public synchronized double getMediaSeconds() {
        return (double)this.getMediaNanoseconds() / 1.0E9;
    }

    public synchronized void setMediaSeconds(double mt) {
        this.mediaTime = (long)(mt * 1.0E9);
    }

    public long getMediaNanoseconds() {
        return this.mediaTime;
    }

    public synchronized void start() {
        if (this.clockState == 3 || this.clockState == 1) {
            return;
        }
        if (this.clockState == 0) {
            this.clockState = 1;
            this.startClockThread();
        } else {
            this.clockState = 1;
        }
        this.runSem.release();
    }

    public synchronized void pause() {
        if (this.clockState == 3 || this.clockState == 2) {
            return;
        }
        if (this.clockState == 0) {
            this.clockState = 2;
            this.startClockThread();
        } else {
            this.clockState = 2;
        }
    }

    public synchronized void terminate() {
        if (this.clockState == 3) {
            return;
        }
        this.clockState = 3;
    }

    public synchronized void init() {
        if (this.clockState != 0) {
            return;
        }
        this.pause();
    }

    public synchronized void setRate(double rate) {
        this.rate = rate;
    }

    public synchronized double getRate() {
        return this.rate;
    }

    private void initTime() {
        this.updateListeners();
        double curTime = (double)this.mediaTime / 1.0E9;
        for (ClockListener cl : this.listeners) {
            cl.initTime(curTime);
        }
    }

    private void time() {
        this.updateListeners();
        double curTime = (double)this.mediaTime / 1.0E9;
        for (ClockListener cl : this.listeners) {
            cl.time(curTime);
        }
    }

    private void startClockThread() {
        this.clockThread = this.threadName == null ? new ClockThread() : new ClockThread(this.threadName);
        this.clockThread.start();
    }

    class ClockThread
    extends Thread {
        public ClockThread(String threadName) {
            super(threadName);
        }

        public ClockThread() {
        }

        @Override
        public void run() {
            try {
                long prevTimeBaseTime = SystemClock.this.currentTimeBaseTime;
                SystemClock.this.initTime();
                while (SystemClock.this.clockState != 3) {
                    SystemClock.this.runSem.acquire();
                    SystemClock.this.currentTimeBaseTime = System.nanoTime();
                    while (SystemClock.this.clockState == 1) {
                        SystemClock.this.time();
                        long delta = SystemClock.this.currentTimeBaseTime + SystemClock.this.nanoTickSize - System.nanoTime();
                        if (delta <= 0L) {
                            Thread.yield();
                        } else {
                            Thread.sleep(delta / 1000000L);
                        }
                        prevTimeBaseTime = SystemClock.this.currentTimeBaseTime;
                        SystemClock.this.currentTimeBaseTime = System.nanoTime();
                        long timeBaseDelta = SystemClock.this.currentTimeBaseTime - prevTimeBaseTime;
                        long mediaTimeDelta = SystemClock.this.rate == 1.0 ? timeBaseDelta : (long)(SystemClock.this.rate * (double)timeBaseDelta);
                        SystemClock.this.mediaTime += mediaTimeDelta;
                    }
                }
            }
            catch (InterruptedException ie) {
                SystemClock.this.clockState = 3;
            }
        }
    }
}

