/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.Console;

public class Stopwatch {
    private static final int NANOSPERSECOND = 1000000000;
    private static final int NANOSPERMILLISECOND = 1000000;
    private static final int NANOSPERMICROSECOND = 1000;
    private static final int TESTDELAY1 = 2000;
    private static final int TESTDELAY2 = 3000;
    private long starttime = 0L;
    private long currenttime = 0L;
    private long lapstart = 0L;
    private String name;
    private static int stopwatchcount = 1;

    public Stopwatch() {
        this.name = "Stopwatch " + stopwatchcount++;
        this.start();
    }

    public Stopwatch(String name) {
        this.name = name;
        this.start();
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        this.lapstart = this.starttime = System.nanoTime();
    }

    public void showSeconds() {
        this.showSeconds("time (seconds) : ");
    }

    public final void showSeconds(String message) {
        this.lapstart = this.currenttime = System.nanoTime();
        Console.println("[" + this.name + "] " + message + " " + (this.currenttime - this.starttime) / 1000000000L);
    }

    public void showMilliseconds() {
        this.showMilliseconds("time (milliseconds) : ");
    }

    public final void showMilliseconds(String message) {
        this.lapstart = this.currenttime = System.nanoTime();
        Console.println("[" + this.name + "] " + message + " " + (this.currenttime - this.starttime) / 1000000L);
    }

    public final void showMicroseconds() {
        this.lapstart = this.currenttime = System.nanoTime();
        Console.println("[" + this.name + "] time (microseconds) : " + (this.currenttime - this.starttime) / 1000L);
    }

    public final void showMicroseconds(String message) {
        this.lapstart = this.currenttime = System.nanoTime();
        Console.println("[" + this.name + "] " + message + " " + (this.currenttime - this.starttime) / 1000L);
    }

    public final void showNanoseconds(String message) {
        this.lapstart = this.currenttime = System.nanoTime();
        Console.println("[" + this.name + "] " + message + " " + (this.currenttime - this.starttime));
    }

    public final void showNanoseconds() {
        this.lapstart = this.currenttime = System.nanoTime();
        Console.println("[" + this.name + "] time (nanoseconds) : " + (this.currenttime - this.starttime));
    }

    public long showMillisecondsLap() {
        this.currenttime = System.nanoTime();
        long lap = (this.currenttime - this.lapstart) / 1000000L;
        Console.println("[" + this.name + "] lap time (milliseconds): " + lap);
        this.lapstart = this.currenttime;
        return lap;
    }

    public static void delay(long d) {
        try {
            Thread.sleep(d);
        }
        catch (Exception e) {
            System.err.println("Stopwatch.delay: " + e);
        }
    }

    public static void main(String[] arg) {
        Console.println("Stopwatch test");
        Stopwatch watch1 = new Stopwatch("Watch1");
        watch1.start();
        Stopwatch.delay(2000L);
        watch1.showMillisecondsLap();
        watch1.showMilliseconds();
        Stopwatch.delay(3000L);
        watch1.showMilliseconds();
        watch1.showMillisecondsLap();
    }
}

