/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.Console;
import hmi.util.Predicate;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public final class Screen {
    public static final int CURRENT_VALUE = -1;
    public static final int HIGHCOLOR = 16;
    public static final int TRUECOLOR = 32;
    public static final int MAX = Integer.MAX_VALUE;
    public static final int MIN = 0;
    private static final int[] DEFAULTSCREENSIZELIST = new int[]{640, 480, 800, 600, 1024, 768, 1280, 960, 1280, 1024};
    public static final int SHOWSCREENSIZE = 0;
    public static final int SHOWBITDEPTH = 1;
    public static final int SHOWREFRESHRATE = 2;
    public static final int SHOWFULLDISPLAYMODE = 3;
    private static final int EXPECTEDLABELLENGTH = 16;
    private static final int MAXDIMENSION = 1000;
    private static final int CURSORSIZE = 16;
    private static GraphicsDevice defaultDevice;
    private static Cursor noCursor;
    private static Cursor prevCursor;

    private Screen() {
    }

    public static DisplayMode[] getDisplayModes() {
        Screen.checkDefaultDevice();
        return defaultDevice.getDisplayModes();
    }

    public static Predicate<DisplayMode> displayModeFilter(final int minWidth, final int minHeight, final int maxWidth, final int maxHeight, final int minBitDepth, final int maxBitDepth, final int minRefreshRate, final int maxRefreshRate) {
        return new Predicate<DisplayMode>(){

            @Override
            public boolean valid(DisplayMode m) {
                int bd = m.getBitDepth();
                int w = m.getWidth();
                int h = m.getHeight();
                int rf = m.getRefreshRate();
                return minBitDepth <= bd && bd <= maxBitDepth && minRefreshRate <= rf && rf <= maxRefreshRate && minWidth <= w && w <= maxWidth && minHeight <= h && h <= maxHeight;
            }
        };
    }

    public static ArrayList<DisplayMode> selectFilteredDisplayModes(Predicate<DisplayMode> filter) {
        Screen.checkDefaultDevice();
        DisplayMode[] da = defaultDevice.getDisplayModes();
        ArrayList<DisplayMode> dl = new ArrayList<DisplayMode>(da.length);
        for (int i = 0; i < da.length; ++i) {
            DisplayMode mode = da[i];
            if (!filter.valid(mode)) continue;
            dl.add(mode);
        }
        return dl;
    }

    public static ArrayList<DisplayMode> selectDisplayModeRange(int minWidth, int minHeight, int maxWidth, int maxHeight, int minBitDepth, int maxBitDepth, int minRefreshRate, int maxRefreshRate) {
        int minbd = minBitDepth == -1 ? Screen.getBitDepth() : minBitDepth;
        int maxbd = maxBitDepth == -1 ? Screen.getBitDepth() : maxBitDepth;
        int minrf = minRefreshRate == -1 ? Screen.getRefreshRate() : minRefreshRate;
        int maxrf = maxRefreshRate == -1 ? Screen.getRefreshRate() : maxRefreshRate;
        int minw = minWidth == -1 ? Screen.getWidth() : minWidth;
        int maxw = maxWidth == -1 ? Screen.getWidth() : maxWidth;
        int minh = minHeight == -1 ? Screen.getHeight() : minHeight;
        int maxh = maxHeight == -1 ? Screen.getHeight() : maxHeight;
        return Screen.selectFilteredDisplayModes(Screen.displayModeFilter(minw, minh, maxw, maxh, minbd, maxbd, minrf, maxrf));
    }

    public static ArrayList<DisplayMode> selectDisplayModes() {
        return Screen.selectDisplayModes(DEFAULTSCREENSIZELIST, 32, 32, -1, -1);
    }

    public static ArrayList<DisplayMode> selectDisplayModes(int[] preferredScreenSizes) {
        return Screen.selectDisplayModes(preferredScreenSizes, 32, 32, -1, -1);
    }

    public static ArrayList<DisplayMode> selectDisplayModes(final int[] preferredScreenSizes, int minBitDepth, int maxBitDepth, int minRefreshRate, int maxRefreshRate) {
        final int minbd = minBitDepth == -1 ? Screen.getBitDepth() : minBitDepth;
        final int maxbd = maxBitDepth == -1 ? Screen.getBitDepth() : maxBitDepth;
        final int minrf = minRefreshRate == -1 ? Screen.getRefreshRate() : minRefreshRate;
        final int maxrf = maxRefreshRate == -1 ? Screen.getRefreshRate() : maxRefreshRate;
        Predicate<DisplayMode> selector = new Predicate<DisplayMode>(){

            @Override
            public boolean valid(DisplayMode mode) {
                int rf = mode.getRefreshRate();
                int bd = mode.getBitDepth();
                int w = mode.getWidth();
                int h = mode.getHeight();
                if (bd < minbd || bd > maxbd) {
                    return false;
                }
                if (rf < minrf || rf > maxrf) {
                    return false;
                }
                int i = 0;
                while (i + 1 < preferredScreenSizes.length) {
                    if (preferredScreenSizes[i] == w && preferredScreenSizes[i + 1] == h) {
                        return true;
                    }
                    i += 2;
                }
                return false;
            }
        };
        return Screen.selectFilteredDisplayModes(selector);
    }

    public static DisplayMode getDisplayMode() {
        Screen.checkDefaultDevice();
        return defaultDevice.getDisplayMode();
    }

    public static int getRefreshRate() {
        Screen.checkDefaultDevice();
        return defaultDevice.getDisplayMode().getRefreshRate();
    }

    public static int getBitDepth() {
        Screen.checkDefaultDevice();
        return defaultDevice.getDisplayMode().getBitDepth();
    }

    public static int getWidth() {
        Screen.checkDefaultDevice();
        return defaultDevice.getDisplayMode().getWidth();
    }

    public static int getHeight() {
        Screen.checkDefaultDevice();
        return defaultDevice.getDisplayMode().getHeight();
    }

    public static String getDisplayModeString() {
        Screen.checkDefaultDevice();
        return Screen.displayModeToString(defaultDevice.getDisplayMode());
    }

    public static String displayModeToString(DisplayMode mode) {
        return mode.getWidth() + "X" + mode.getHeight() + "-" + mode.getBitDepth() + "-" + mode.getRefreshRate();
    }

    public static String displayModeToLabel(DisplayMode mode, int labelMode) {
        boolean showBitDepth = (labelMode & 1) != 0;
        boolean showRefreshRate = (labelMode & 2) != 0;
        StringBuilder result = new StringBuilder(16);
        int w = mode.getWidth();
        result.append(w);
        if (w < 1000 && (showBitDepth || showRefreshRate)) {
            result.append(' ');
        }
        result.append(" X ");
        int h = mode.getHeight();
        if (h < 1000 && (showBitDepth || showRefreshRate)) {
            result.append(' ');
        }
        result.append(h);
        if (showBitDepth) {
            int bd = mode.getBitDepth();
            result.append("  ");
            if (bd == 32) {
                result.append("TrueColor (32 bit)");
            } else if (bd == 16) {
                result.append("HighColor (16 bit)");
            } else {
                result.append('(');
                result.append(bd);
                result.append(" bit)");
            }
        }
        if (showRefreshRate) {
            result.append(",  ");
            result.append(mode.getRefreshRate());
            result.append(" Hz");
        }
        return result.toString();
    }

    public static void printDisplayModes() {
        DisplayMode[] modes = Screen.getDisplayModes();
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode mode = modes[i];
            Console.println("Displaymode[" + i + "]:\n" + mode.getWidth() + ", " + mode.getHeight() + ", " + mode.getBitDepth() + ", " + mode.getRefreshRate());
        }
    }

    public static DisplayMode selectBestDisplayMode(int width, int height, int bitDepth, int refreshRate) {
        Screen.checkDefaultDevice();
        DisplayMode currentMode = defaultDevice.getDisplayMode();
        int currentBitDepth = currentMode.getBitDepth();
        int currentRefreshRate = currentMode.getRefreshRate();
        int currentWidth = currentMode.getWidth();
        int currentHeight = currentMode.getHeight();
        if (width == -1) {
            width = currentWidth;
        }
        if (height == -1) {
            height = currentHeight;
        }
        if (bitDepth == -1) {
            bitDepth = currentBitDepth;
        }
        if (refreshRate == -1) {
            refreshRate = currentRefreshRate;
        }
        DisplayMode[] modes = defaultDevice.getDisplayModes();
        ArrayList<DisplayMode> selectedModes = new ArrayList<DisplayMode>();
        for (int i = 0; i < modes.length; ++i) {
            DisplayMode m = modes[i];
            if (m.getWidth() != width || m.getHeight() != height) continue;
            selectedModes.add(m);
        }
        if (selectedModes.isEmpty()) {
            return null;
        }
        for (DisplayMode m : selectedModes) {
            if (m.getBitDepth() != bitDepth || m.getRefreshRate() != refreshRate) continue;
            return m;
        }
        for (DisplayMode m : selectedModes) {
            if (m.getBitDepth() != bitDepth || m.getRefreshRate() > refreshRate) continue;
            return m;
        }
        for (DisplayMode m : selectedModes) {
            if (m.getRefreshRate() > refreshRate) continue;
            return m;
        }
        return null;
    }

    public static void setFullScreen(Frame frame) {
        Screen.setFullScreen(frame, null);
    }

    public static void setFullScreen(Frame frame, int width, int height) {
        Screen.setFullScreen(frame, Screen.selectBestDisplayMode(width, height, 32, -1));
    }

    public static void setFullScreen(Frame frame, int width, int height, int bitDepth) {
        Screen.setFullScreen(frame, Screen.selectBestDisplayMode(width, height, bitDepth, -1));
    }

    public static void setFullScreen(Frame frame, int width, int height, int bitDepth, int refreshRate) {
        Screen.setFullScreen(frame, Screen.selectBestDisplayMode(width, height, bitDepth, refreshRate));
    }

    public static void setFullScreen(Frame frame, DisplayMode mode) {
        block5: {
            Screen.checkDefaultDevice();
            try {
                if (defaultDevice.isFullScreenSupported()) {
                    defaultDevice.setFullScreenWindow(frame);
                    if (frame != null) {
                        frame.enableInputMethods(false);
                    }
                    break block5;
                }
                Console.println("Screen: full screen mode not supported");
                return;
            }
            catch (Exception e) {
                Console.println("hmi.util.Screen: " + e);
                return;
            }
        }
        if (frame == null || mode == null) {
            return;
        }
        defaultDevice.setDisplayMode(mode);
        Screen.setFullScreen(null);
        Screen.setFullScreen(frame);
    }

    public static void setInvisibleCursor(Component c) {
        if (noCursor == null) {
            Dimension cdim = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
            BufferedImage img = new BufferedImage(cdim.width, cdim.height, 2);
            noCursor = Toolkit.getDefaultToolkit().createCustomCursor(img, new Point(0, 0), "NoCursor");
        }
        prevCursor = c.getCursor();
        c.setCursor(noCursor);
    }

    public static void setCursor(Component c, int cursorType) {
        Cursor curs = Cursor.getPredefinedCursor(cursorType);
        if (curs != null) {
            prevCursor = c.getCursor();
            c.setCursor(curs);
        } else {
            Console.println("Screen.setCursor: unknown cursor type");
        }
    }

    public static void restoreCursor(Component c) {
        if (prevCursor != null) {
            c.setCursor(prevCursor);
        }
    }

    private static void checkDefaultDevice() {
        if (defaultDevice == null) {
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            defaultDevice = genv.getDefaultScreenDevice();
        }
    }
}

