/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resources {
    private String resourceRoot = "";
    private static ClassLoader loader = Resources.class.getClassLoader();
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.util");
    private boolean logging = false;
    private String resourceDir = "";
    private boolean localDir = false;

    private Resources() {
    }

    public Resources(String resourceDir) {
        this.resourceDir = resourceDir;
        this.resourceRoot = this.adjustPath(resourceDir);
    }

    public Resources(File resourceDirFile) {
        if (!resourceDirFile.isDirectory()) {
            logger.error("Resources: File " + resourceDirFile + " is not a directory");
        }
        this.localDir = true;
        try {
            this.resourceDir = resourceDirFile.getCanonicalPath();
            this.resourceRoot = null;
            this.resourceRoot = this.adjustPath(this.resourceDir);
        }
        catch (IOException e) {
            logger.error("Resources exception: " + e);
        }
    }

    public String getResourceDirectory() {
        return this.resourceDir;
    }

    public BufferedInputStream getInputStream(String fileName) {
        InputStream unbuffered = this.getUnbufferedInputStream(fileName);
        if (unbuffered == null) {
            return null;
        }
        return new BufferedInputStream(unbuffered);
    }

    private InputStream getUnbufferedInputStream(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        char firstChar = fileName.charAt(0);
        String resource = firstChar == '/' || firstChar == '\\' ? fileName : this.resourceRoot + fileName;
        InputStream stream = null;
        if (this.localDir) {
            try {
                stream = new FileInputStream(resource);
            }
            catch (FileNotFoundException e) {
                logger.error("Resources: " + e);
            }
        } else {
            stream = loader.getResourceAsStream(resource);
        }
        if (this.logging && stream == null) {
            logger.error("Cannot find resource file: " + resource);
        }
        return stream;
    }

    public BufferedReader getReader(String fileName) {
        InputStream stream = this.getUnbufferedInputStream(fileName);
        if (stream == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(stream));
    }

    public static BufferedReader getResourceReader(String resourceFileName) {
        if (resourceFileName == null) {
            logger.error("Cannot open null resource file");
            return null;
        }
        if (resourceFileName.length() == 0) {
            logger.error("Cannot open resource file\"\" ");
            return null;
        }
        InputStream stream = loader.getResourceAsStream(resourceFileName);
        if (stream == null) {
            logger.error("Cannot find resource file: " + resourceFileName);
            return null;
        }
        return new BufferedReader(new InputStreamReader(stream));
    }

    public URL getURL(String fileName) {
        return this.getURL(loader, fileName);
    }

    public URL getURL(ClassLoader cl, String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        char firstChar = fileName.charAt(0);
        String resource = firstChar == '/' || firstChar == '\\' ? fileName : this.resourceRoot + fileName;
        return cl.getResource(resource);
    }

    public static String readResource(String fileName) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        BufferedReader reader = Resources.getResourceReader(fileName);
        if (reader != null) {
            StringBuffer buf = new StringBuffer();
            int ch = reader.read();
            while (ch >= 0) {
                buf.append((char)ch);
                ch = reader.read();
            }
            return buf.toString();
        }
        return null;
    }

    public String read(String fileName) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        BufferedReader reader = this.getReader(fileName);
        if (reader != null) {
            StringBuffer buf = new StringBuffer();
            int ch = reader.read();
            while (ch >= 0) {
                buf.append((char)ch);
                ch = reader.read();
            }
            return buf.toString();
        }
        return null;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    private String adjustPath(String rootPath) {
        String result = rootPath.replace('\\', '/');
        int len = result.length();
        if (len > 0 && result.charAt(len - 1) != '/') {
            result = result + '/';
        }
        return result;
    }

    public String toString() {
        return "Resources(" + this.resourceDir + ")";
    }

    public String getResourceRoot() {
        return this.resourceRoot;
    }
}

