/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyState
implements KeyListener,
FocusListener {
    public static final int NR_OF_KEYCODES = 256;
    private boolean[] keyDown = new boolean[256];
    private int[] keyLocation = new int[256];

    public KeyState() {
    }

    public KeyState(Component c) {
        if (c != null) {
            c.addKeyListener(this);
            c.addFocusListener(this);
        }
    }

    public void listenTo(Component c) {
        c.addKeyListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void keyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode < 256 && !this.keyDown[keyCode]) {
            KeyState keyState = this;
            synchronized (keyState) {
                this.keyLocation[keyCode] = evt.getKeyLocation();
                this.keyDown[keyCode] = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void keyReleased(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        if (keyCode < 256 && this.keyDown[keyCode]) {
            KeyState keyState = this;
            synchronized (keyState) {
                this.keyDown[keyCode] = false;
            }
        }
    }

    @Override
    public final void keyTyped(KeyEvent evt) {
    }

    public synchronized boolean isKeyDown(int keyCode) {
        return this.keyDown[keyCode];
    }

    public int getKeyLocation(int keyCode) {
        return this.keyDown[keyCode] ? this.keyLocation[keyCode] : 0;
    }

    public String locationString(int location) {
        if (location == 2) {
            return "Left";
        }
        if (location == 3) {
            return "Right";
        }
        if (location == 4) {
            return "Numpad";
        }
        if (location == 1) {
            return "S";
        }
        return "U";
    }

    private void reset() {
        for (int i = 0; i < 256; ++i) {
            this.keyDown[i] = false;
            this.keyLocation[i] = 0;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.reset();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.reset();
    }
}

