/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.ClockListener;
import hmi.util.Console;
import hmi.util.SystemClock;
import java.awt.Frame;

public class FramerateCounter
implements ClockListener {
    private static final int TESTTICKSIZE = 100;
    private static final int DELAY1 = 3000;
    private static final int DELAY2 = 3000;
    private static final int DELAY3 = 2000;
    private static final int DELAY4 = 3000;
    private static FramerateCounter framerateCounter;
    private static final double MILLISPERSECOND = 1000.0;
    private static final double NANOSPERSECOND = 1.0E9;
    public static final double REFRESHDELAY = 0.7;
    private long prevFramerateTime;
    private int fpsCounter;
    private double refreshDelay = 0.7;
    long prevTimeBaseTime;
    long currentTimeBaseTime;
    private boolean displayFramerate = true;
    private boolean displayTime = true;
    private String framerateCounterText = "FPS: ";
    private String timeText = "Time: ";
    private Frame frameRatecounterFrame;

    public FramerateCounter(Frame frameRatecounterFrame) {
        this.frameRatecounterFrame = frameRatecounterFrame;
    }

    public void setFramerateCounterText(String prefixText) {
        this.framerateCounterText = prefixText;
    }

    public void setTimeText(String prefixText) {
        this.timeText = prefixText;
    }

    @Override
    public void initTime(double time) {
        this.prevFramerateTime = this.currentTimeBaseTime = System.nanoTime();
        this.fpsCounter = 0;
        int secs = (int)time;
        if (!this.displayFramerate && !this.displayTime) {
            return;
        }
        if (this.displayFramerate) {
            if (this.displayTime) {
                this.frameRatecounterFrame.setTitle(this.framerateCounterText + "--" + "  " + this.timeText + secs);
            } else {
                this.frameRatecounterFrame.setTitle(this.framerateCounterText + "--");
            }
        } else if (this.displayTime) {
            this.frameRatecounterFrame.setTitle(this.timeText + secs);
        }
    }

    @Override
    public void time(double time) {
        if (!this.displayFramerate && !this.displayTime) {
            return;
        }
        this.currentTimeBaseTime = System.nanoTime();
        int secs = (int)time;
        if (!this.displayFramerate) {
            this.frameRatecounterFrame.setTitle(this.timeText + secs);
        } else {
            ++this.fpsCounter;
            double fpsDelta = (double)(this.currentTimeBaseTime - this.prevFramerateTime) / 1.0E9;
            if (fpsDelta >= this.refreshDelay) {
                int fps = (int)((double)this.fpsCounter / fpsDelta);
                if (this.displayTime) {
                    this.frameRatecounterFrame.setTitle(this.framerateCounterText + fps + "  " + this.timeText + secs);
                } else {
                    this.frameRatecounterFrame.setTitle(this.framerateCounterText + fps);
                }
                this.prevFramerateTime = this.currentTimeBaseTime;
                this.fpsCounter = 0;
            }
        }
    }

    public void setDisplayFramerate(boolean mode) {
        this.displayFramerate = mode;
    }

    public void setDisplayTime(boolean mode) {
        this.displayTime = mode;
    }

    public static void main(String[] arg) {
        Console.println("SystemClock test");
        ClockListener cl = new ClockListener(){
            private int count = 0;

            @Override
            public void initTime(double t) {
                this.count = 0;
            }

            @Override
            public void time(double t) {
                long timeMillis = (long)(t * 1000.0);
                if (this.count >= 0) {
                    Console.println("time: " + t + " millis: " + timeMillis + "   ");
                    this.count = 0;
                }
                ++this.count;
            }
        };
        SystemClock clock = new SystemClock(100L);
        framerateCounter = new FramerateCounter(Console.getFrame());
        framerateCounter.setDisplayTime(true);
        framerateCounter.setDisplayFramerate(true);
        clock.addClockListener(framerateCounter);
        clock.addClockListener(cl);
        clock.init();
        Console.delay(3000L);
        clock.start();
        Console.delay(3000L);
        clock.pause();
        clock.setMediaSeconds(0.0);
        Console.println("clock paused-2");
        Console.delay(2000L);
        Console.println("start clock-2");
        clock.start();
        Console.delay(3000L);
        clock.terminate();
        Console.println("Clock stopped");
    }
}

