/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FindClass {
    private List<String> locations = new ArrayList<String>();
    private List<Class<?>> matches = new ArrayList();
    private String selectedPackageName = null;
    private boolean recurse = true;
    private boolean matchArchives = false;
    private static final String fs = System.getProperty("path.separator");
    private static final String fileSep = System.getProperty("file.separator");
    public static final String version = "1.2";
    private static final String JAR = "jar";
    private static final String ZIP = "zip";

    public ImmutableSet<Class<?>> findClasses() {
        if (this.locations.size() == 0) {
            this.addLocations(System.getProperty("java.class.path"));
        }
        if (this.locations.size() > 0) {
            this.searchFiles();
        }
        return ImmutableSet.copyOf(this.matches);
    }

    public ImmutableSet<Class<?>> findClasses(String packageName) {
        this.selectedPackageName = packageName;
        ImmutableSet<Class<?>> allClasses = this.findClasses();
        return ImmutableSet.copyOf(allClasses);
    }

    private void searchFiles() {
        for (String location : this.locations) {
            if (location.toLowerCase().endsWith(JAR) || location.toLowerCase().endsWith(ZIP)) {
                this.findInArchive(location);
                continue;
            }
            this.findInDirectory(location);
        }
    }

    private void findInArchive(String archive) {
        try {
            JarFile jf = new JarFile(archive);
            Enumeration<JarEntry> enu = jf.entries();
            while (enu.hasMoreElements()) {
                ZipEntry ze = enu.nextElement();
                if (!ze.getName().endsWith("class")) continue;
                String className = ze.getName();
                className = className.substring(0, className.length() - 6);
                Class<?> c = this.transformToClass(className = className.replace('/', fileSep.charAt(0)));
                if (c == null) continue;
                this.matches.add(c);
            }
        }
        catch (FileNotFoundException fnex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Class<?> transformToClass(String fileName) {
        String className = fileName.substring(fileName.lastIndexOf(fileSep) + 1);
        String packageName = fileName.substring(0, fileName.lastIndexOf(fileSep) + 1);
        packageName = packageName.replace(fileSep.charAt(0), '.');
        while (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        if (this.selectedPackageName != null && !packageName.equals(this.selectedPackageName)) {
            return null;
        }
        Class<?> result = null;
        while (result == null) {
            String fullName = className;
            if (!packageName.equals("")) {
                fullName = packageName + "." + fullName;
            }
            try {
                result = Class.forName(fullName);
                break;
            }
            catch (Exception ex) {
            }
            catch (Error ex) {
                // empty catch block
            }
            if (packageName.indexOf(".") < 0 || packageName.indexOf(".") == packageName.length() - 1) {
                packageName = "";
                try {
                    result = Class.forName(className);
                }
                catch (Exception ex) {
                }
                catch (Error ex) {}
                break;
            }
            packageName = packageName.substring(packageName.indexOf(".") + 1);
        }
        return result;
    }

    private void findInDirectory(String dir) {
        this.findInDirectory(dir, dir);
    }

    private void findInDirectory(String baseDir, String dir) {
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            return;
        }
        if (!dirFile.isDirectory()) {
            return;
        }
        File[] dirEntries = this.matchArchives ? dirFile.listFiles(new JavaFilter()) : dirFile.listFiles();
        for (int i = 0; i < dirEntries.length; ++i) {
            File dirEntry = dirEntries[i];
            String name = dirEntry.getName();
            if (this.recurse && dirEntry.isDirectory()) {
                this.findInDirectory(baseDir, dirEntry.getAbsolutePath());
                continue;
            }
            if (name.endsWith(JAR) || name.endsWith(ZIP)) {
                this.findInArchive(dirEntry.getAbsolutePath());
                continue;
            }
            if (!name.endsWith("class")) continue;
            String className = dirEntry.getPath().substring(baseDir.length() + 1);
            Class<?> c = this.transformToClass(className = className.substring(0, className.length() - 6));
            if (c == null) continue;
            this.matches.add(c);
        }
    }

    private void addLocations(String filePath) {
        StringTokenizer st = new StringTokenizer(filePath, fs);
        while (st.hasMoreTokens()) {
            this.locations.add(st.nextToken());
        }
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setArchiveMatch(boolean archiveMatch) {
        this.matchArchives = archiveMatch;
    }

    private static void printHelp() {
        FindClass.printAbout();
        System.out.println("java nrs.findclass.FindClass <options> <classes>");
        System.out.println("Do _not_ specify packages.");
        System.out.println("If no classpath or directory is specified the system classpath will be searched.");
        System.out.println("Multiple files can be searched for at the same time.");
        System.out.println("    -a      print info about this program");
        System.out.println("    -c <classpath>  add specified classpath to system classpath");
        System.out.println("    -d <path>   search only in specified path(s)");
        System.out.println("    -f <file>   log output to file");
        System.out.println("    -h      this help message");
        System.out.println("    -i      ignore case (default: no)");
        System.out.println("    -j      only search Java archives (jar, zip) (default: no)");
        System.out.println("    -m      match word (default: no)");
        System.out.println("    -q      only print when a match is found\n");
        System.exit(0);
    }

    private static void printAbout() {
        System.out.println("FindClass 1.2");
        System.out.println("Searches a classpath for the specified file(s).");
        System.out.println("This utility is distributed under the terms of the GPL and comes with absolutely no warranty");
        System.out.println("Homepage: http://www.nsydenham.net/java/FindClass/FindClass.shtml");
        System.out.println("Copyright (C) 2002-2004 Nick Sydenham <nsydenham@yahoo.co.uk>\n");
    }

    public static void main(String[] args) {
        FindClass find = new FindClass();
        try {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equalsIgnoreCase("-a")) {
                    FindClass.printAbout();
                    System.exit(0);
                    continue;
                }
                if (arg.equals("-c")) {
                    find.addLocations(System.getProperty("java.class.path"));
                    find.addLocations(args[++i]);
                    continue;
                }
                if (arg.equals("-d")) {
                    find.addLocations(args[++i]);
                    continue;
                }
                if (arg.equalsIgnoreCase("-h")) {
                    FindClass.printHelp();
                    continue;
                }
                if (arg.equalsIgnoreCase("-j")) {
                    find.setArchiveMatch(true);
                    continue;
                }
                if (!arg.equalsIgnoreCase("-r")) continue;
                find.setRecurse(true);
            }
        }
        catch (IndexOutOfBoundsException iex) {
            System.out.println("Invalid arguments");
            FindClass.printHelp();
        }
        find.findClasses();
    }

    private static class JavaFilter
    implements FileFilter {
        private JavaFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String lName = file.getName().toLowerCase();
            return lName.endsWith(FindClass.JAR) || lName.endsWith(FindClass.ZIP);
        }
    }
}

