/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import java.util.List;

public final class Diff {
    private Diff() {
    }

    public static String showDiff(String msg, boolean a, boolean b) {
        if (a == b) {
            return "";
        }
        return msg + " diff : " + a + " / " + b;
    }

    public static String showDiff(String msg, int a, int b) {
        if (a == b) {
            return "";
        }
        return msg + " diff: " + a + " / " + b;
    }

    public static String showDiff(String msg, float a, float b) {
        if (a == b) {
            return "";
        }
        return msg + " diff: " + a + " / " + b;
    }

    public static String showDiff(String msg, double a, double b) {
        if (a == b) {
            return "";
        }
        return msg + " diff: " + a + " / " + b;
    }

    public static String showDiff(String msg, String a, String b) {
        if (a == null && b == null) {
            return "";
        }
        if (a == null) {
            return msg + ": null / non-null";
        }
        if (b == null) {
            return msg + ": non-null / null";
        }
        if (a.equals(b)) {
            return "";
        }
        return msg + " diff: \"" + a + "\" / \"" + b + "\"";
    }

    public static String showDiff(String msg, int[] a, int[] b) {
        if (a == null && b == null) {
            return "";
        }
        if (a == null) {
            return msg + ": null / non-null";
        }
        if (b == null) {
            return msg + ": non-null / null";
        }
        if (a.length != b.length) {
            return msg + ": diff lengths: " + a.length + " / " + b.length;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return msg + ": diff at Array pos " + i + ", values: " + a[i] + " / " + b[i];
        }
        return "";
    }

    public static String showDiff(String msg, float[] a, float[] b) {
        if (a == null && b == null) {
            return "";
        }
        if (a == null) {
            return msg + ": null / non-null";
        }
        if (b == null) {
            return msg + ": non-null / null";
        }
        if (a.length != b.length) {
            return msg + ": diff lengths: " + a.length + " / " + b.length;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return msg + ": diff at Array pos " + i + ", values: " + a[i] + " / " + b[i];
        }
        return "";
    }

    public static String showDiff2(String msg, float[][] a, float[][] b) {
        if (a == null && b == null) {
            return "";
        }
        if (a == null) {
            return msg + ": null / non-null";
        }
        if (b == null) {
            return msg + ": non-null / null";
        }
        if (a.length != b.length) {
            return msg + ": diff lengths: " + a.length + " / " + b.length;
        }
        for (int i = 0; i < a.length; ++i) {
            String diff = Diff.showDiff(msg + ": diff at (outer) Array pos " + i + "  ", a[i], b[i]);
            if (diff == "") continue;
            return diff;
        }
        return "";
    }

    public static String showDiff(String msg, String[] a, String[] b) {
        if (a == null && b == null) {
            return "";
        }
        if (a == null) {
            return msg + ": null / non-null";
        }
        if (b == null) {
            return msg + ": non-null / null";
        }
        if (a.length != b.length) {
            return msg + ": diff lengths: " + a.length + " / " + b.length;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return msg + ": diff at Array pos " + i + ", values: " + a[i] + " / " + b[i];
        }
        return "";
    }

    public static <T extends Differentiable> String showDiff(String msg, T a, T b) {
        if (a == null && b == null) {
            return "";
        }
        if (a == null) {
            return msg + ": null / non-null";
        }
        if (b == null) {
            return msg + ": non-null / null";
        }
        return a.showDiff(b);
    }

    public static String showDiff(String msg, List<? extends Differentiable> a, List<? extends Differentiable> b) {
        if (a == null && b == null) {
            return "";
        }
        if (a == null) {
            return msg + ": null / non-null";
        }
        if (b == null) {
            return msg + ": non-null / null";
        }
        if (a.size() != b.size()) {
            return msg + ": diff list sizes: " + a.size() + " / " + b.size();
        }
        for (int i = 0; i < a.size(); ++i) {
            String diff = a.get(i).showDiff(b.get(i));
            if (diff == "") continue;
            return msg + ": diff at List pos " + i + " : " + diff;
        }
        return "";
    }

    public static String showDiff2(String msg, List<? extends List<? extends Differentiable>> a, List<? extends List<? extends Differentiable>> b) {
        if (a == null && b == null) {
            return "";
        }
        if (a == null) {
            return msg + ": null / non-null";
        }
        if (b == null) {
            return msg + ": non-null / null";
        }
        if (a.size() != b.size()) {
            return msg + ": diff list sizes: " + a.size() + " / " + b.size();
        }
        for (int i = 0; i < a.size(); ++i) {
            String diff = Diff.showDiff(msg + ": diff at (outer) List pos " + i + "  ", a.get(i), b.get(i));
            if (diff == "") continue;
            return diff;
        }
        return "";
    }

    public static interface Differentiable {
        public String showDiff(Object var1);
    }
}

