/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.Terminator;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class Console {
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 300;
    public static final int DEFAULT_XOFF = 10;
    public static final int DEFAULT_YOFF = 20;
    public static final int XLEFTMARGIN = 5;
    public static final int XRIGHTMARGIN = 5;
    public static final int YTOPMARGIN = 30;
    public static final int YBOTTOMMARGIN = 0;
    public static final int BUTTONWIDTH = 50;
    public static final int BUTTONHEIGHT = 20;
    public static final int CHECKBOXWIDTH = 65;
    public static final String DEFAULT_TITLE = "Console";
    public static final int DEFAULT_PRINT_LIMIT = 10000;
    private static int width = 500;
    private static int height = 300;
    private static int xoff = 10;
    private static int yoff = 20;
    private static String title = "Console";
    private static ArrayList<Terminator> terminatorList;
    private static boolean classTerminated;
    private static TextArea text;
    private static Button clearButton;
    private static Button closeButton;
    private static Button quitButton;
    private static Checkbox enabledBox;
    private static Frame frame;
    private static boolean enabled;
    private static boolean frameEnabled;
    private static ConsoleListener consoleListener;
    private static PrintStream out;
    private static int printLimit;
    private static int printCounter;
    private static String timeFormat;
    private static boolean timestampsEnabled;
    private static Map<String, Counter> counters;
    public static final int SHOWMESSAGEDELAY = 1000;
    public static final int EXITDELAY = 1;
    private static boolean frameFocusable;
    private static final int BUTTONHEIGHTFACTOR1 = 2;
    private static final float BUTTONHEIGHTFACTOR2 = 1.5f;
    private static final int BUTTONWIDTHFACTOR1 = 3;
    private static final int BUTTONWIDTHFACTOR2 = 5;
    public static final int SYSTEMOUT = 1;
    public static final int SYSTEMERR = 2;
    public static final int WINDOW = 4;
    public static final int NONE = 0;

    private Console() {
    }

    public static void setCounterLimit(String counterName, int limit) {
        Counter ct = Console.getCounter(counterName);
        if (limit > 0) {
            ct.limit = limit;
        } else {
            ct.limit = Integer.MAX_VALUE;
        }
    }

    public static boolean cycleCounter(String counterName) {
        return Console.getCounter(counterName).cycleCounter();
    }

    public static Counter getCounter(String counterName) {
        if (counters == null) {
            return null;
        }
        return counters.get(counterName);
    }

    public static synchronized Counter getCounter(String counterName, int limit, int cycle) {
        Counter ct;
        if (counters == null) {
            counters = new HashMap<String, Counter>();
        }
        if ((ct = counters.get(counterName)) == null) {
            ct = new Counter(limit, cycle);
            counters.put(counterName, ct);
        }
        return ct;
    }

    public static void setTimeFormat(String format) {
        timeFormat = format;
    }

    public static void setTimestampsEnabled(boolean enabled) {
        timestampsEnabled = enabled;
    }

    public static void setPrintLimit(int limit) {
        printLimit = limit >= 0 ? limit : Integer.MAX_VALUE;
    }

    public static int getPrintLimit() {
        return printLimit - printCounter;
    }

    private static boolean printLimitReached() {
        if (printCounter > printLimit) {
            return true;
        }
        if (printCounter < printLimit) {
            return false;
        }
        ++printCounter;
        if (consoleListener != null) {
            consoleListener.println("Console printlimit reached  (" + printLimit + ")");
        }
        if (!enabled) {
            return true;
        }
        if (Console.checkFrame()) {
            text.append("Console printlimit reached  (" + printLimit + ")\n");
        } else {
            System.out.println("Console printlimit reached  (" + printLimit + ")");
        }
        return true;
    }

    public static void close(boolean reset) {
        if (frame != null) {
            frame.dispose();
            frame = null;
        }
        if (reset) {
            Console.reset();
        }
    }

    public static void close() {
        Console.close(true);
    }

    public static void reset() {
        width = 500;
        height = 300;
        xoff = 10;
        yoff = 20;
        title = DEFAULT_TITLE;
    }

    public static boolean terminateClass() {
        if (classTerminated) {
            return true;
        }
        classTerminated = true;
        boolean result = true;
        if (terminatorList != null) {
            for (Terminator terminator : terminatorList) {
                boolean properlyTerminated = terminator.terminate();
                if (properlyTerminated) continue;
                result = false;
                Console.println("Console: improper termination");
            }
        }
        return result;
    }

    public static void exit(int exitCode) {
        Console.println("Console.exit");
        boolean properlyTerminated = Console.terminateClass();
        if (!properlyTerminated) {
            Console.println("Some agents not terminated");
            Console.delay(1000L);
        }
        Console.delay(1L);
        System.exit(exitCode);
    }

    public static void exit() {
        Console.exit(0);
    }

    public static Frame getFrame() {
        return frame;
    }

    public static void setFocusable(boolean focusable) {
        frameFocusable = focusable;
    }

    private static void createFrame() {
        if (frame != null) {
            frame.dispose();
        }
        frame = new Frame();
        frame.setVisible(true);
        frame.setBackground(Color.lightGray);
        frame.setResizable(true);
        frame.setBounds(xoff, yoff, width, height);
        frame.setTitle(title);
        frame.setLayout(null);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Console.windowClose();
            }
        });
        text = new TextArea();
        frame.add(text);
        enabledBox = new Checkbox("Enabled", true);
        enabledBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                enabled = enabledBox.getState();
            }
        });
        frame.add(enabledBox);
        clearButton = new Button("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.clear();
            }
        });
        frame.add(clearButton);
        closeButton = new Button("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.close(false);
            }
        });
        frame.add(closeButton);
        quitButton = new Button("Quit");
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.exit();
            }
        });
        frame.add(quitButton);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Console.windowResize();
            }
        });
        Console.windowResize();
        frame.setVisible(true);
    }

    private static synchronized boolean checkFrame() {
        if (!frameEnabled || !enabled) {
            return false;
        }
        if (frame == null) {
            Console.createFrame();
        }
        return true;
    }

    protected static void windowClose() {
        Console.exit();
    }

    private static void closeFrame() {
        if (frame != null) {
            frame.dispose();
        }
        frame = null;
    }

    protected static void windowResize() {
        int gap;
        if (frame == null) {
            return;
        }
        width = frame.getWidth();
        height = frame.getHeight();
        int ew = width - 10;
        int eh = height - 70;
        int bY = (int)((float)(height - 0) - 30.0f);
        int enabledX = gap = (width - 65 - 150) / 5;
        int clearX = enabledX + 65 + gap;
        int closeX = clearX + 50 + gap;
        int quitX = closeX + 50 + gap;
        text.setBounds(5, 30, ew, eh);
        enabledBox.setBounds(enabledX, bY, 65, 20);
        clearButton.setBounds(clearX, bY, 50, 20);
        closeButton.setBounds(closeX, bY, 50, 20);
        quitButton.setBounds(quitX, bY, 50, 20);
    }

    public static synchronized void setBounds(int x, int y, int w, int h) {
        xoff = x;
        yoff = y;
        width = w;
        height = h;
        if (frame != null) {
            frame.setBounds(xoff, yoff, width, height);
            Console.windowResize();
        }
    }

    public static synchronized void setLocation(int x, int y) {
        xoff = x;
        yoff = y;
        if (frame != null) {
            frame.setBounds(xoff, yoff, width, height);
            Console.windowResize();
        }
    }

    public static synchronized void setSize(int w, int h) {
        width = w;
        height = h;
        if (frame != null) {
            frame.setBounds(xoff, yoff, width, height);
            Console.windowResize();
        }
    }

    public static synchronized void setTitle(String s) {
        title = s;
        if (frame != null) {
            frame.setTitle(title);
        }
    }

    public static void setVisible(boolean visible) {
        if (frameEnabled && visible) {
            Console.checkFrame();
        }
        if (frame != null) {
            frame.setVisible(visible);
        }
    }

    public static void clear() {
        if (!enabled) {
            return;
        }
        printCounter = 0;
        if (Console.checkFrame()) {
            text.setText("");
        }
    }

    public static void setText(String s) {
        if (Console.printLimitReached()) {
            return;
        }
        if (!enabled) {
            return;
        }
        if (Console.checkFrame()) {
            if (s == null) {
                Console.clear();
            } else {
                text.setText(s);
            }
        }
        if (out != null) {
            out.println("=setText===============");
            out.println(s);
            out.println("=======================");
        }
        ++printCounter;
    }

    public static void print(String s) {
        if (s == null || Console.printLimitReached()) {
            return;
        }
        if (consoleListener != null) {
            consoleListener.print(s);
        }
        if (!enabled) {
            return;
        }
        if (Console.checkFrame()) {
            text.append(s);
        }
        if (out != null) {
            out.print(s);
        }
        ++printCounter;
    }

    public static void println() {
        if (Console.printLimitReached()) {
            return;
        }
        if (consoleListener != null) {
            consoleListener.println();
        }
        if (!enabled) {
            return;
        }
        if (Console.checkFrame()) {
            text.append("\n");
        }
        if (out != null) {
            out.println();
        }
        ++printCounter;
    }

    public static void println(String s) {
        if (Console.printLimitReached()) {
            return;
        }
        if (s == null) {
            Console.println();
        } else {
            if (!enabled) {
                return;
            }
            if (Console.checkFrame()) {
                text.append(s);
                text.append("\n");
            }
            if (out != null) {
                out.println(s);
            }
        }
        ++printCounter;
    }

    public static void println(boolean test, String strue, String sfalse) {
        if (Console.printLimitReached()) {
            return;
        }
        Console.println(test ? strue : sfalse);
    }

    public static void println(boolean test, String s) {
        if (Console.printLimitReached()) {
            return;
        }
        if (test) {
            Console.println(s);
        }
    }

    public static void println(String counterName, String s) {
        Console.println(Console.cycleCounter(counterName), s);
    }

    public static void println(String counterName, int limit, int cycle, String s) {
        Counter ct = Console.getCounter(counterName, limit, cycle);
        Console.println(ct.cycleCounter(), s);
    }

    public static void toBack() {
        if (!enabled || !frameEnabled) {
            return;
        }
        if (frame != null) {
            frame.toBack();
        }
    }

    public static void toFront() {
        if (!enabled || !frameEnabled) {
            return;
        }
        Console.checkFrame();
        if (frame != null) {
            frame.toFront();
        }
    }

    public static void delay(long d) {
        try {
            Thread.sleep(d);
        }
        catch (Exception e) {
            System.out.println("Console.delay: " + e);
        }
    }

    public static void setBackground(Color c) {
        if (!enabled || !frameEnabled) {
            return;
        }
        if (frame == null) {
            return;
        }
        frame.setBackground(c);
        enabledBox.setBackground(c);
        clearButton.setBackground(c);
        closeButton.setBackground(c);
        quitButton.setBackground(c);
    }

    public static void setTextColor(Color c) {
        if (!enabled || !frameEnabled) {
            return;
        }
        text.setForeground(c);
    }

    public static synchronized void addTerminator(Terminator t) {
        if (terminatorList == null) {
            terminatorList = new ArrayList();
        }
        try {
            terminatorList.add(t);
        }
        catch (Exception e) {
            System.out.println("Console.addTerminator: " + e);
        }
    }

    public static void setEnabled(boolean mode) {
        enabled = mode;
    }

    public static void setFrameEnabled(boolean mode) {
        frameEnabled = mode;
        if (!frameEnabled) {
            Console.closeFrame();
        }
    }

    public static void setPrintStream(PrintStream s) {
        out = s;
    }

    public static void toChannels(int channel) {
        if ((channel & 1) != 0) {
            Console.setPrintStream(System.out);
        } else if ((channel & 2) != 0) {
            Console.setPrintStream(System.err);
        } else {
            Console.setPrintStream(null);
        }
        if ((channel & 4) != 0) {
            Console.setFrameEnabled(true);
        } else {
            Console.setFrameEnabled(false);
        }
    }

    public static void toSystemOut() {
        Console.toChannels(1);
    }

    public static void toSystemErr() {
        Console.toChannels(2);
    }

    public static void toConsoleWindow() {
        Console.toChannels(4);
    }

    public static void setConsoleListener(ConsoleListener cl) {
        consoleListener = cl;
    }

    public static void main(String[] arg) {
        Console.setVisible(true);
    }

    public static void captureError() {
        System.setErr(new PrintStream(new ConsoleOutputStream()));
    }

    public static void captureOut() {
        System.setOut(new PrintStream(new ConsoleOutputStream()));
    }

    static {
        classTerminated = false;
        enabled = true;
        frameEnabled = true;
        out = null;
        printLimit = 10000;
        printCounter = 0;
        timeFormat = "h:m:s";
        timestampsEnabled = false;
        frameFocusable = true;
    }

    static class ConsoleOutputStream
    extends OutputStream {
        ConsoleOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            text.append("" + (char)b);
        }
    }

    public static interface ConsoleListener {
        public void print(String var1);

        public void println(String var1);

        public void println();
    }

    public static class Counter {
        private int curCount;
        private int totalCount;
        private int cycle;
        private int limit;

        public Counter(int limit, int cycle) {
            this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
            this.cycle = cycle;
            this.curCount = cycle;
            this.totalCount = 0;
        }

        public boolean cycleCounter() {
            if (this.totalCount >= this.limit) {
                return false;
            }
            ++this.totalCount;
            ++this.curCount;
            if (this.curCount >= this.cycle) {
                this.curCount = 0;
                return true;
            }
            return false;
        }
    }
}

