/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CircularBuffer<E>
implements List<E> {
    private final ArrayList<E> buffer;
    private final int size;

    public CircularBuffer(int size) {
        this.buffer = new ArrayList(size);
        this.size = size;
    }

    @Override
    public E get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public int size() {
        return this.buffer.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.buffer.iterator();
    }

    private void fixSize() {
        while (this.buffer.size() > this.size) {
            this.buffer.remove(0);
        }
    }

    @Override
    public boolean add(E element) {
        if (this.buffer.add(element)) {
            this.fixSize();
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        this.buffer.add(index, element);
        this.fixSize();
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        if (this.buffer.addAll(elements)) {
            this.fixSize();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        if (this.buffer.addAll(index, elements)) {
            this.fixSize();
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public boolean contains(Object element) {
        return this.buffer.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        return this.buffer.containsAll(elements);
    }

    @Override
    public int indexOf(Object element) {
        return this.buffer.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.buffer.lastIndexOf(element);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.buffer.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.buffer.listIterator(index);
    }

    @Override
    public boolean remove(Object element) {
        return this.buffer.remove(element);
    }

    @Override
    public E remove(int element) {
        return this.buffer.remove(element);
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        return this.buffer.removeAll(elements);
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        return this.buffer.retainAll(elements);
    }

    @Override
    public E set(int index, E element) {
        return this.buffer.set(index, element);
    }

    @Override
    public List<E> subList(int index1, int index2) {
        return this.buffer.subList(index1, index2);
    }

    @Override
    public Object[] toArray() {
        return this.buffer.toArray();
    }

    @Override
    public <T> T[] toArray(T[] element) {
        return this.buffer.toArray(element);
    }
}

