/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import javax.swing.JOptionPane;

public final class CheckVersion {
    private CheckVersion() {
    }

    public static void requireVersion(String packageName, String requiredVersion) {
        Package pack = Package.getPackage(packageName);
        String specificationVersion = pack.getSpecificationVersion();
        if (specificationVersion == null) {
            return;
        }
        if (CheckVersion.isCompatibleWith(requiredVersion, specificationVersion)) {
            return;
        }
        String msg = "Package " + packageName + " Version " + pack.getSpecificationVersion() + " does not meet the required version " + requiredVersion;
        JOptionPane.showMessageDialog(null, msg, "Package Info", -1);
        throw new RuntimeException(msg);
    }

    public static String getVersion(String packageName) {
        Package pack = Package.getPackage(packageName);
        String result = pack.getSpecificationVersion();
        return result == null ? "" : result;
    }

    public static boolean isCompatibleWith(String desiredVersion, String specificationVersion) {
        if (specificationVersion == null) {
            return true;
        }
        String[] desiredNums = desiredVersion.split("[.]");
        String[] specificationNums = specificationVersion.split("[.]");
        try {
            for (int vn = 0; vn < desiredNums.length; ++vn) {
                int specified;
                int desired = Integer.valueOf(desiredNums[vn]);
                if (desired < (specified = vn < specificationNums.length ? Integer.valueOf(specificationNums[vn]) : 0)) {
                    return true;
                }
                if (desired <= specified) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException e) {
            System.out.println("CheckVersion.isCompatibelWith method: illegal version numbers: " + desiredVersion + " / " + specificationVersion);
            return false;
        }
    }
}

