/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.BinaryExternalizable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.util.BinUtil");

    public static void writeStringArray(DataOutput dataOut, String[] data) throws IOException {
        if (data == null) {
            dataOut.writeInt(-1);
        } else {
            dataOut.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                dataOut.writeUTF(data[i]);
            }
        }
    }

    public static String[] readStringArray(DataInput dataIn) throws IOException {
        String[] data = null;
        int size = dataIn.readInt();
        if (size >= 0) {
            data = new String[size];
            for (int i = 0; i < size; ++i) {
                data[i] = dataIn.readUTF();
            }
        }
        return data;
    }

    public static void writeIntArray(DataOutput dataOut, int[] data) throws IOException {
        if (data == null) {
            dataOut.writeInt(-1);
        } else {
            dataOut.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                dataOut.writeInt(data[i]);
            }
        }
    }

    public static int[] readIntArray(DataInput dataIn) throws IOException {
        int[] data = null;
        int size = dataIn.readInt();
        if (size >= 0) {
            data = new int[size];
            for (int i = 0; i < size; ++i) {
                data[i] = dataIn.readInt();
            }
        }
        return data;
    }

    public static void writeFloatArray(DataOutput dataOut, float[] data) throws IOException {
        if (data == null) {
            dataOut.writeInt(-1);
        } else {
            dataOut.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                dataOut.writeFloat(data[i]);
            }
        }
    }

    public static float[] readFloatArray(DataInput dataIn) throws IOException {
        float[] data = null;
        int size = dataIn.readInt();
        if (size >= 0) {
            data = new float[size];
            for (int i = 0; i < size; ++i) {
                data[i] = dataIn.readFloat();
            }
        }
        return data;
    }

    public static void writeBinaryList(DataOutput dataOut, List<? extends BinaryExternalizable> dataList) throws IOException {
        if (dataList == null) {
            dataOut.writeInt(-1);
        } else {
            dataOut.writeInt(dataList.size());
            for (BinaryExternalizable binaryExternalizable : dataList) {
                binaryExternalizable.writeBinary(dataOut);
            }
        }
    }

    public static <T extends BinaryExternalizable> ArrayList<T> readBinaryList(DataInput dataIn, Class<T> elemClass) throws IOException {
        int size = dataIn.readInt();
        if (size < 0) {
            return null;
        }
        ArrayList<BinaryExternalizable> result = new ArrayList<BinaryExternalizable>(size);
        try {
            for (int i = 0; i < size; ++i) {
                BinaryExternalizable elem = (BinaryExternalizable)elemClass.newInstance();
                elem.readBinary(dataIn);
                result.add(elem);
            }
        }
        catch (Exception e) {
            logger.error("BinUtil.readBinaryList: " + e);
        }
        return result;
    }

    public static void writeOptionalBinary(DataOutput dataOut, BinaryExternalizable bobj) throws IOException {
        if (bobj == null) {
            dataOut.writeInt(-1);
        } else {
            dataOut.writeInt(1);
            bobj.writeBinary(dataOut);
        }
    }

    public static <T extends BinaryExternalizable> T readOptionalBinary(DataInput dataIn, Class<T> elemClass) throws IOException {
        int hasData = dataIn.readInt();
        if (hasData < 0) {
            return null;
        }
        try {
            BinaryExternalizable result = (BinaryExternalizable)elemClass.newInstance();
            result.readBinary(dataIn);
            return (T)result;
        }
        catch (Exception e) {
            logger.error("BinUtil.readOptionalBinary: " + e);
            return null;
        }
    }

    public static void writeOptionalString(DataOutput dataOut, String str) throws IOException {
        if (str == null) {
            dataOut.writeInt(-1);
        } else {
            dataOut.writeInt(1);
            dataOut.writeUTF(str);
        }
    }

    public static String readOptionalString(DataInput dataIn) throws IOException {
        int hasData = dataIn.readInt();
        if (hasData < 0) {
            return null;
        }
        return dataIn.readUTF().intern();
    }
}

