/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.Console;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public final class UnJar {
    private static final int DIALOGWIDTH = 400;
    private static final int DIALOGHEIGHT = 200;
    private static final int BUFSIZE = 1024;

    private UnJar() {
    }

    public static String getJarForClass(Class<?> cl) {
        try {
            URI jarUri = cl.getProtectionDomain().getCodeSource().getLocation().toURI();
            return jarUri.toString();
        }
        catch (URISyntaxException e) {
            Console.println("Unjar: " + e);
            return "";
        }
    }

    public static List<String> autoExtract(String regex, String extractDirectory, boolean listOnly, boolean overwrite) {
        return UnJar.extract(UnJar.class, regex, extractDirectory, listOnly, overwrite);
    }

    public static List<String> extract(Class<?> cl, String regex, String extractDirectory, boolean listOnly, boolean overwrite) {
        return UnJar.extract(UnJar.getJarForClass(cl), regex, extractDirectory, listOnly, overwrite);
    }

    public static List<String> extract(String jar, String regex, String extractDirectory) {
        return UnJar.extract(jar, regex, extractDirectory, false, false);
    }

    public static List<String> list(String jar, String regex, String extractDirectory) {
        return UnJar.extract(jar, regex, extractDirectory, true, true);
    }

    public static List<String> extract(String jar, String regex, String extractDirectory, boolean listOnly, boolean overwrite) {
        File jarFile = null;
        if (jar.startsWith("file:")) {
            try {
                URI jarUri = new URI(jar);
                jarFile = new File(jarUri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unjar: " + e);
            }
        } else {
            jarFile = new File(jar);
        }
        File dir = new File(extractDirectory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("Unjar: Cannot find directory " + extractDirectory);
        }
        return UnJar.extract(jarFile, regex, dir, listOnly, overwrite);
    }

    public static List<String> extract(File jarfile, String regex, File extractDir) {
        return UnJar.extract(jarfile, regex, extractDir, false, false);
    }

    public static List<String> extract(File jarfile, String regex, File extractDir, boolean listOnly, boolean overwrite) {
        ArrayList<String> result = new ArrayList<String>();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarfile);
        }
        catch (IOException e) {
            Console.println("UnJar: " + e);
            return result;
        }
        String pex = ".*" + regex;
        Enumeration<JarEntry> enu = jarFile.entries();
        while (enu.hasMoreElements()) {
            JarEntry je = enu.nextElement();
            String jeName = je.getName();
            if (!jeName.matches(pex)) continue;
            File jeFile = new File(extractDir, jeName);
            if (!overwrite && jeFile.exists()) {
                String msg;
                long jeTime = je.getTime();
                Date jeDate = new Date(jeTime);
                long fileTime = jeFile.lastModified();
                Date fileDate = new Date(fileTime);
                long jeSize = je.getSize();
                long fileSize = jeFile.length();
                DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3);
                String fileDateString = dateFormat.format(fileDate);
                String jeDateString = dateFormat.format(jeDate);
                String optionMessage = "Existing " + jeName + " from    " + fileDateString + "\nReplacement file from " + jeDateString;
                if (jeTime == fileTime && jeSize == fileSize) continue;
                Object[] options = new String[]{"Yes", "No", "Cancel"};
                JOptionPane jpane = new JOptionPane(null, 3, 1, null, options, null);
                JDialog dialog = jpane.createDialog(null, null);
                dialog.setSize(400, 200);
                if (jeTime < fileTime) {
                    msg = optionMessage + "\nReplace existing file with older version?";
                    jpane.setMessage(msg);
                    jpane.setInitialValue("No");
                } else if (jeTime > fileTime) {
                    msg = optionMessage + "\nReplace  existing file with newer version?";
                    jpane.setMessage(msg);
                    jpane.setInitialValue("Yes");
                } else {
                    msg = "Existing file has size " + fileSize + "\n Replacement file has size " + jeSize + "\n Replace existing file?";
                    jpane.setMessage(msg);
                    jpane.setInitialValue("Yes");
                }
                dialog.setVisible(true);
                String selectedValue = (String)jpane.getValue();
                if (selectedValue == null) {
                    return result;
                }
                if (selectedValue.equals("Yes")) {
                    if (!listOnly) {
                        UnJar.extractJarEntry(jarFile, je, jeFile);
                    }
                    result.add(jeFile.toString());
                    continue;
                }
                if (!selectedValue.equals("Cancel")) continue;
                return result;
            }
            if (!listOnly) {
                UnJar.extractJarEntry(jarFile, je, jeFile);
            }
            result.add(jeFile.toString());
        }
        return result;
    }

    private static void extractJarEntry(JarFile jarFile, JarEntry jarEntry, File outputFile) {
        try {
            BufferedInputStream ips = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            String parentDir = outputFile.getParent();
            File parDir = new File(parentDir);
            if (!parDir.mkdirs()) {
                System.out.println("UnJar.extractJarEntry: could not create parent directory for " + outputFile.getName());
            }
            BufferedOutputStream ops = new BufferedOutputStream(new FileOutputStream(outputFile));
            byte[] buf = new byte[1024];
            int nbytes = ((InputStream)ips).read(buf);
            while (nbytes > 0) {
                ((OutputStream)ops).write(buf, 0, nbytes);
                nbytes = ((InputStream)ips).read(buf);
            }
            ((OutputStream)ops).flush();
            ((OutputStream)ops).close();
            ((InputStream)ips).close();
            if (!outputFile.setLastModified(jarEntry.getTime())) {
                System.out.println("UnJar.extractJarEntry: could not preserve timestamp for " + outputFile.getName());
            }
        }
        catch (IOException e) {
            Console.println("UnJar - Failed to extract " + jarEntry.getName() + ": " + e);
        }
    }

    public static String getCodeSourceLocation() {
        try {
            URI jarUri = UnJar.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            return jarUri.toString();
        }
        catch (URISyntaxException e) {
            Console.println("Unjar: " + e);
            return "--";
        }
    }

    public static void main(String[] arg) {
        try {
            URI jarUri = UnJar.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Console.println("UnJar jarUri: " + jarUri);
        }
        catch (URISyntaxException e) {
            Console.println("Unjar: " + e);
        }
    }
}

