/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.ClockListener;
import hmi.util.Console;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class SystemClock {
    public static final double REFRESHDELAY = 0.7;
    private Thread clockThread;
    private long nanoTickSize = 0L;
    private long currentTimeBaseTime = System.nanoTime();
    private volatile long mediaTime = 0L;
    private volatile double rate = 1.0;
    private long prevFramerateTime;
    private int framerateCounter;
    private double refreshDelay = 0.7;
    private String framerateCounterText = "FPS: ";
    private Frame frameRatecounterFrame;
    private volatile boolean listenersModified = false;
    private ArrayList<ClockListener> listeners = new ArrayList();
    private ArrayList<ClockListener> newListeners = new ArrayList();
    private static final int INIT = 0;
    private static final int RUNNING = 1;
    private static final int PAUSED = 2;
    private static final int TERMINATED = 3;
    private volatile int clockState = 0;
    private Semaphore runSem = new Semaphore(0);
    private static final long NANOSPERSMILLISECOND = 1000000L;
    private static final double NANOSPERSECOND = 1.0E9;
    private static final double MILLISPERSECOND = 1000.0;
    private static final int TESTTICKSIZE = 100;
    private static final int DELAY1 = 3000;
    private static final int DELAY2 = 3000;
    private static final int DELAY3 = 2000;
    private static final int DELAY4 = 3000;

    public SystemClock() {
        this(0L);
    }

    public SystemClock(long tickSize) {
        this.nanoTickSize = tickSize * 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClockListener(ClockListener listener) {
        ArrayList<ClockListener> arrayList = this.newListeners;
        synchronized (arrayList) {
            this.newListeners.add(listener);
            this.listenersModified = true;
        }
    }

    public synchronized double getMediaSeconds() {
        return (double)this.getMediaNanoseconds() / 1.0E9;
    }

    public synchronized void setMediaSeconds(double mt) {
        this.mediaTime = (long)(mt * 1.0E9);
    }

    public long getMediaNanoseconds() {
        return this.mediaTime;
    }

    public synchronized void start() {
        if (this.clockState == 3 || this.clockState == 1) {
            return;
        }
        if (this.clockState == 0) {
            this.clockState = 1;
            this.startClockThread();
        } else {
            this.clockState = 1;
        }
        this.runSem.release();
    }

    public synchronized void pause() {
        if (this.clockState == 3 || this.clockState == 2) {
            return;
        }
        if (this.clockState == 0) {
            this.clockState = 2;
            this.startClockThread();
        } else {
            this.clockState = 2;
        }
    }

    public synchronized void terminate() {
        if (this.clockState == 3) {
            return;
        }
        this.resetFrameRate();
        this.clockState = 3;
    }

    public synchronized void init() {
        if (this.clockState != 0) {
            return;
        }
        this.pause();
    }

    public synchronized void setRate(double rate) {
        this.rate = rate;
    }

    public synchronized double getRate() {
        return this.rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners() {
        if (this.listenersModified) {
            ArrayList<ClockListener> arrayList = this.newListeners;
            synchronized (arrayList) {
                this.listeners.addAll(this.newListeners);
                this.newListeners.clear();
                this.listenersModified = false;
            }
        }
    }

    private void initTime() {
        this.updateListeners();
        double curTime = (double)this.mediaTime / 1.0E9;
        for (ClockListener cl : this.listeners) {
            cl.initTime(curTime);
        }
    }

    private void time() {
        this.updateListeners();
        double curTime = (double)this.mediaTime / 1.0E9;
        for (ClockListener cl : this.listeners) {
            cl.time(curTime);
        }
    }

    private void startClockThread() {
        this.clockThread = new Thread(){

            @Override
            public void run() {
                try {
                    long prevTimeBaseTime = SystemClock.this.currentTimeBaseTime;
                    SystemClock.this.initTime();
                    while (SystemClock.this.clockState != 3) {
                        SystemClock.this.resetFrameRate();
                        SystemClock.this.runSem.acquire();
                        SystemClock.this.currentTimeBaseTime = System.nanoTime();
                        SystemClock.this.resetFrameRate();
                        while (SystemClock.this.clockState == 1) {
                            SystemClock.this.time();
                            SystemClock.this.showFrameRate();
                            long delta = SystemClock.this.currentTimeBaseTime + SystemClock.this.nanoTickSize - System.nanoTime();
                            if (delta <= 0L) {
                                Thread.yield();
                            } else {
                                Thread.sleep(delta / 1000000L);
                            }
                            prevTimeBaseTime = SystemClock.this.currentTimeBaseTime;
                            SystemClock.this.currentTimeBaseTime = System.nanoTime();
                            long timeBaseDelta = SystemClock.this.currentTimeBaseTime - prevTimeBaseTime;
                            long mediaTimeDelta = SystemClock.this.rate == 1.0 ? timeBaseDelta : (long)(SystemClock.this.rate * (double)timeBaseDelta);
                            SystemClock.this.mediaTime += mediaTimeDelta;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    SystemClock.this.clockState = 3;
                }
            }
        };
        this.clockThread.start();
    }

    public void setFramerateCounterFrame(Frame frame) {
        this.frameRatecounterFrame = frame;
    }

    public void setFramerateCounterPrefixText(String prefixText) {
        this.framerateCounterText = prefixText;
    }

    private void showFrameRate() {
        if (this.frameRatecounterFrame == null) {
            return;
        }
        ++this.framerateCounter;
        double fpsDelta = (double)(this.currentTimeBaseTime - this.prevFramerateTime) / 1.0E9;
        if (fpsDelta >= this.refreshDelay) {
            int fps = (int)((double)this.framerateCounter / fpsDelta);
            int secs = (int)(this.mediaTime / 1000000L);
            this.frameRatecounterFrame.setTitle(this.framerateCounterText + fps + " | " + secs);
            this.framerateCounter = 0;
            this.prevFramerateTime = this.currentTimeBaseTime;
        }
    }

    private void resetFrameRate() {
        if (this.frameRatecounterFrame == null) {
            return;
        }
        this.frameRatecounterFrame.setTitle(this.framerateCounterText + "--");
        this.framerateCounter = 0;
        this.prevFramerateTime = this.currentTimeBaseTime;
    }

    public static void main(String[] arg) {
        Console.println("SystemClock test");
        ClockListener cl = new ClockListener(){
            private int count = 0;

            @Override
            public void initTime(double t) {
                this.count = 0;
            }

            @Override
            public void time(double t) {
                long timeMillis = (long)(t * 1000.0);
                if (this.count >= 0) {
                    Console.println("time: " + t + " millis: " + timeMillis + "   ");
                    this.count = 0;
                }
                ++this.count;
            }
        };
        SystemClock clock = new SystemClock(100L);
        clock.setFramerateCounterFrame(Console.getFrame());
        clock.addClockListener(cl);
        clock.init();
        Console.delay(3000L);
        clock.start();
        Console.delay(3000L);
        clock.pause();
        clock.setMediaSeconds(0.0);
        Console.println("clock paused-2");
        Console.delay(2000L);
        Console.println("start clock-2");
        clock.start();
        Console.delay(3000L);
        clock.terminate();
        Console.println("Clock stopped");
    }
}

