/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Collection;

public final class StringUtil {
    private StringUtil() {
    }

    public static void splitToCollection(String str, String sep, Collection<String> c) {
        if (!str.equals("")) {
            for (String s : str.split(sep)) {
                c.add(s.trim());
            }
        }
    }

    public static boolean isNumeric(String inputData) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(inputData, pos);
        return inputData.length() == pos.getIndex();
    }

    public static boolean isInteger(String s) {
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (x == 0 && c == '-' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isPostiveInteger(String s) {
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static int diff(String s1, String s2) {
        int len2;
        if (s1 == null || s2 == null) {
            return -1;
        }
        int len1 = s1.length();
        int len = len1 < (len2 = s2.length()) ? len1 : len2;
        for (int i = 0; i < len; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return len1 == len2 ? -1 : len;
    }

    public static TextPos diffPos(String s1, String s2) {
        int d = StringUtil.diff(s1, s2);
        if (d < 0) {
            return new TextPos();
        }
        if (s1.length() >= s2.length()) {
            return StringUtil.getTextPos(s1, d);
        }
        return StringUtil.getTextPos(s2, d);
    }

    public static String showDiff(String msg, String s1, String s2) {
        int len2;
        if (s1 == null || s2 == null) {
            return "";
        }
        int len1 = s1.length();
        if (len1 != (len2 = s2.length())) {
            return msg + ": len1=" + len1 + ", len2=" + len2;
        }
        for (int i = 0; i < len1; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            int line = StringUtil.getLineNumber(s1, i);
            int linepos = StringUtil.getLinePos(s1, i);
            return msg + ": At line=" + line + ", pos=" + linepos + " ch1:'" + s1.charAt(i) + "'  ch2:'" + s2.charAt(i) + "'";
        }
        return "";
    }

    public static int getLineNumber(String s, int charPos) {
        if (s == null || charPos < 0 || charPos >= s.length()) {
            return -1;
        }
        int line = 0;
        for (int i = 1; i <= charPos; ++i) {
            if (s.charAt(i - 1) != '\n') continue;
            ++line;
        }
        return line;
    }

    public static int getLinePos(String s, int charPos) {
        if (s == null || charPos < 0 || charPos >= s.length()) {
            return -1;
        }
        int linepos = 0;
        for (int i = charPos - 1; i >= 0; --i) {
            if (s.charAt(i) == '\n') {
                return linepos;
            }
            ++linepos;
        }
        return linepos;
    }

    public static TextPos getTextPos(String s, int charPos) {
        if (s == null || charPos < 0 || charPos >= s.length()) {
            return new TextPos(-1, -1);
        }
        int line = 0;
        int linePos = 0;
        for (int i = 1; i <= charPos; ++i) {
            ++linePos;
            if (s.charAt(i - 1) != '\n') continue;
            ++line;
            linePos = 0;
        }
        TextPos result = new TextPos(line, linePos);
        return result;
    }

    public static class TextPos {
        private int lineNumber;
        private int linePos;

        public TextPos() {
            this.lineNumber = -1;
            this.linePos = -1;
        }

        public TextPos(int lineNumber, int linePos) {
            this.lineNumber = lineNumber;
            this.linePos = linePos;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public void setLinePos(int linePos) {
            this.linePos = linePos;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getLinePos() {
            return this.linePos;
        }

        public boolean equals(Object textpos) {
            if (textpos == null) {
                return false;
            }
            if (textpos instanceof TextPos) {
                TextPos pos = (TextPos)textpos;
                return pos.lineNumber == this.lineNumber && pos.linePos == this.linePos;
            }
            return false;
        }

        public int hashCode() {
            return this.lineNumber + this.linePos;
        }

        public boolean isDefined() {
            return this.lineNumber >= 0;
        }

        public String toString() {
            if (this.lineNumber < 0) {
                return "(-,-)";
            }
            if (this.linePos < 0) {
                return "(" + this.lineNumber + ", -)";
            }
            return "(" + this.lineNumber + ", " + this.linePos + ")";
        }
    }
}

