/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.Resources;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourcePool {
    private List<Resources> resourcesList = new ArrayList<Resources>();
    private Map<String, Object> resourceCache = new HashMap<String, Object>();
    private ResourceLoader loader;

    public ResourcePool() {
    }

    public ResourcePool(ResourceLoader loader) {
        this();
        this.setResourceLoader(loader);
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.loader = loader;
    }

    public void addResourceDirectory(String resourceDir) {
        Resources res = this.findResources(resourceDir);
        if (res != null) {
            return;
        }
        res = new Resources(resourceDir);
        this.resourcesList.add(0, res);
    }

    private Resources findResources(String resourceDir) {
        for (Resources res : this.resourcesList) {
            if (!res.getResourceDirectory().equals(resourceDir)) continue;
            return res;
        }
        return null;
    }

    public Object getResource(String resourceName, Object[] properties) throws IOException {
        Object resource = this.resourceCache.get(resourceName);
        if (resource != null) {
            return resource;
        }
        for (Resources res : this.resourcesList) {
            resource = this.loader.loadResource(res, resourceName, properties);
            if (resource == null) continue;
            this.resourceCache.put(resourceName, resource);
            return resource;
        }
        return null;
    }

    public Object getResource(String resourceName) throws IOException {
        return this.getResource(resourceName, null);
    }

    public static interface ResourceLoader {
        public Object loadResource(Resources var1, String var2, Object[] var3) throws IOException;
    }
}

