/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.Console;
import hmi.util.UnJar;
import java.io.File;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Lib {
    public static final String TMPDIR;

    private Lib() {
    }

    public static void addLibraryPath(String path) {
        Class<ClassLoader> sysclass = ClassLoader.class;
        try {
            String oldPath = System.getProperty("java.library.path");
            Field field = sysclass.getDeclaredField("sys_paths");
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            field.set(sysclass, null);
            System.setProperty("java.library.path", path + File.pathSeparator + oldPath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean isRunningFrom(String regex) {
        String location = Lib.getCodeSourceLocation(Lib.class);
        String pex = ".*" + regex;
        return Pattern.matches(pex, location);
    }

    public static boolean isRunningFrom(Class<?> cl, String regex) {
        String location = Lib.getCodeSourceLocation(cl);
        String pex = ".*" + regex;
        return Pattern.matches(pex, location);
    }

    public static String getCodeSourceLocation(Class<?> cl) {
        try {
            URI jarUri = cl.getProtectionDomain().getCodeSource().getLocation().toURI();
            return jarUri.toString();
        }
        catch (URISyntaxException e) {
            Console.println("Lib.getCodeSourceLocation: " + e);
            return "";
        }
    }

    public static String getJarName(String jarpath) {
        Pattern pat = Pattern.compile(".*?[/\\\\]?([^/\\\\]*)\\.jar");
        Matcher matcher = pat.matcher(jarpath);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    public static List<String> extractIfRunningFrom(String regex) {
        String jar = UnJar.getJarForClass(Lib.class);
        String dir = TMPDIR + Lib.getJarName(jar);
        return Lib.extractIfRunningFrom(regex, dir, true);
    }

    public static List<String> extractIfRunningFrom(String regex, boolean addToLibraryPath) {
        String jar = UnJar.getJarForClass(Lib.class);
        String dir = TMPDIR + Lib.getJarName(jar);
        return Lib.extractIfRunningFrom(regex, dir, addToLibraryPath);
    }

    public static List<String> extractIfRunningFrom(String regex, String extractDir, boolean addToLibraryPath) {
        if (Lib.isRunningFrom(Lib.class, regex)) {
            return Lib.extractLib(Lib.class, extractDir, addToLibraryPath);
        }
        return Collections.emptyList();
    }

    public static List<String> extractIfRunningFrom(String regex, String extractDir) {
        return Lib.extractIfRunningFrom(regex, extractDir, true);
    }

    public static void extractLib(boolean addToLibraryPath) {
        String jar = UnJar.getJarForClass(Lib.class);
        String dir = TMPDIR + Lib.getJarName(jar);
        Lib.extractLib(jar, dir, addToLibraryPath);
    }

    public static List<String> extractLib(Class<?> cl, boolean addToLibraryPath) {
        String jar = UnJar.getJarForClass(Lib.class);
        String dir = TMPDIR + Lib.getJarName(jar);
        return Lib.extractLib(jar, dir, addToLibraryPath);
    }

    public static List<String> extractLib(String extractDir, boolean addToLibraryPath) {
        String jar = UnJar.getJarForClass(Lib.class);
        return Lib.extractLib(jar, extractDir, addToLibraryPath);
    }

    public static List<String> extractLib(Class<?> cl, String extractDir, boolean addToLibraryPath) {
        return Lib.extractLib(UnJar.getJarForClass(cl), extractDir, addToLibraryPath);
    }

    public static List<String> extractLib(String jar, String extractDir, boolean addToLibraryPath) {
        String os = System.getProperty("os.name");
        String fileType = "(\\.dll)|(\\.manifest)";
        fileType = Pattern.matches(".*Windows.*", os) ? "(\\.dll)|(\\.manifest)" : "\\.so";
        File extDir = new File(extractDir);
        if (!extDir.mkdirs()) {
            System.out.println("Could not create " + extractDir + " directory");
        }
        List<String> extractedFiles = UnJar.extract(jar, fileType, extractDir);
        if (addToLibraryPath) {
            List<String> listedFiles = UnJar.list(jar, fileType, extractDir);
            Pattern pat = Pattern.compile("(.*?)[/\\\\]?[^/\\\\]*");
            HashSet<String> libpathset = new HashSet<String>();
            for (String file : listedFiles) {
                Matcher matcher = pat.matcher(file);
                if (!matcher.matches()) continue;
                String libdir = matcher.group(1);
                libpathset.add(libdir);
            }
            for (String libdir : libpathset) {
                Lib.addLibraryPath(libdir);
            }
        }
        return extractedFiles;
    }

    public static void startProc(String jarName, String libPath, String mainClass, List<String> params) {
        ArrayList<String> procbuilderargs = new ArrayList<String>();
        procbuilderargs.add("java");
        procbuilderargs.add("-cp");
        procbuilderargs.add(jarName);
        if (libPath != null && !libPath.equals("")) {
            procbuilderargs.add("-Djava.library.path=" + libPath);
        }
        procbuilderargs.addAll(params);
        procbuilderargs.add("-DisProc=true");
        procbuilderargs.add(mainClass);
        try {
            ProcessBuilder p = new ProcessBuilder(procbuilderargs);
            p.redirectErrorStream(true);
            Process proc = p.start();
            final LineNumberReader reader = new LineNumberReader(new InputStreamReader(proc.getInputStream()));
            Thread captureerrors = new Thread(){

                @Override
                public void run() {
                    boolean running = true;
                    try {
                        while (running) {
                            String line = reader.readLine();
                            if (line == null) {
                                running = false;
                                continue;
                            }
                            System.out.println(line);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Thread exception: " + e);
                    }
                }
            };
            captureerrors.start();
        }
        catch (Throwable e) {
            System.out.println("Exception: " + e);
        }
    }

    public static boolean startProcessIfRunningFrom(String regex, String mainClass, List<String> params) {
        String jar = UnJar.getJarForClass(Lib.class);
        String jarName = Lib.getJarName(jar);
        String extractDir = TMPDIR + jarName;
        String isProcProp = System.getProperty("isProc");
        boolean isProc = Boolean.valueOf(isProcProp);
        if (!isProc && Lib.isRunningFrom(Lib.class, regex)) {
            Lib.extractLib(Lib.class, extractDir, false);
            Lib.startProc(jarName + ".jar", extractDir + "/lib", mainClass, params);
            return true;
        }
        return false;
    }

    static {
        String filesep;
        String javatmpdir = System.getProperty("java.io.tmpdir");
        TMPDIR = javatmpdir.endsWith(filesep = System.getProperty("file.separator")) ? javatmpdir : javatmpdir + filesep;
    }
}

