/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.Console;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

public class InputState
implements KeyListener,
MouseListener,
FocusListener {
    public static final int NR_OF_KEYCODES = 256;
    private static final int NR_OF_MOUSE_BUTTONS = 3;
    private static final int KEYDIM = 259;
    public static final int MB1 = 256;
    public static final int MB2 = 257;
    public static final int MB3 = 258;
    public static final int L = 4;
    public static final int R = 8;
    public static final int S = 2;
    public static final int N = 16;
    public static final int A = 30;
    private int[] navKey = new int[259];
    private int[] keyDown = new int[259];
    public static final int KEYLISTENER = 1;
    public static final int MOUSELISTENER = 2;
    private int listenerMode = 0;
    private boolean button1Down = false;
    private boolean button2Down = false;
    private boolean button3Down = false;
    private int clickCount1 = 0;
    private int clickCount2 = 0;
    private int clickCount3 = 0;
    private int x1Pressed;
    private int y1Pressed;
    private int x1Released;
    private int y1Released;
    private int x2Pressed;
    private int y2Pressed;
    private int x2Released;
    private int y2Released;
    private int x3Pressed;
    private int y3Pressed;
    private int x3Released;
    private int y3Released;
    private int x;
    private int y;
    private ArrayList<Pattern> patterns = new ArrayList();

    public boolean isButton1Down() {
        return this.button1Down;
    }

    public boolean isButton2Down() {
        return this.button2Down;
    }

    public boolean isButton3Down() {
        return this.button3Down;
    }

    public int getClickCount1() {
        return this.clickCount1;
    }

    public int getClickCount2() {
        return this.clickCount2;
    }

    public int getClickCount3() {
        return this.clickCount3;
    }

    public int getX1pressed() {
        return this.x1Pressed;
    }

    public int getX2pressed() {
        return this.x2Pressed;
    }

    public int getX3pressed() {
        return this.x3Pressed;
    }

    public int getY1pressed() {
        return this.y1Pressed;
    }

    public int getY2pressed() {
        return this.y2Pressed;
    }

    public int getY3pressed() {
        return this.y3Pressed;
    }

    public int getX1released() {
        return this.x1Released;
    }

    public int getX2released() {
        return this.x2Released;
    }

    public int getX3released() {
        return this.x3Released;
    }

    public int getY1released() {
        return this.y1Released;
    }

    public int getY2released() {
        return this.y2Released;
    }

    public int getY3released() {
        return this.y3Released;
    }

    public InputState() {
    }

    public InputState(Component c) {
        this.listenerMode = 1;
        this.listenTo(c);
    }

    public InputState(Component c, int listenerMode) {
        this.listenerMode = listenerMode;
        this.listenTo(c);
    }

    public void listenTo(Component c) {
        if ((this.listenerMode & 1) != 0) {
            c.addKeyListener(this);
        }
        if ((this.listenerMode & 2) != 0) {
            c.addMouseListener(this);
        }
    }

    public void detachFrom(Component c) {
        if ((this.listenerMode & 1) != 0) {
            c.removeKeyListener(this);
        }
        if ((this.listenerMode & 2) != 0) {
            c.removeMouseListener(this);
        }
    }

    public Pattern addPattern(int[] down, int[] up) {
        int k;
        Key[] downKeys = null;
        Key[] upKeys = null;
        if (down != null) {
            downKeys = new Key[down.length];
            for (k = 0; k < down.length; ++k) {
                downKeys[k] = new Key(down[k], 30);
            }
        }
        if (up != null) {
            upKeys = new Key[up.length];
            for (k = 0; k < up.length; ++k) {
                upKeys[k] = new Key(up[k], 30);
            }
        }
        return this.addPattern(downKeys, upKeys);
    }

    public Pattern addPattern(Key[] down, Key[] up) {
        KeyPat newpat = new KeyPat(down, up);
        this.patterns.add(newpat);
        return newpat;
    }

    public Pattern addPattern(Key[] down) {
        KeyPat newpat = new KeyPat(down, null);
        this.patterns.add(newpat);
        return newpat;
    }

    public Pattern addPattern(Key key) {
        KeyPat newpat = new KeyPat(new Key[]{key}, null);
        this.patterns.add(newpat);
        return newpat;
    }

    public Pattern orPattern(final Pattern[] pats) {
        Pattern result = new Pattern(){

            @Override
            public boolean isActive() {
                for (int p = 0; p < pats.length; ++p) {
                    if (!pats[p].isActive()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void checkState() {
            }
        };
        return result;
    }

    public static Key key(int vkCode, int locationMask) {
        return new Key(vkCode, locationMask);
    }

    public static Key key(int vkCode) {
        return new Key(vkCode, 30);
    }

    public static Key numpad(int vkCode) {
        return new Key(vkCode, 16);
    }

    public static Key left(int vkCode) {
        return new Key(vkCode, 4);
    }

    public static Key right(int vkCode) {
        return new Key(vkCode, 8);
    }

    public static Key standard(int vkCode) {
        return new Key(vkCode, 2);
    }

    private synchronized void classify() {
        for (Pattern pat : this.patterns) {
            pat.checkState();
        }
    }

    @Override
    public final void keyPressed(KeyEvent evt) {
        Console.println("InputState.keyPressed: " + evt.getKeyCode());
        int keyCode = evt.getKeyCode();
        int keyloc = 1 << evt.getKeyLocation();
        if (keyCode >= 256 || (this.navKey[keyCode] & keyloc) == 0) {
            return;
        }
        if ((this.keyDown[keyCode] & keyloc) == 0) {
            int n = keyCode;
            this.keyDown[n] = this.keyDown[n] | keyloc;
            this.classify();
        }
    }

    @Override
    public final void keyReleased(KeyEvent evt) {
        Console.println("InputState.keyReleased: " + evt.getKeyCode());
        int keyCode = evt.getKeyCode();
        int keyloc = 1 << evt.getKeyLocation();
        if (keyCode >= 256 || (this.navKey[keyCode] & keyloc) == 0) {
            return;
        }
        int n = keyCode;
        this.keyDown[n] = this.keyDown[n] & ~keyloc;
        this.classify();
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
    }

    @Override
    public final void mouseExited(MouseEvent e) {
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        int button = e.getButton();
        if (button == 1) {
            this.button1Down = true;
            this.clickCount1 = e.getClickCount();
            this.keyDown[256] = 2;
            this.x1Pressed = this.x;
            this.y1Pressed = this.y;
        } else if (button == 2) {
            this.button2Down = true;
            this.clickCount2 = e.getClickCount();
            this.keyDown[257] = 2;
            this.x2Pressed = this.x;
            this.y2Pressed = this.y;
        } else if (button == 3) {
            this.button3Down = true;
            this.clickCount3 = e.getClickCount();
            this.keyDown[258] = 2;
            this.x3Pressed = this.x;
            this.y3Pressed = this.y;
        } else {
            Console.println("Unknown mouse button number: " + button);
        }
        this.classify();
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        int button = e.getButton();
        if (button == 1) {
            this.button1Down = false;
            this.x1Released = this.x;
            this.y1Released = this.y;
            this.clickCount1 = e.getClickCount();
            this.keyDown[256] = 0;
        } else if (button == 2) {
            this.button2Down = false;
            this.x2Released = this.x;
            this.y2Released = this.y;
            this.clickCount2 = e.getClickCount();
            this.keyDown[257] = 0;
        } else if (button == 3) {
            this.button3Down = false;
            this.x3Released = this.x;
            this.y3Released = this.y;
            this.clickCount2 = e.getClickCount();
            this.keyDown[258] = 0;
        } else {
            Console.println("Unknown mouse button number: " + button);
        }
        this.classify();
    }

    public final void mouseDragged(MouseEvent e) {
    }

    public final void mouseMoved(MouseEvent e) {
    }

    public final void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public final void keyTyped(KeyEvent evt) {
    }

    public String locationString(int location) {
        if (location == 4) {
            return "Left";
        }
        if (location == 8) {
            return "Right";
        }
        if (location == 16) {
            return "Numpad";
        }
        if (location == 2) {
            return "S";
        }
        return "U";
    }

    private void reset() {
        for (int i = 0; i < 256; ++i) {
            this.keyDown[i] = 0;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Console.println("focus gained");
        this.reset();
    }

    @Override
    public void focusLost(FocusEvent e) {
        Console.println("focus lost");
        this.reset();
    }

    public final class KeyPat
    implements Pattern {
        private int[] up;
        private int[] down;
        private int[] upLocation;
        private int[] downLocation;
        private volatile boolean active;

        public KeyPat(Key[] downKeys, Key[] upKeys) {
            int k;
            if (downKeys != null) {
                this.down = new int[downKeys.length];
                this.downLocation = new int[downKeys.length];
                for (k = 0; k < downKeys.length; ++k) {
                    this.down[k] = downKeys[k].getVkCode();
                    this.downLocation[k] = downKeys[k].getLocationMask();
                    int[] nArray = InputState.this.navKey;
                    int n = this.down[k];
                    nArray[n] = nArray[n] | this.downLocation[k];
                }
            }
            if (upKeys != null) {
                this.up = new int[upKeys.length];
                this.upLocation = new int[upKeys.length];
                for (k = 0; k < upKeys.length; ++k) {
                    this.up[k] = upKeys[k].getVkCode();
                    this.upLocation[k] = upKeys[k].getLocationMask();
                    int[] nArray = InputState.this.navKey;
                    int n = this.up[k];
                    nArray[n] = nArray[n] | this.upLocation[k];
                }
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public void checkState() {
            int k;
            if (this.down != null) {
                for (k = 0; k < this.down.length; ++k) {
                    if ((InputState.this.keyDown[this.down[k]] & this.downLocation[k]) != 0) continue;
                    this.active = false;
                    return;
                }
            }
            if (this.up != null) {
                for (k = 0; k < this.up.length; ++k) {
                    if ((InputState.this.keyDown[this.up[k]] & this.upLocation[k]) == 0) continue;
                    this.active = false;
                    return;
                }
            }
            this.active = true;
        }
    }

    public static class Key {
        private int vkCode;
        private int locationMask;

        public Key(int vkCode, int locationMask) {
            this.vkCode = vkCode;
            this.locationMask = locationMask;
        }

        public int getVkCode() {
            return this.vkCode;
        }

        public int getLocationMask() {
            return this.locationMask;
        }
    }

    public static interface Pattern {
        public boolean isActive();

        public void checkState();
    }
}

