/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.ClockListener;
import hmi.util.SystemClock;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ClockPanel
extends JPanel
implements ClockListener {
    private SystemClock clock;
    private JLabel timeLabel;
    double prevTime = -500.0;

    public ClockPanel(SystemClock c) {
        this.clock = c;
        this.initUI();
        this.clock.addClockListener(this);
    }

    protected void initUI() {
        this.timeLabel = new JLabel("00:00");
        this.timeLabel.setFont(new Font("Times New Roman", 1, 50));
        this.add(this.timeLabel);
    }

    public void setLabelFont(Font f) {
        this.timeLabel.setFont(f);
    }

    @Override
    public void initTime(double initTime) {
        if (initTime - this.prevTime > 0.01) {
            this.timeLabel.setText(String.format("%10.3f", initTime));
            this.timeLabel.repaint();
            this.prevTime = initTime;
        }
    }

    @Override
    public void time(double currentTime) {
        if (currentTime - this.prevTime > 0.01) {
            this.timeLabel.setText(String.format("%10.3f", currentTime));
            this.timeLabel.repaint();
            this.prevTime = currentTime;
        }
    }
}

