/*
 * Decompiled with CFR 0.152.
 */
package hmi.util;

import hmi.util.ClockListener;
import hmi.util.SystemClock;
import java.awt.Font;
import javax.swing.JLabel;

public class ClockLabel
extends JLabel
implements ClockListener {
    private SystemClock clock;
    double prevTime = -500.0;

    public ClockLabel(SystemClock c) {
        this.clock = c;
        this.initUI();
        this.clock.addClockListener(this);
    }

    protected void initUI() {
        this.setFont(new Font("Times New Roman", 1, 50));
    }

    public void setLabelFont(Font f) {
        this.setFont(f);
    }

    @Override
    public void initTime(double initTime) {
        if (initTime - this.prevTime > 0.01) {
            this.setText(String.format("%10.3f", initTime));
            this.repaint();
            this.prevTime = initTime;
        }
    }

    @Override
    public void time(double currentTime) {
        if (currentTime - this.prevTime > 0.01) {
            this.setText(String.format("%10.3f", currentTime));
            this.repaint();
            this.prevTime = currentTime;
        }
    }
}

