/*
 * Decompiled with CFR 0.152.
 */
package hmi.textengine;

import asap.environment.AsapVirtualHuman;
import asap.environment.EmbodimentLoader;
import asap.environment.EngineLoader;
import asap.environment.Environment;
import asap.environment.Loader;
import hmi.elckerlyc.DefaultEngine;
import hmi.elckerlyc.DefaultPlayer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.elckerlyc.planunit.SingleThreadedPlanPlayer;
import hmi.speechengine.TextOutput;
import hmi.speechengine.TextPlanner;
import hmi.speechengine.TimedTextSpeechUnit;
import hmi.textengine.EmbodimentTextOutput;
import hmi.textengine.TextEmbodiment;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextSpeechEngineLoader
implements EngineLoader {
    private static Logger logger = LoggerFactory.getLogger((String)TextSpeechEngineLoader.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private TextEmbodiment te = null;
    private Engine engine = null;
    private PlanManager<TimedTextSpeechUnit> speechPlanManager = null;
    private Player speechPlayer = null;
    private PlanPlayer speechPlanPlayer = null;
    private Planner<TimedTextSpeechUnit> speechPlanner = null;
    String id = "";
    AsapVirtualHuman theVirtualHuman = null;

    public void readXML(XMLTokenizer tokenizer, String newId, AsapVirtualHuman avh, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        this.theVirtualHuman = avh;
        for (Loader e : requiredLoaders) {
            if (!(e instanceof EmbodimentLoader) || !(((EmbodimentLoader)e).getEmbodiment() instanceof TextEmbodiment)) continue;
            this.te = (TextEmbodiment)((EmbodimentLoader)e).getEmbodiment();
        }
        if (this.te == null) {
            throw new RuntimeException("TextSpeechEngineLoader requires an Embodiment of type TextEmbodiment");
        }
        this.speechPlanManager = new PlanManager();
        this.speechPlanPlayer = new SingleThreadedPlanPlayer(this.theVirtualHuman.getElckerlycRealizer().getFeedbackManager(), this.speechPlanManager);
        this.speechPlayer = new DefaultPlayer(this.speechPlanPlayer);
        this.speechPlanner = new TextPlanner(this.theVirtualHuman.getElckerlycRealizer().getFeedbackManager(), (TextOutput)new EmbodimentTextOutput(this.te), this.speechPlanManager);
        this.engine = new DefaultEngine(this.speechPlanner, this.speechPlayer, this.speechPlanManager);
        this.engine.setId(this.id);
        this.theVirtualHuman.getElckerlycRealizer().addEngine(this.engine);
    }

    public void unload() {
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Player getPlayer() {
        return this.speechPlayer;
    }

    public Planner getSpeechPlanner() {
        return this.speechPlanner;
    }

    public PlanManager<TimedTextSpeechUnit> getPlanManager() {
        return this.speechPlanManager;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }
}

