/*
 * Decompiled with CFR 0.152.
 */
package hmi.testutil.xml;

import hmi.testutil.LabelledParameterized;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import junit.framework.AssertionFailedError;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

@RunWith(value=LabelledParameterized.class)
public abstract class XSDValidationTest {
    protected Reader xsdReader;
    private File currentFile;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)XSDValidationTest.class.getName());

    private static void getFilesRecursive(File dir, List<File> fileList) {
        for (File f : dir.listFiles()) {
            if (f.isFile() && f.getName().endsWith(".xml")) {
                fileList.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            XSDValidationTest.getFilesRecursive(f, fileList);
        }
    }

    public static Collection<Object[]> configs(String[] xmlDirectories) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (String xmlDirectory : xmlDirectories) {
            File dir = new File(xmlDirectory);
            XSDValidationTest.getFilesRecursive(dir, fileList);
        }
        ArrayList<Object[]> objs = new ArrayList<Object[]>();
        for (File f : fileList) {
            Object[] obj = new Object[]{f.getAbsolutePath(), f};
            objs.add(obj);
        }
        return objs;
    }

    public static Collection<Object[]> configs(String xmlDirectory) {
        File dir = new File(xmlDirectory);
        ArrayList<File> fileList = new ArrayList<File>();
        XSDValidationTest.getFilesRecursive(dir, fileList);
        ArrayList<Object[]> objs = new ArrayList<Object[]>();
        for (File f : fileList) {
            Object[] obj = new Object[]{f.getAbsolutePath(), f};
            objs.add(obj);
        }
        return objs;
    }

    public XSDValidationTest(String label, File f) {
        this.currentFile = f;
    }

    protected InputStream getXSDStream(String fileName) {
        return null;
    }

    @Test
    public void validateXML() {
        try {
            LOGGER.debug("validateXML for " + this.currentFile);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(this.currentFile);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            factory.setResourceResolver(new XSDPathResourceResolver());
            StreamSource schemaFile = new StreamSource(this.xsdReader);
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(document));
        }
        catch (Exception ex) {
            AssertionFailedError afe = new AssertionFailedError("ParserConfigurationException in file " + this.currentFile.getAbsolutePath());
            afe.initCause((Throwable)ex);
            throw afe;
        }
    }

    private final class XSDPathResourceResolver
    implements LSResourceResolver {
        private DOMImplementationLS domImplementationLS;

        private XSDPathResourceResolver() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            this.domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LOGGER.debug("==== Resolving '" + type + "' '" + namespaceURI + "' '" + publicId + "' '" + systemId + "' '" + baseURI + "'");
            LSInput lsInput = this.domImplementationLS.createLSInput();
            InputStream is = XSDValidationTest.this.getXSDStream(systemId);
            if (is == null) {
                return null;
            }
            lsInput.setByteStream(is);
            lsInput.setSystemId(systemId);
            lsInput.setBaseURI(baseURI);
            lsInput.setPublicId(publicId);
            LOGGER.debug("==== Resolved ====");
            return lsInput;
        }
    }
}

