/*
 * Decompiled with CFR 0.152.
 */
package hmi.testutil.tts;

import hmi.tts.AbstractTTSGenerator;
import hmi.tts.Bookmark;
import hmi.tts.TimingInfo;
import hmi.tts.Visime;
import hmi.tts.WordDescription;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTTSGeneratorTest {
    protected static AbstractTTSGenerator ttsG = null;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractTTSGeneratorTest.class.getName());

    @Test
    public void testVisimes() {
        for (String voice : ttsG.getVoices()) {
            ttsG.setVoice(voice);
            TimingInfo tInfo = ttsG.getBMLTiming("<sync id=\"deicticheart1\"/>Welcome!<sync id=\"deicticheart2\"/> I am Griet, I am 16 year old and I would like to tell you something about my life. People know me as the girl with the pearl ear ring. My father can no longer work since he was blinded. <sync id=\"beat1b1\"/>Because we still need to eat, I took service with a local painter. His name is Johannes <sync id=\"vermeer1\"/>Vermeer.<sync id=\"vermeer2\"/>");
            List vs = tInfo.getVisimes();
            double totalDuration = 0.0;
            for (Visime v : vs) {
                totalDuration += (double)v.getDuration() / 1000.0;
            }
            Assert.assertEquals((double)totalDuration, (double)tInfo.getDuration(), (double)0.015);
        }
    }

    @Test
    public void testBookmarks() {
        int i$ = 0;
        String[] arr$ = ttsG.getVoices();
        int len$ = arr$.length;
        if (i$ < len$) {
            String voice = arr$[i$];
            ttsG.setVoice(voice);
            TimingInfo tInfo = ttsG.getBMLTiming("<sync id=\"deicticheart1\"/>Welcome!<sync id=\"deicticheart2\"/> I am Griet, I am 16 year old and I would like to tell you something about my life. People know me as the girl with the pearl ear ring. My father can no longer work since he was blinded. <sync id=\"beat1b1\"/>Because we still need to eat, I took service with a local painter. His name is Johannes <sync id=\"vermeer1\"/>Vermeer.<sync id=\"vermeer2\"/>");
            Bookmark b1 = tInfo.getBookmark("deicticheart1");
            Bookmark b2 = tInfo.getBookmark("deicticheart2");
            MatcherAssert.assertThat((Object)b2.getOffset(), (Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(b1.getOffset())));
            Assert.assertEquals((long)0L, (long)b1.getOffset());
            Bookmark v1 = tInfo.getBookmark("vermeer1");
            Bookmark v2 = tInfo.getBookmark("vermeer2");
            MatcherAssert.assertThat((Object)v2.getOffset(), (Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(v1.getOffset())));
            Assert.assertEquals((double)v2.getOffset(), (double)Math.round(tInfo.getDuration() * 1000.0), (double)0.001f);
            return;
        }
    }

    @Test
    public void testBookmarksWav() throws IOException {
        for (String voice : ttsG.getVoices()) {
            ttsG.setVoice(voice);
            File f = File.createTempFile("testBookmarksWav", ".wav");
            TimingInfo tInfo = ttsG.speakBMLToFile("<sync id=\"deicticheart1\"/>Welcome!<sync id=\"deicticheart2\"/> I am Griet, I am 16 year old and I would like to tell you something about my life. People know me as the girl with the pearl ear ring. My father can no longer work since he was blinded. <sync id=\"beat1b1\"/>Because we still need to eat, I took service with a local painter. His name is Johannes <sync id=\"vermeer1\"/>Vermeer.<sync id=\"vermeer2\"/>", f.getAbsolutePath());
            if (!f.delete()) {
                LOGGER.warn("Can't delete temp file! {}", (Object)f.getName());
            }
            Bookmark b1 = tInfo.getBookmark("deicticheart1");
            Bookmark b2 = tInfo.getBookmark("deicticheart2");
            MatcherAssert.assertThat((Object)b2.getOffset(), (Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(b1.getOffset())));
            Assert.assertEquals((long)0L, (long)b1.getOffset());
            Bookmark v1 = tInfo.getBookmark("vermeer1");
            Bookmark v2 = tInfo.getBookmark("vermeer2");
            MatcherAssert.assertThat((Object)v2.getOffset(), (Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(v1.getOffset())));
            Assert.assertEquals((long)v2.getOffset(), (long)Math.round(tInfo.getDuration() * 1000.0));
        }
    }

    @Test
    public void testDuration() {
        TimingInfo tInfo = ttsG.getBMLTiming("test");
        Assert.assertEquals((Object)"test", (Object)((WordDescription)tInfo.getWordDescriptions().get(0)).getWord());
        MatcherAssert.assertThat((Object)tInfo.getDuration(), (Matcher)OrderingComparison.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void testSpeakDuration() {
        TimingInfo tInfo = ttsG.speak("test");
        Assert.assertEquals((Object)"test", (Object)((WordDescription)tInfo.getWordDescriptions().get(0)).getWord());
        MatcherAssert.assertThat((Object)tInfo.getDuration(), (Matcher)OrderingComparison.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    @Test
    public void testWavDuration() throws IOException {
        File f = File.createTempFile("test", ".wav");
        TimingInfo tInfo = ttsG.speakBMLToFile("test", f.getAbsolutePath());
        if (!f.delete()) {
            LOGGER.warn("Can't delete temp file!");
        }
        Assert.assertEquals((Object)"test", (Object)((WordDescription)tInfo.getWordDescriptions().get(0)).getWord());
        MatcherAssert.assertThat((Object)tInfo.getDuration(), (Matcher)OrderingComparison.greaterThan((Comparable)Double.valueOf(0.0)));
    }
}

