/*
 * Decompiled with CFR 0.152.
 */
package hmi.testutil.rules;

import hmi.testutil.rules.TimeoutCallback;
import org.junit.runners.model.Statement;

public class FailOnTimeoutWithCallback
extends Statement {
    private Statement fNext;
    private final long fTimeout;
    private final TimeoutCallback timeoutCallback;
    private boolean fFinished = false;
    private Throwable fThrown = null;

    public FailOnTimeoutWithCallback(Statement next, long timeout, TimeoutCallback cb) {
        this.fNext = next;
        this.fTimeout = timeout;
        this.timeoutCallback = cb;
    }

    public void evaluate() throws Throwable {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    FailOnTimeoutWithCallback.this.fNext.evaluate();
                    FailOnTimeoutWithCallback.this.fFinished = true;
                }
                catch (Throwable e) {
                    FailOnTimeoutWithCallback.this.fThrown = e;
                }
            }
        };
        thread.start();
        thread.join(this.fTimeout);
        if (this.fFinished) {
            return;
        }
        if (this.fThrown != null) {
            throw this.fThrown;
        }
        Exception exception = new Exception(String.format("test timed out after %d milliseconds. Progress information: %s", this.fTimeout, this.timeoutCallback.getProgressInfo()));
        exception.setStackTrace(thread.getStackTrace());
        throw exception;
    }
}

