/*
 * Decompiled with CFR 0.152.
 */
package hmi.testutil.argumentmatcher;

import hmi.math.Vec3f;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class Vec3fMatcher
extends TypeSafeMatcher<float[]> {
    private final float[] expected;
    private final float epsilon;
    private static final float DEFAULT_EPSILON = 0.01f;

    public Vec3fMatcher(float[] expected) {
        this(expected, 0.01f);
    }

    Vec3fMatcher(float[] expected, float epsilon) {
        this.expected = expected;
        this.epsilon = epsilon;
    }

    public boolean matchesSafely(float[] actual) {
        return Vec3f.epsilonEquals((float[])actual, (float[])this.expected, (float)this.epsilon);
    }

    public void describeTo(Description description) {
        description.appendText(Vec3f.toString((float[])this.expected));
    }

    @Factory
    public static <T> Matcher<float[]> equalsVec3f(float[] expected) {
        return new Vec3fMatcher(expected);
    }
}

