/*
 * Decompiled with CFR 0.152.
 */
package hmi.testutil;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runners.Parameterized;

public class LabelledParameterized
extends Parameterized {
    private List<String> labels;
    private Description labelledDescription;

    public LabelledParameterized(Class<?> cl) throws Throwable {
        super(cl);
        this.initialiseLabels();
        this.generateLabelledDescription();
    }

    private void initialiseLabels() throws Exception {
        Collection<Object[]> parameterArrays = this.getParameterArrays();
        this.labels = new ArrayList<String>();
        for (Object[] parameterArray : parameterArrays) {
            String label = parameterArray[0].toString();
            this.labels.add(label);
        }
    }

    private Collection<Object[]> getParameterArrays() throws Exception {
        Method testClassMethod = this.getDeclaredMethod(((Object)((Object)this)).getClass(), "getTestClass", new Class[0]);
        Class<?> returnType = testClassMethod.getReturnType();
        if (returnType == Class.class) {
            return this.getParameterArrays4_3();
        }
        return this.getParameterArrays4_4();
    }

    private Collection<Object[]> getParameterArrays4_3() throws Exception {
        Object[][] methodCalls = new Object[][]{{"getTestClass"}};
        Class cl = (Class)this.invokeMethodChain((Object)this, methodCalls);
        Method[] methods = cl.getMethods();
        Method parametersMethod = null;
        for (Method method : methods) {
            boolean providesParameters = method.isAnnotationPresent(Parameterized.Parameters.class);
            if (!providesParameters) continue;
            if (parametersMethod != null) {
                throw new Exception("Only one method should be annotated with @Labels");
            }
            parametersMethod = method;
        }
        if (parametersMethod == null) {
            throw new Exception("No @Parameters method found");
        }
        Collection parameterArrays = (Collection)parametersMethod.invoke(null, new Object[0]);
        return parameterArrays;
    }

    private Collection<Object[]> getParameterArrays4_4() throws Exception {
        Object[][] methodCalls = new Object[][]{{"getTestClass"}, {"getAnnotatedMethods", Class.class, Parameterized.Parameters.class}, {"get", Integer.TYPE, 0}, {"invokeExplosively", Object.class, null, Object[].class, new Object[0]}};
        Collection parameterArrays = (Collection)this.invokeMethodChain((Object)this, methodCalls);
        return parameterArrays;
    }

    private <T> T invokeMethodChain(Object object, Object[][] methodCalls) throws Exception {
        for (Object[] methodCall : methodCalls) {
            String methodName = (String)methodCall[0];
            int parameterCount = (methodCall.length - 1) / 2;
            Class[] classes = new Class[parameterCount];
            Object[] arguments = new Object[parameterCount];
            for (int i = 1; i < methodCall.length; i += 2) {
                Class cl = (Class)methodCall[i];
                Object argument = methodCall[i + 1];
                int index = (i - 1) / 2;
                classes[index] = cl;
                arguments[index] = argument;
            }
            Method method = this.getDeclaredMethod(object.getClass(), methodName, classes);
            object = method.invoke(object, arguments);
        }
        return (T)object;
    }

    private Method getDeclaredMethod(Class<?> cl, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        while (true) {
            try {
                Method method = cl.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (NoSuchMethodException e) {
                if ((cl = cl.getSuperclass()) != null) continue;
                throw new NoSuchMethodException("Method " + methodName + "() not found in hierarchy");
            }
            break;
        }
    }

    private void generateLabelledDescription() throws Exception {
        Description originalDescription = super.getDescription();
        this.labelledDescription = Description.createSuiteDescription((String)originalDescription.getDisplayName(), (Annotation[])new Annotation[0]);
        ArrayList childDescriptions = originalDescription.getChildren();
        int childCount = childDescriptions.size();
        if (childCount != this.labels.size()) {
            throw new Exception("Number of labels and number of parameters must match.");
        }
        for (int i = 0; i < childDescriptions.size(); ++i) {
            Description childDescription = (Description)childDescriptions.get(i);
            String label = this.labels.get(i);
            Description newDescription = Description.createSuiteDescription((String)label, (Annotation[])new Annotation[0]);
            ArrayList grandChildren = childDescription.getChildren();
            for (Description grandChild : grandChildren) {
                newDescription.addChild(grandChild);
            }
            this.labelledDescription.addChild(newDescription);
        }
    }

    public Description getDescription() {
        return this.labelledDescription;
    }
}

