/*
 * Decompiled with CFR 0.152.
 */
package hmi.tts.sapi5;

import hmi.tts.AbstractTTSGenerator;
import hmi.tts.Bookmark;
import hmi.tts.Phoneme;
import hmi.tts.TimingInfo;
import hmi.tts.Visime;
import hmi.tts.WordDescription;
import hmi.tts.util.BMLTextUtil;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SAPI5TTSGenerator
extends AbstractTTSGenerator {
    @GuardedBy(value="this")
    private boolean initialized = false;
    @GuardedBy(value="this")
    private ArrayList<BookMarker> currentBookmarks = new ArrayList();
    @GuardedBy(value="this")
    private ArrayList<Visime> currentVisimes = new ArrayList();
    @GuardedBy(value="this")
    private ArrayList<Phoneme> currentPhonemes = new ArrayList();
    @GuardedBy(value="this")
    private String currentWord = null;
    @GuardedBy(value="this")
    private int currentWordOffset = 0;
    @GuardedBy(value="this")
    private boolean wordBeforePhoneme = false;
    @GuardedBy(value="this")
    private String text;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final Logger logger = LoggerFactory.getLogger((String)SAPI5TTSGenerator.class.getName());

    private native int SAPISpeak(String var1);

    private native int SAPIDummySpeak(String var1);

    private native int SAPIInit();

    private native int SAPICleanup();

    private native int SAPISetSpeaker(String var1);

    private native int SAPISpeakToFile(String var1, String var2);

    private native String[] SAPIGetVoices();

    private <T> T callAndWait(Callable<T> c) {
        T t;
        Future<T> f = this.executorService.submit(c);
        try {
            t = f.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return null;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return t;
    }

    public SAPI5TTSGenerator() {
        int error = this.callAndWait(new Callable<Integer>(){

            @Override
            public Integer call() {
                return SAPI5TTSGenerator.this.SAPIInit();
            }
        });
        if (error == -1) {
            throw new RuntimeException("SAPI5TTSGenerator initialization failed");
        }
        this.initialized = error == 0;
    }

    public synchronized void cleanup() {
        if (this.initialized) {
            this.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return SAPI5TTSGenerator.this.SAPICleanup();
                }
            });
            this.initialized = false;
        } else {
            logger.warn("Attempting to cleanup SAPI5TTSGenerator that was never initialized");
        }
        this.shutdown();
    }

    private void shutdown() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(1000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    protected void finalize() {
        if (this.initialized) {
            this.cleanup();
        } else {
            this.shutdown();
        }
    }

    public synchronized TimingInfo getTiming(String text) {
        if (!this.initialized) {
            logger.error("Not initialized in getTiming");
            throw new RuntimeException("Not initialized");
        }
        this.speak(text, true, null);
        return this.getAndClearTimingInfo();
    }

    public synchronized void setVoice(final String speaker) {
        if (!this.initialized) {
            logger.error("Not initialized in setVoice");
            throw new RuntimeException("Not initialized");
        }
        this.callAndWait(new Callable<Integer>(){

            @Override
            public Integer call() {
                return SAPI5TTSGenerator.this.SAPISetSpeaker(speaker);
            }
        });
    }

    public synchronized TimingInfo speak(String str) {
        if (!this.initialized) {
            logger.error("Not initialized in speak");
            throw new RuntimeException("Not initialized");
        }
        this.speak(str, false, null);
        return this.getAndClearTimingInfo();
    }

    private void speak(String str, boolean timeOnly, final String filename) {
        int result;
        this.text = str;
        this.currentWordOffset = 0;
        this.currentWord = null;
        this.currentPhonemes.clear();
        this.currentVisimes.clear();
        this.wordDescriptions.clear();
        this.bookmarks.clear();
        this.visimes.clear();
        this.currentBookmarks.clear();
        if (timeOnly) {
            result = this.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return SAPI5TTSGenerator.this.SAPIDummySpeak(SAPI5TTSGenerator.this.text);
                }
            });
            if (result != 0) {
                throw new RuntimeException("Error in SAPIDummySpeak call");
            }
        } else if (filename == null) {
            result = this.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return SAPI5TTSGenerator.this.SAPISpeak(SAPI5TTSGenerator.this.text);
                }
            });
            if (result != 0) {
                throw new RuntimeException("Error in SAPISpeak call");
            }
        } else {
            result = this.callAndWait(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return SAPI5TTSGenerator.this.SAPISpeakToFile(SAPI5TTSGenerator.this.text, filename);
                }
            });
            if (result != 0) {
                throw new RuntimeException("Error in SAPISpeakToFile call");
            }
        }
        WordDescription wd = new WordDescription(this.currentWord, this.currentPhonemes, this.currentVisimes);
        this.wordDescriptions.add(wd);
        for (BookMarker bmr : this.currentBookmarks) {
            Bookmark b = bmr.wordStart ? new Bookmark(bmr.name, wd, this.currentWordOffset) : new Bookmark(bmr.name, null, this.currentWordOffset + wd.getDuration());
            this.bookmarks.add(b);
        }
        for (WordDescription wdesc : this.wordDescriptions) {
            for (Visime v : wdesc.getVisimes()) {
                this.visimes.add(v);
            }
        }
    }

    private void phonemeCallback(int phoneme, int duration, int nextPhoneme, int stress) {
        this.currentPhonemes.add(new Phoneme(phoneme, duration, stress == 1));
        if (this.callback != null) {
            this.callback.phonemeCallback(phoneme, duration, nextPhoneme, stress == 1);
        }
        if (this.permanentCallback != null) {
            this.permanentCallback.phonemeCallback(phoneme, duration, nextPhoneme, stress == 1);
        }
    }

    private void visimeCallback(int visime, int duration, int nextVisime, int stress) {
        this.currentVisimes.add(new Visime(visime, duration, stress == 1));
        if (this.callback != null) {
            this.callback.visimeCallback(visime, duration, nextVisime, stress == 1);
        }
        if (this.permanentCallback != null) {
            this.permanentCallback.visimeCallback(visime, duration, nextVisime, stress == 1);
        }
    }

    private void bookmarkCallback(String bookmark) {
        BookMarker m = new BookMarker(bookmark, false);
        this.currentBookmarks.add(m);
        if (this.callback != null) {
            this.callback.bookmarkCallback(bookmark);
        }
        if (this.permanentCallback != null) {
            this.permanentCallback.bookmarkCallback(bookmark);
        }
    }

    private void handleBookmarks(WordDescription wd) {
        ArrayList<BookMarker> removeMarks = new ArrayList<BookMarker>();
        for (BookMarker bm : this.currentBookmarks) {
            if (bm.wordStart) {
                removeMarks.add(bm);
                this.bookmarks.add(new Bookmark(bm.name, wd, this.currentWordOffset));
                continue;
            }
            bm.wordStart = true;
        }
        this.currentBookmarks.removeAll(removeMarks);
    }

    private void wordBoundryCallback(int offset, int length) {
        WordDescription wd = null;
        if (this.currentWord == null) {
            this.wordBeforePhoneme = this.currentPhonemes.isEmpty();
            this.handleBookmarks(wd);
        } else {
            if (this.wordBeforePhoneme) {
                wd = new WordDescription(this.currentWord, this.currentPhonemes, this.currentVisimes);
                this.wordDescriptions.add(wd);
                this.currentPhonemes = new ArrayList();
                this.currentVisimes = new ArrayList();
            } else {
                Phoneme p = this.currentPhonemes.get(this.currentPhonemes.size() - 1);
                this.currentPhonemes.remove(p);
                Visime v = this.currentVisimes.get(this.currentVisimes.size() - 1);
                this.currentVisimes.remove(v);
                wd = new WordDescription(this.currentWord, this.currentPhonemes, this.currentVisimes);
                this.wordDescriptions.add(wd);
                this.currentPhonemes = new ArrayList();
                this.currentPhonemes.add(p);
                this.currentVisimes = new ArrayList();
                this.currentVisimes.add(v);
            }
            this.handleBookmarks(wd);
            this.currentWordOffset += wd.getDuration();
        }
        this.currentWord = this.text.substring(offset, offset + length);
        if (this.callback != null) {
            this.callback.wordBoundryCallback(offset, length);
        }
        if (this.permanentCallback != null) {
            this.permanentCallback.wordBoundryCallback(offset, length);
        }
    }

    private void sentenceBoundryCallback(int offset, int length) {
        if (this.callback != null) {
            this.callback.sentenceBoundryCallback(offset, length);
        }
        if (this.permanentCallback != null) {
            this.permanentCallback.sentenceBoundryCallback(offset, length);
        }
    }

    private boolean stopCallback() {
        if (this.callback != null) {
            return this.callback.stopCallback();
        }
        if (this.permanentCallback != null) {
            return this.permanentCallback.stopCallback();
        }
        return false;
    }

    private TimingInfo getAndClearTimingInfo() {
        ArrayList des = new ArrayList();
        des.addAll(this.wordDescriptions);
        this.wordDescriptions.clear();
        ArrayList bms = new ArrayList();
        bms.addAll(this.bookmarks);
        this.bookmarks.clear();
        ArrayList vis = new ArrayList();
        vis.addAll(this.visimes);
        this.visimes.clear();
        return new TimingInfo(des, bms, vis);
    }

    public synchronized TimingInfo getBMLTiming(String s) {
        if (!this.initialized) {
            logger.error("Not initialized in getBMLTiming");
            throw new RuntimeException("Not initialized");
        }
        this.speak(BMLTextUtil.BMLToSAPI((String)s), true, null);
        return this.getAndClearTimingInfo();
    }

    public synchronized TimingInfo speakBML(String s) {
        if (!this.initialized) {
            logger.error("Not initialized in speakBML");
            throw new RuntimeException("Not initialized");
        }
        this.speak(BMLTextUtil.BMLToSAPI((String)s), false, null);
        return this.getAndClearTimingInfo();
    }

    public synchronized TimingInfo speakBMLToFile(String s, String filename) {
        if (!this.initialized) {
            logger.error("Not initialized in speakBMLToFile text:{} filename:{}", (Object)s, (Object)filename);
            throw new RuntimeException("Not initialized");
        }
        return this.speakToFile(BMLTextUtil.BMLToSAPI((String)s), filename);
    }

    public synchronized TimingInfo speakToFile(String text, String filename) {
        if (!this.initialized) {
            logger.error("Not initialized in speakToFile");
            throw new RuntimeException("Not initialized");
        }
        this.speak(text, false, filename);
        return this.getAndClearTimingInfo();
    }

    public synchronized String[] getVoices() {
        if (!this.initialized) {
            logger.error("Not initialized in getVoices");
            throw new RuntimeException("Not initialized");
        }
        return this.callAndWait(new Callable<String[]>(){

            @Override
            public String[] call() {
                return SAPI5TTSGenerator.this.SAPIGetVoices();
            }
        });
    }

    static {
        System.loadLibrary("sapi5interface");
    }

    private static final class BookMarker {
        private String name;
        private boolean wordStart;

        private BookMarker(String n, boolean ws) {
            this.name = n;
            this.wordStart = ws;
        }
    }
}

