// Generated by delombok at Wed Oct 31 02:22:46 CET 2018
/*******************************************************************************
 * The MIT License (MIT)
 * Copyright (c) 2015 University of Twente
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *******************************************************************************/
package hmi.tts.mary5.prosody;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import com.google.common.collect.ImmutableList;

/**
 * Prosody information of a chunk of speech
 * @author herwinvw
 */
public class MaryProsodyInfo {
    
    
    public class Syllable {
        final int stress;
        final List<Phoneme> phonemes;
        final int startTime;
        
        public int getEndTime() {
            if (phonemes.isEmpty()) {
                return 0;
            }
            return phonemes.get(phonemes.size() - 1).getEndTime();
        }
        
        @java.beans.ConstructorProperties({"stress", "phonemes", "startTime"})
        @java.lang.SuppressWarnings("all")
        public Syllable(final int stress, final List<Phoneme> phonemes, final int startTime) {
            this.stress = stress;
            this.phonemes = phonemes;
            this.startTime = startTime;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getStress() {
            return this.stress;
        }
        
        @java.lang.SuppressWarnings("all")
        public List<Phoneme> getPhonemes() {
            return this.phonemes;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getStartTime() {
            return this.startTime;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof MaryProsodyInfo.Syllable)) return false;
            final Syllable other = (Syllable)o;
            if (!other.canEqual((java.lang.Object)this)) return false;
            if (this.getStress() != other.getStress()) return false;
            final java.lang.Object this$phonemes = this.getPhonemes();
            final java.lang.Object other$phonemes = other.getPhonemes();
            if (this$phonemes == null ? other$phonemes != null : !this$phonemes.equals(other$phonemes)) return false;
            if (this.getStartTime() != other.getStartTime()) return false;
            return true;
        }
        
        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof MaryProsodyInfo.Syllable;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            result = result * PRIME + this.getStress();
            final java.lang.Object $phonemes = this.getPhonemes();
            result = result * PRIME + ($phonemes == null ? 0 : $phonemes.hashCode());
            result = result * PRIME + this.getStartTime();
            return result;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "MaryProsodyInfo.Syllable(stress=" + this.getStress() + ", phonemes=" + this.getPhonemes() + ", startTime=" + this.getStartTime() + ")";
        }
    }
    
    public class F0Frame {
        final int percentage;
        final double frequency;
        
        @java.beans.ConstructorProperties({"percentage", "frequency"})
        @java.lang.SuppressWarnings("all")
        public F0Frame(final int percentage, final double frequency) {
            this.percentage = percentage;
            this.frequency = frequency;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getPercentage() {
            return this.percentage;
        }
        
        @java.lang.SuppressWarnings("all")
        public double getFrequency() {
            return this.frequency;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof MaryProsodyInfo.F0Frame)) return false;
            final F0Frame other = (F0Frame)o;
            if (!other.canEqual((java.lang.Object)this)) return false;
            if (this.getPercentage() != other.getPercentage()) return false;
            if (java.lang.Double.compare(this.getFrequency(), other.getFrequency()) != 0) return false;
            return true;
        }
        
        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof MaryProsodyInfo.F0Frame;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            result = result * PRIME + this.getPercentage();
            final long $frequency = java.lang.Double.doubleToLongBits(this.getFrequency());
            result = result * PRIME + (int)($frequency >>> 32 ^ $frequency);
            return result;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "MaryProsodyInfo.F0Frame(percentage=" + this.getPercentage() + ", frequency=" + this.getFrequency() + ")";
        }
    }
    
    public class Phoneme {
        final String phoneme;
        final int startTime;
        final int endTime;
        final int duration;
        final List<F0Frame> f0Frames;
        
        @java.beans.ConstructorProperties({"phoneme", "startTime", "endTime", "duration", "f0Frames"})
        @java.lang.SuppressWarnings("all")
        public Phoneme(final String phoneme, final int startTime, final int endTime, final int duration, final List<F0Frame> f0Frames) {
            this.phoneme = phoneme;
            this.startTime = startTime;
            this.endTime = endTime;
            this.duration = duration;
            this.f0Frames = f0Frames;
        }
        
        @java.lang.SuppressWarnings("all")
        public String getPhoneme() {
            return this.phoneme;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getStartTime() {
            return this.startTime;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getEndTime() {
            return this.endTime;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getDuration() {
            return this.duration;
        }
        
        @java.lang.SuppressWarnings("all")
        public List<F0Frame> getF0Frames() {
            return this.f0Frames;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof MaryProsodyInfo.Phoneme)) return false;
            final Phoneme other = (Phoneme)o;
            if (!other.canEqual((java.lang.Object)this)) return false;
            final java.lang.Object this$phoneme = this.getPhoneme();
            final java.lang.Object other$phoneme = other.getPhoneme();
            if (this$phoneme == null ? other$phoneme != null : !this$phoneme.equals(other$phoneme)) return false;
            if (this.getStartTime() != other.getStartTime()) return false;
            if (this.getEndTime() != other.getEndTime()) return false;
            if (this.getDuration() != other.getDuration()) return false;
            final java.lang.Object this$f0Frames = this.getF0Frames();
            final java.lang.Object other$f0Frames = other.getF0Frames();
            if (this$f0Frames == null ? other$f0Frames != null : !this$f0Frames.equals(other$f0Frames)) return false;
            return true;
        }
        
        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof MaryProsodyInfo.Phoneme;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $phoneme = this.getPhoneme();
            result = result * PRIME + ($phoneme == null ? 0 : $phoneme.hashCode());
            result = result * PRIME + this.getStartTime();
            result = result * PRIME + this.getEndTime();
            result = result * PRIME + this.getDuration();
            final java.lang.Object $f0Frames = this.getF0Frames();
            result = result * PRIME + ($f0Frames == null ? 0 : $f0Frames.hashCode());
            return result;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "MaryProsodyInfo.Phoneme(phoneme=" + this.getPhoneme() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", duration=" + this.getDuration() + ", f0Frames=" + this.getF0Frames() + ")";
        }
    }
    
    public interface PhraseElement {
        
        int getEndTime();
        
        int getStartTime();
    }
    
    public class PhraseBoundary implements PhraseElement {
        final int breakindex;
        final String tone;
        final int startTime;
        final int endTime;
        
        @java.beans.ConstructorProperties({"breakindex", "tone", "startTime", "endTime"})
        @java.lang.SuppressWarnings("all")
        public PhraseBoundary(final int breakindex, final String tone, final int startTime, final int endTime) {
            this.breakindex = breakindex;
            this.tone = tone;
            this.startTime = startTime;
            this.endTime = endTime;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getBreakindex() {
            return this.breakindex;
        }
        
        @java.lang.SuppressWarnings("all")
        public String getTone() {
            return this.tone;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getStartTime() {
            return this.startTime;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getEndTime() {
            return this.endTime;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof MaryProsodyInfo.PhraseBoundary)) return false;
            final PhraseBoundary other = (PhraseBoundary)o;
            if (!other.canEqual((java.lang.Object)this)) return false;
            if (this.getBreakindex() != other.getBreakindex()) return false;
            final java.lang.Object this$tone = this.getTone();
            final java.lang.Object other$tone = other.getTone();
            if (this$tone == null ? other$tone != null : !this$tone.equals(other$tone)) return false;
            if (this.getStartTime() != other.getStartTime()) return false;
            if (this.getEndTime() != other.getEndTime()) return false;
            return true;
        }
        
        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof MaryProsodyInfo.PhraseBoundary;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            result = result * PRIME + this.getBreakindex();
            final java.lang.Object $tone = this.getTone();
            result = result * PRIME + ($tone == null ? 0 : $tone.hashCode());
            result = result * PRIME + this.getStartTime();
            result = result * PRIME + this.getEndTime();
            return result;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "MaryProsodyInfo.PhraseBoundary(breakindex=" + this.getBreakindex() + ", tone=" + this.getTone() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
        }
    }
    
    public class Word implements PhraseElement {
        final String word;
        final String accent;
        final String pos;
        final List<Syllable> syllables;
        final int startTime;
        final int endTime;
        
        @java.beans.ConstructorProperties({"word", "accent", "pos", "syllables", "startTime", "endTime"})
        @java.lang.SuppressWarnings("all")
        public Word(final String word, final String accent, final String pos, final List<Syllable> syllables, final int startTime, final int endTime) {
            this.word = word;
            this.accent = accent;
            this.pos = pos;
            this.syllables = syllables;
            this.startTime = startTime;
            this.endTime = endTime;
        }
        
        @java.lang.SuppressWarnings("all")
        public String getWord() {
            return this.word;
        }
        
        @java.lang.SuppressWarnings("all")
        public String getAccent() {
            return this.accent;
        }
        
        @java.lang.SuppressWarnings("all")
        public String getPos() {
            return this.pos;
        }
        
        @java.lang.SuppressWarnings("all")
        public List<Syllable> getSyllables() {
            return this.syllables;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getStartTime() {
            return this.startTime;
        }
        
        @java.lang.SuppressWarnings("all")
        public int getEndTime() {
            return this.endTime;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof MaryProsodyInfo.Word)) return false;
            final Word other = (Word)o;
            if (!other.canEqual((java.lang.Object)this)) return false;
            final java.lang.Object this$word = this.getWord();
            final java.lang.Object other$word = other.getWord();
            if (this$word == null ? other$word != null : !this$word.equals(other$word)) return false;
            final java.lang.Object this$accent = this.getAccent();
            final java.lang.Object other$accent = other.getAccent();
            if (this$accent == null ? other$accent != null : !this$accent.equals(other$accent)) return false;
            final java.lang.Object this$pos = this.getPos();
            final java.lang.Object other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) return false;
            final java.lang.Object this$syllables = this.getSyllables();
            final java.lang.Object other$syllables = other.getSyllables();
            if (this$syllables == null ? other$syllables != null : !this$syllables.equals(other$syllables)) return false;
            if (this.getStartTime() != other.getStartTime()) return false;
            if (this.getEndTime() != other.getEndTime()) return false;
            return true;
        }
        
        @java.lang.SuppressWarnings("all")
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof MaryProsodyInfo.Word;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $word = this.getWord();
            result = result * PRIME + ($word == null ? 0 : $word.hashCode());
            final java.lang.Object $accent = this.getAccent();
            result = result * PRIME + ($accent == null ? 0 : $accent.hashCode());
            final java.lang.Object $pos = this.getPos();
            result = result * PRIME + ($pos == null ? 0 : $pos.hashCode());
            final java.lang.Object $syllables = this.getSyllables();
            result = result * PRIME + ($syllables == null ? 0 : $syllables.hashCode());
            result = result * PRIME + this.getStartTime();
            result = result * PRIME + this.getEndTime();
            return result;
        }
        
        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        public java.lang.String toString() {
            return "MaryProsodyInfo.Word(word=" + this.getWord() + ", accent=" + this.getAccent() + ", pos=" + this.getPos() + ", syllables=" + this.getSyllables() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ")";
        }
    }
    private List<PhraseElement> phraseElements = new ArrayList<PhraseElement>();
    private int duration = 0;
    
    public ImmutableList<PhraseElement> getPhraseElements() {
        return ImmutableList.copyOf(phraseElements);
    }
    
    private String getAttribute(Node n, String attr, String defaultValue) {
        Node attrNode = n.getAttributes().getNamedItem(attr);
        if (attrNode == null) {
            return defaultValue;
        }
        return attrNode.getNodeValue();
    }
    
    private PhraseBoundary parseBoundary(Node n, int startTime) {
        int duration = (int)Math.round(Double.parseDouble(getAttribute(n, "duration", "0")));
        int breakindex = Integer.parseInt(getAttribute(n, "breakindex", "0"));
        String tone = getAttribute(n, "tone", "");
        return new PhraseBoundary(breakindex, tone, startTime, startTime + duration);
    }
    
    private Syllable parseSyllable(Node n, int startTime) {
        List<Phoneme> phonemes = new ArrayList<Phoneme>();
        Node child = n.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == Node.ELEMENT_NODE) {
                if (child.getNodeName().equals("ph")) {
                    Phoneme ph = parsePhoneme(child, startTime);
                    phonemes.add(ph);
                    startTime = ph.getEndTime();
                }
            }
            child = child.getNextSibling();
        }
        int stress = Integer.parseInt(getAttribute(n, "stress", "0"));
        return new Syllable(stress, phonemes, startTime);
    }
    
    private List<F0Frame> getF0Frames(String f0) {
        List<F0Frame> frames = new ArrayList<F0Frame>();
        if (f0.contains("(")) {
            f0 = f0.replace(')', ' ');
            String[] split = f0.split("\\(");
            for (String frame : split) {
                if (!frame.trim().isEmpty()) {
                    String[] fr = frame.split(",");
                    frames.add(new F0Frame(Integer.parseInt(fr[0].trim()), Integer.parseInt(fr[1].trim())));
                }
            }
        }
        return ImmutableList.copyOf(frames);
    }
    
    private Phoneme parsePhoneme(Node n, int startTime) {
        int duration = (int)Math.round(Double.parseDouble(getAttribute(n, "d", "0")));
        String phoneme = getAttribute(n, "p", "");
        String f0 = getAttribute(n, "f0", "");
        return new Phoneme(phoneme, startTime, startTime + duration, duration, getF0Frames(f0));
    }
    
    private Word parseWord(Node n, int startTime) {
        List<Syllable> syllables = new ArrayList<Syllable>();
        Node child = n.getFirstChild();
        int endTime = startTime;
        while (child != null) {
            if (child.getNodeType() == Node.ELEMENT_NODE) {
                if (child.getNodeName().equals("syllable")) {
                    Syllable syl = parseSyllable(child, endTime);
                    syllables.add(syl);
                    endTime = syl.getEndTime();
                }
            }
            child = child.getNextSibling();
        }
        return new Word(n.getTextContent().trim(), getAttribute(n, "accent", null), getAttribute(n, "pos", null), syllables, startTime, endTime);
    }
    
    private int parsePhrase(Node node, int startTime) {
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals("t")) {
                Word wd = parseWord(child, startTime);
                phraseElements.add(wd);
                startTime = wd.getEndTime();
            } else if (child.getNodeName().equals("boundary")) {
                PhraseBoundary pb = parseBoundary(child, startTime);
                phraseElements.add(pb);
                startTime = pb.getEndTime();
            } else {
                //check one or more levels deeper
                startTime = parsePhrase(child, startTime);
            }
            child = child.getNextSibling();
        }
        return startTime;
    }
    
    private int parseChunk(Node node, int startTime) {
        if (node.getNodeName().equals("phrase")) {
            startTime = parsePhrase(node, startTime);
        }
        Node firstChild = node.getFirstChild();
        if (firstChild != null) {
            startTime = parseChunk(firstChild, startTime);
        }
        Node sibling = node.getNextSibling();
        if (sibling != null) {
            startTime = parseChunk(sibling, startTime);
        }
        return startTime;
    }
    
    public void parse(Document doc) {
        if (doc.hasChildNodes()) {
            duration = parseChunk(doc.getFirstChild(), 0);
        }
    }
    
    public List<Word> getWords() {
        List<Word> words = new ArrayList<Word>();
        for (PhraseElement pe : phraseElements) {
            if (pe instanceof Word) {
                words.add((Word)pe);
            }
        }
        return ImmutableList.copyOf(words);
    }
    
    public List<Syllable> getSyllables() {
        List<Syllable> syllables = new ArrayList<Syllable>();
        for (Word wd : getWords()) {
            syllables.addAll(wd.getSyllables());
        }
        return ImmutableList.copyOf(syllables);
    }
    
    public List<Phoneme> getPhonemes() {
        List<Phoneme> phonemes = new ArrayList<Phoneme>();
        for (Syllable syl : getSyllables()) {
            phonemes.addAll(syl.getPhonemes());
        }
        return ImmutableList.copyOf(phonemes);
    }
    
    private int findNextIndexNonZero(double[] contour, int current, int end) {
        for (int i = current + 1; i < end; i++) {
            if (contour[i] != 0) {
                return i;
            }
        }
        return -1;
    }
    
    private void interpolateNonZeroValues(double[] contour, int start, int end) {
        for (int i = start; i < end; i++) {
            if (contour[i] == 0) {
                int index = findNextIndexNonZero(contour, i, end);
                // System.out.println("i: "+i+"index: "+index);
                if (index == -1) {
                    for (int j = i; j < end; j++) {
                        contour[j] = contour[j - 1];
                    }
                    break;
                } else {
                    for (int j = i; j < index; j++) {
                        // contour[j] = contour[i-1] * (index - j) + contour[index] * (j - (i-1)) / ( index - (i-1) );
                        if (i == start) {
                            contour[j] = contour[index];
                        } else {
                            contour[j] = contour[j - 1] + ((contour[index] - contour[i - 1]) / (index - i + 1));
                        }
                    }
                    i = index - 1;
                }
            }
        }
    }
    
    public double[] getF0Contour(int frameRate) {
        double[] contour = new double[1 + (frameRate * duration) / 1000];
        int segmentStart = 0;
        int segmentEnd = 0;
        boolean voicedSegment = false;
        int prevPhEnd = 0;
        for (Phoneme ph : getPhonemes()) {
            if (ph.getF0Frames().isEmpty()) {
                if (voicedSegment) {
                    voicedSegment = false;
                    interpolateNonZeroValues(contour, segmentStart, segmentEnd);
                }
            } else {
                if (ph.getStartTime() > prevPhEnd) {
                    interpolateNonZeroValues(contour, segmentStart, segmentEnd);
                    segmentStart = (ph.getStartTime() * (contour.length - 1)) / duration;
                }
                if (!voicedSegment) {
                    voicedSegment = true;
                    segmentStart = (ph.getStartTime() * (contour.length - 1)) / duration;
                }
                segmentEnd = (ph.getEndTime() * (contour.length - 1)) / duration;
                for (F0Frame fr : ph.getF0Frames()) {
                    int frameTime = ph.getStartTime() + ((ph.getEndTime() - ph.getStartTime()) * fr.getPercentage()) / 100;
                    int frameIndex = (frameTime * (contour.length - 1)) / duration;
                    contour[frameIndex] = fr.getFrequency();
                }
            }
            prevPhEnd = ph.getEndTime();
        }
        if (voicedSegment) {
            if (contour.length - segmentEnd <= 1) {
                interpolateNonZeroValues(contour, segmentStart, contour.length);
            } else {
                interpolateNonZeroValues(contour, segmentStart, segmentEnd);
            }
        }
        return contour;
    }
    
    @java.lang.SuppressWarnings("all")
    public int getDuration() {
        return this.duration;
    }
}