// Generated by delombok at Wed Oct 31 02:22:46 CET 2018
package hmi.tts.mary5;

import hmi.tts.Bookmark;
import hmi.tts.Prosody;
import hmi.tts.TTSTiming;
import hmi.tts.TimingInfo;
import hmi.tts.Visime;
import hmi.tts.WordDescription;
import java.util.Arrays;
import java.util.List;

/**
 * TTSTiming+f0 and RMS Energy trajectories
 * @author herwinvw
 */
public class MaryProsody implements TTSTiming {

    public MaryProsody(TimingInfo info) {
        ti = info;
    }
    private final TimingInfo ti;
    private double[] f0;
    private double[] rmsEnergy;

    public void setRMSEnergy(double[] rmsEnergy) {
        if (f0 != null && f0.length > 0) {
            this.rmsEnergy = new double[f0.length];
            Arrays.fill(this.rmsEnergy, rmsEnergy[rmsEnergy.length - 1]);
            System.arraycopy(rmsEnergy, 0, this.rmsEnergy, 0, Math.min(f0.length, rmsEnergy.length));
        } else {
            this.rmsEnergy = Arrays.copyOf(rmsEnergy, rmsEnergy.length);
        }
    }

    public void setF0(double[] f0) {
        this.f0 = Arrays.copyOf(f0, f0.length);
    }

    @Override
    public List<WordDescription> getWordDescriptions() {
        return ti.getWordDescriptions();
    }

    @Override
    public List<Bookmark> getBookmarks() {
        return ti.getBookmarks();
    }

    @Override
    public Bookmark getBookmark(String id) {
        return ti.getBookmark(id);
    }

    @Override
    public double getDuration() {
        return ti.getDuration();
    }

    @Override
    public List<Visime> getVisimes() {
        return ti.getVisimes();
    }

    @Override
    public Prosody getProsody() {
        return new Prosody(f0, rmsEnergy, getDuration() / getF0().length);
    }

    @java.lang.SuppressWarnings("all")
    public double[] getF0() {
        return this.f0;
    }

    @java.lang.SuppressWarnings("all")
    public double[] getRmsEnergy() {
        return this.rmsEnergy;
    }
}