/*
 * Decompiled with CFR 0.152.
 */
package hmi.tts.mary;

import hmi.tts.AbstractTTSGenerator;
import hmi.tts.Bookmark;
import hmi.tts.Phoneme;
import hmi.tts.TimingInfo;
import hmi.tts.Visime;
import hmi.tts.WordDescription;
import hmi.tts.util.BMLTextUtil;
import hmi.tts.util.NullPhonemeToVisemeMapping;
import hmi.tts.util.PhonemeToVisemeMapping;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.datatypes.MaryDataType;
import marytts.modules.synthesis.Voice;
import marytts.server.Mary;
import marytts.server.Request;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.data.audio.MaryAudioUtils;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@ThreadSafe
public class MaryTTSGenerator
extends AbstractTTSGenerator {
    @GuardedBy(value="this")
    private Voice voice;
    @GuardedBy(value="this")
    private int currentWordOffset;
    private PhonemeToVisemeMapping visemeMapping;

    public MaryTTSGenerator(String maryDir) throws Exception {
        this(maryDir, (PhonemeToVisemeMapping)new NullPhonemeToVisemeMapping());
    }

    public MaryTTSGenerator(String maryDir, PhonemeToVisemeMapping vm) throws Exception {
        System.setProperty("mary.base", maryDir);
        System.out.println("maryDir: " + maryDir);
        if (Mary.currentState() == 0) {
            Mary.simpleStartup();
        }
        this.voice = (Voice)Voice.getAvailableVoices().iterator().next();
        this.visemeMapping = vm;
    }

    public String getSSMLStartTag() {
        return "<speak xmlns=\"http://www.w3.org/2001/10/synthesis\" xml:lang=\"" + MaryUtils.locale2xmllang((Locale)this.voice.getLocale()) + "\">";
    }

    public String getMaryXMLStartTag() {
        return "<maryxml version=\"0.5\" xmlns=\"http://mary.dfki.de/2002/MaryXML\" xml:lang=\"" + MaryUtils.locale2xmllang((Locale)this.voice.getLocale()) + "\">";
    }

    private AudioFileFormat getAudioFileFormat() {
        AudioFileFormat.Type audioType = MaryAudioUtils.getAudioFileFormatType((String)"WAVE");
        return new AudioFileFormat(audioType, this.voice.dbAudioFormat(), -1);
    }

    private void speakText(String text, MaryDataType inputType) {
        AudioInputStream ais;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Request request = new Request(inputType, MaryDataType.AUDIO, this.voice.getLocale(), this.voice, null, null, 1, this.getAudioFileFormat(), false, null);
        try {
            request.readInputData((Reader)new StringReader(text));
            request.process();
            request.writeOutputData((OutputStream)baos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            ais = AudioSystem.getAudioInputStream(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        AudioPlayer ap = new AudioPlayer(ais, null);
        ap.start();
    }

    public synchronized void speakToFile(String text, String filename, MaryDataType inputType) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(filename));
        Request request = new Request(inputType, MaryDataType.AUDIO, this.voice.getLocale(), this.voice, null, null, 1, this.getAudioFileFormat(), false, null);
        try {
            request.readInputData((Reader)new StringReader(text));
            request.process();
            request.writeOutputData((OutputStream)fos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        fos.close();
    }

    private TimingInfo getAndClearTimingInfo() {
        ArrayList des = new ArrayList();
        des.addAll(this.wordDescriptions);
        this.wordDescriptions.clear();
        ArrayList bms = new ArrayList();
        bms.addAll(this.bookmarks);
        this.bookmarks.clear();
        ArrayList vis = new ArrayList();
        vis.addAll(this.visimes);
        this.visimes.clear();
        return new TimingInfo(des, bms, vis);
    }

    public synchronized TimingInfo speak(String text) {
        return this.speak(text, MaryDataType.TEXT);
    }

    public synchronized TimingInfo speak(String text, MaryDataType inputType) {
        TimingInfo ti = this.getTiming(text, inputType);
        this.speakText(text, inputType);
        return ti;
    }

    public synchronized TimingInfo speakBML(String text) {
        TimingInfo ti = this.getBMLTiming(text);
        this.speakText(BMLTextUtil.stripSyncs((String)text), MaryDataType.TEXT);
        return ti;
    }

    public synchronized TimingInfo speakToFile(String text, String filename) throws IOException {
        TimingInfo ti = this.getTiming(text);
        this.speakToFile(text, filename, MaryDataType.TEXT);
        return ti;
    }

    public synchronized TimingInfo speakBMLToFile(String text, String filename) throws IOException {
        TimingInfo ti = this.getBMLTiming(text);
        this.speakToFile(BMLTextUtil.stripSyncs((String)text), filename, MaryDataType.TEXT);
        return ti;
    }

    private Phoneme parsePhoneme(Node n, boolean stress) {
        NamedNodeMap attr = n.getAttributes();
        Node duration = attr.getNamedItem("d");
        String phoneme = attr.getNamedItem("p").getNodeValue();
        int phonemeNr = 0;
        for (int i = 0; i < phoneme.length(); ++i) {
            int c;
            int ph = c = phoneme.charAt(i);
            for (int j = 0; j < i; ++j) {
                ph <<= 8;
            }
            phonemeNr += ph;
        }
        return new Phoneme(phonemeNr, Integer.parseInt(duration.getNodeValue()), stress);
    }

    private void parseSyllable(Node n, List<Phoneme> pList, List<Visime> vList) {
        Node child = n.getFirstChild();
        boolean stress = false;
        NamedNodeMap attr = n.getAttributes();
        Node stressNode = attr.getNamedItem("stress");
        if (stressNode != null) {
            boolean bl = stress = Integer.parseInt(stressNode.getNodeValue()) != 0;
        }
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equals("ph")) {
                Phoneme ph = this.parsePhoneme(child, stress);
                pList.add(ph);
                vList.add(new Visime(this.visemeMapping.getVisemeForPhoneme(ph.getNumber()), ph.getDuration(), stress));
            }
            child = child.getNextSibling();
        }
    }

    private void parseWord(Node n) {
        String word = n.getTextContent();
        ArrayList<Phoneme> pList = new ArrayList<Phoneme>();
        ArrayList<Visime> vList = new ArrayList<Visime>();
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals("syllable")) continue;
            this.parseSyllable(child, pList, vList);
        }
        WordDescription wd = new WordDescription(word, pList, vList);
        this.addWordDescription(wd);
    }

    private void addWordDescription(WordDescription wd) {
        this.currentWordOffset += wd.getDuration();
        this.wordDescriptions.add(wd);
        for (Visime v : wd.getVisimes()) {
            this.visimes.add(v);
        }
        ArrayList<Bookmark> bmAdd = new ArrayList<Bookmark>();
        ArrayList<Bookmark> bmRemove = new ArrayList<Bookmark>();
        for (Bookmark bm : this.bookmarks) {
            if (bm.getWord() != null) continue;
            bmAdd.add(new Bookmark(bm.getName(), wd, bm.getOffset()));
            bmRemove.add(bm);
        }
        this.bookmarks.removeAll(bmRemove);
        this.bookmarks.addAll(bmAdd);
    }

    private void parseMark(Node n) {
        NamedNodeMap attr = n.getAttributes();
        Node name = attr.getNamedItem("name");
        Bookmark bm = new Bookmark(name.getNodeValue(), null, this.currentWordOffset);
        this.bookmarks.add(bm);
    }

    private void parseBoundary(Node n) {
        NamedNodeMap attr = n.getAttributes();
        Node durationNode = attr.getNamedItem("duration");
        if (durationNode == null) {
            return;
        }
        int duration = Integer.parseInt(durationNode.getNodeValue());
        Phoneme dummyPh = new Phoneme(0, duration, false);
        ArrayList<Phoneme> phList = new ArrayList<Phoneme>();
        phList.add(dummyPh);
        Visime dummyVis = new Visime(0, duration, false);
        ArrayList<Visime> vList = new ArrayList<Visime>();
        vList.add(dummyVis);
        this.addWordDescription(new WordDescription("", phList, vList));
    }

    private void parseWordDescriptionsAndBookmarks(Node node) {
        Node sibling;
        Node firstChild;
        if (node.getNodeType() == 1) {
            if (node.getNodeName().equals("t")) {
                this.parseWord(node);
            } else if (node.getNodeName().equals("mark")) {
                this.parseMark(node);
            } else if (node.getNodeName().equals("boundary")) {
                this.parseBoundary(node);
            }
        }
        if ((firstChild = node.getFirstChild()) != null) {
            this.parseWordDescriptionsAndBookmarks(firstChild);
        }
        if ((sibling = node.getNextSibling()) != null) {
            this.parseWordDescriptionsAndBookmarks(sibling);
        }
    }

    private void parseWordDescriptionsAndBookmarks(Document doc) {
        if (doc.hasChildNodes()) {
            this.currentWordOffset = 0;
            this.bookmarks.clear();
            this.wordDescriptions.clear();
            this.visimes.clear();
            this.parseWordDescriptionsAndBookmarks(doc.getFirstChild());
        }
    }

    public synchronized TimingInfo getTiming(String text) {
        return this.getTiming(text, MaryDataType.TEXT);
    }

    public synchronized TimingInfo getTiming(String text, MaryDataType inputDataType) {
        Request request = new Request(inputDataType, MaryDataType.REALISED_ACOUSTPARAMS, this.voice.getLocale(), this.voice, null, null, 1, this.getAudioFileFormat(), false, null);
        try {
            request.readInputData((Reader)new StringReader(text));
            request.process();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        this.parseWordDescriptionsAndBookmarks(request.getOutputData().getDocument());
        return this.getAndClearTimingInfo();
    }

    public synchronized TimingInfo getBMLTiming(String text) {
        return this.getTiming(this.getSSMLStartTag() + BMLTextUtil.BMLToSSML((String)text) + "</speak>", MaryDataType.SSML);
    }

    public synchronized void setVoice(String speaker) {
        for (Voice v : Voice.getAvailableVoices()) {
            if (!v.getName().equals(speaker)) continue;
            this.voice = v;
            return;
        }
    }

    public synchronized String[] getVoices() {
        String[] str = new String[Voice.getAvailableVoices().size()];
        int i = 0;
        for (Voice v : Voice.getAvailableVoices()) {
            str[i] = v.getName();
            ++i;
        }
        return str;
    }
}

