/*
 * Decompiled with CFR 0.152.
 */
package hmi.tts.util;

import hmi.tts.util.PhonemeToVisemeMapping;
import hmi.tts.util.PhonemeUtil;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class XMLPhonemeToVisemeMapping
extends XMLStructureAdapter
implements PhonemeToVisemeMapping {
    private HashMap<Integer, Integer> mappings = new HashMap();
    private static final String XMLTAG = "PhonemeToVisemeMapping";

    @Override
    public int getVisemeForPhoneme(int phon) {
        if (this.mappings.get(phon) != null) {
            return this.mappings.get(phon);
        }
        return -1;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (!tag.equals("phoneme")) {
                throw new XMLScanException("Unknown element in PhonemeToVisemeMapping: " + tag);
            }
            HashMap attrMap = tokenizer.getAttributes();
            String phoneme = this.getRequiredAttribute("phoneme", attrMap, tokenizer);
            int viseme = this.getRequiredIntAttribute("viseme", attrMap, tokenizer);
            this.mappings.put(PhonemeUtil.phonemeStringToInt(phoneme), viseme);
            tokenizer.takeSTag("phoneme");
            tokenizer.takeETag("phoneme");
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

