/*
 * Decompiled with CFR 0.152.
 */
package hmi.tts.util;

import hmi.tts.Bookmark;
import hmi.tts.Phoneme;
import hmi.tts.TTSCallback;
import hmi.tts.WordDescription;
import java.util.Collection;
import java.util.Iterator;

public class FakeCallback {
    private final Collection<WordDescription> wordDescriptions;
    private final Collection<Bookmark> bookmarks;
    private final TTSCallback callback;
    private final String speechContent;

    public FakeCallback(TTSCallback cb, Collection<Bookmark> bm, Collection<WordDescription> wds, String content) {
        this.callback = cb;
        this.bookmarks = bm;
        this.wordDescriptions = wds;
        this.speechContent = content;
    }

    private void doAllCallbacks(WordDescription wd, WordDescription wdNext) {
        this.callback.wordBoundryCallback(this.speechContent.indexOf(wd.getWord()), wd.getWord().length());
        for (Bookmark bm : this.bookmarks) {
            if (bm.getWord() != wd) continue;
            this.callback.bookmarkCallback(bm.getName());
        }
        Phoneme ph = null;
        if (wd.getPhonemes().size() > 0) {
            Iterator<Phoneme> iter = wd.getPhonemes().iterator();
            ph = iter.next();
            while (iter.hasNext()) {
                Phoneme phNext = iter.next();
                this.callback.phonemeCallback(ph.getNumber(), ph.getDuration(), phNext.getNumber(), ph.isStressed());
                ph = phNext;
            }
        }
        if (ph != null) {
            if (wdNext != null && wdNext.getPhonemes().size() > 0) {
                Phoneme phNext = wdNext.getPhonemes().iterator().next();
                this.callback.phonemeCallback(ph.getNumber(), ph.getDuration(), phNext.getNumber(), ph.isStressed());
            } else {
                this.callback.phonemeCallback(ph.getNumber(), ph.getDuration(), 0, ph.isStressed());
            }
        }
    }

    private void doAllCallbacks(WordDescription wd, WordDescription wdNext, int offset, double start, double end) {
        if (start <= (double)offset && (double)offset < end) {
            this.callback.wordBoundryCallback(this.speechContent.indexOf(wd.getWord()), wd.getWord().length());
            for (Bookmark bm : this.bookmarks) {
                if (bm.getWord() != wd) continue;
                this.callback.bookmarkCallback(bm.getName());
            }
        }
        Phoneme ph = null;
        if (wd.getPhonemes().size() > 0) {
            Iterator<Phoneme> iter = wd.getPhonemes().iterator();
            ph = iter.next();
            while (iter.hasNext()) {
                Phoneme phNext = iter.next();
                if (!(start <= (double)offset) || !((double)offset < end)) {
                    return;
                }
                this.callback.phonemeCallback(ph.getNumber(), ph.getDuration(), phNext.getNumber(), ph.isStressed());
                offset += ph.getDuration();
                ph = phNext;
            }
        }
        if (start <= (double)offset && (double)offset < end && ph != null) {
            if (wdNext != null && wdNext.getPhonemes().size() > 0) {
                Phoneme phNext = wdNext.getPhonemes().iterator().next();
                this.callback.phonemeCallback(ph.getNumber(), ph.getDuration(), phNext.getNumber(), ph.isStressed());
            } else {
                this.callback.phonemeCallback(ph.getNumber(), ph.getDuration(), 0, ph.isStressed());
            }
        }
    }

    public void callbackAll() {
        Iterator<WordDescription> iterWd = this.wordDescriptions.iterator();
        WordDescription wd = null;
        if (this.wordDescriptions.size() > 0) {
            wd = iterWd.next();
            while (iterWd.hasNext()) {
                WordDescription wdNext = iterWd.next();
                this.doAllCallbacks(wd, wdNext);
                wd = wdNext;
            }
        }
        if (wd != null) {
            this.doAllCallbacks(wd, null);
        }
        for (Bookmark bm : this.bookmarks) {
            if (bm.getWord() != null) continue;
            this.callback.bookmarkCallback(bm.getName());
        }
    }

    public void callBack(double start, double end) {
        Iterator<WordDescription> iterWd = this.wordDescriptions.iterator();
        WordDescription wd = null;
        int offset = 0;
        if (this.wordDescriptions.size() > 0) {
            wd = iterWd.next();
            if (start <= (double)(offset + wd.getDuration()) && (double)offset < end) {
                while (iterWd.hasNext()) {
                    WordDescription wdNext = iterWd.next();
                    this.doAllCallbacks(wd, wdNext, offset, start, end);
                    offset += wd.getDuration();
                    wd = wdNext;
                }
            } else {
                return;
            }
        }
        if (wd != null && start <= (double)(offset + wd.getDuration()) && (double)offset < end) {
            this.doAllCallbacks(wd, null, offset, start, end);
        }
        for (Bookmark bm : this.bookmarks) {
            if (bm.getWord() != null || !(start <= (double)(offset + wd.getDuration())) || !((double)(offset + wd.getDuration()) < end)) continue;
            this.callback.bookmarkCallback(bm.getName());
        }
    }
}

