/*
 * Decompiled with CFR 0.152.
 */
package hmi.tts;

import hmi.tts.Phoneme;
import hmi.tts.PhonologicalPeak;
import hmi.tts.Visime;
import java.util.Collection;
import net.jcip.annotations.Immutable;

@Immutable
public final class WordDescription {
    private final Collection<Phoneme> phonemes;
    private final Collection<Visime> visimes;
    private final String word;

    public Collection<Phoneme> getPhonemes() {
        return this.phonemes;
    }

    public Collection<Visime> getVisimes() {
        return this.visimes;
    }

    public String getWord() {
        return this.word;
    }

    public WordDescription(String word, Collection<Phoneme> phonemes, Collection<Visime> visimes) {
        this.word = word;
        this.phonemes = phonemes;
        this.visimes = visimes;
    }

    public int getDuration() {
        int duration = 0;
        for (Phoneme p : this.phonemes) {
            duration += p.getDuration();
        }
        return duration;
    }

    public String toString() {
        return "Word: " + this.word + "\n" + this.phonemes.toString() + "\n" + this.visimes.toString() + "\n";
    }

    public PhonologicalPeak getPhonologicalPeak() {
        int offset = 0;
        for (Phoneme p : this.phonemes) {
            if (p.isStressed()) {
                return new PhonologicalPeak(p, offset);
            }
            offset += p.getDuration();
        }
        return null;
    }
}

