/*
 * Decompiled with CFR 0.152.
 */
package hmi.tts.util;

import hmi.tts.Bookmark;
import hmi.tts.WordDescription;
import hmi.tts.util.SyncAndOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class BMLTextUtil {
    private BMLTextUtil() {
    }

    public static String stripSyncs(String text) {
        String textNoSync = text.replaceAll("<sync\\s+id\\s*=\\s*\"[a-zA-Z][a-zA-Z0-9\\-_]*\"\\s*/?>", " ");
        textNoSync = textNoSync.replaceAll("</sync>", " ");
        return textNoSync;
    }

    public static List<SyncAndOffset> getSyncAndOffsetList(String text, int numberOfWords) {
        ArrayList<SyncAndOffset> syncAndOffsetList = new ArrayList<SyncAndOffset>();
        int index = text.indexOf("<sync");
        int wordOffset = 0;
        while (index != -1) {
            String str = text.substring(0, index);
            String strAfter = text.substring(index, text.length());
            String syncId = strAfter.replaceAll("<sync\\s+id\\s*=\\s*\"", "");
            syncId = syncId.replaceAll("\".*", "");
            String strNoSync2 = str.replaceAll("<sync\\s+id\\s*=\\s*\"[a-zA-Z][a-zA-Z0-9\\-_]*\"\\s*/?>", "");
            String[] strSplit = (strNoSync2 = strNoSync2.replaceAll("</sync>", "")).split(" ");
            if (strSplit.length == numberOfWords) {
                syncAndOffsetList.add(new SyncAndOffset(syncId, wordOffset + strSplit.length - 1));
            } else {
                syncAndOffsetList.add(new SyncAndOffset(syncId, wordOffset + strSplit.length));
            }
            wordOffset += strSplit.length;
            index = text.indexOf("<sync", index + 1);
        }
        return syncAndOffsetList;
    }

    public static void getBookmarks(String text, Collection<WordDescription> desc, Collection<Bookmark> bookmarks) {
        int index = text.indexOf("<sync");
        while (index != -1) {
            String str = text.substring(0, index);
            String strAfter = text.substring(index, text.length());
            String syncId = strAfter.replaceAll("<sync\\s+id\\s*=\\s*\"", "");
            syncId = syncId.replaceAll("\".*", "");
            String strNoSync2 = str.replaceAll("<sync\\s+id\\s*=\\s*\"[a-zA-Z][a-zA-Z0-9\\-_]*\"\\s*/?>", "");
            strNoSync2 = strNoSync2.replaceAll("</sync>", "");
            strNoSync2 = strNoSync2.replaceAll("\\s", "");
            StringBuffer wdStr = new StringBuffer("");
            int timeOffset = 0;
            for (WordDescription d : desc) {
                if (wdStr.toString().equals(strNoSync2)) {
                    bookmarks.add(new Bookmark(syncId, d, timeOffset));
                    break;
                }
                wdStr.append(d.getWord().trim());
                timeOffset += d.getDuration();
            }
            index = text.indexOf("<sync", index + 1);
        }
    }

    public static String BMLToSSML(String text) {
        return text.replaceAll("<sync\\s+id", "<mark name");
    }

    public static String BMLToSAPI(String text) {
        return text.replaceAll("<sync\\s+id", "<bookmark mark");
    }
}

