/*
 * Decompiled with CFR 0.152.
 */
package hmi.tts;

import hmi.tts.Bookmark;
import hmi.tts.Visime;
import hmi.tts.WordDescription;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class TimingInfo {
    private final List<WordDescription> wordDescriptions;
    private final List<Bookmark> bookmarks;
    private final List<Visime> visimes;

    public List<WordDescription> getWordDescriptions() {
        return Collections.unmodifiableList(this.wordDescriptions);
    }

    public List<Bookmark> getBookmarks() {
        return Collections.unmodifiableList(this.bookmarks);
    }

    public List<Visime> getVisimes() {
        return Collections.unmodifiableList(this.visimes);
    }

    public Bookmark getBookmark(String id) {
        for (Bookmark b : this.bookmarks) {
            if (!b.getName().equals(id)) continue;
            return b;
        }
        return null;
    }

    public TimingInfo(List<WordDescription> wd, List<Bookmark> bms, List<Visime> vis) {
        this.wordDescriptions = wd;
        this.bookmarks = bms;
        this.visimes = vis;
    }

    public double getDuration() {
        double duration = 0.0;
        for (WordDescription wd : this.wordDescriptions) {
            duration += (double)wd.getDuration() / 1000.0;
        }
        return duration;
    }

    public String toString() {
        return this.wordDescriptions.toString() + " " + this.bookmarks.toString();
    }
}

