/*
 * Decompiled with CFR 0.152.
 */
package hmi.speechengine.loader;

import asap.environment.AsapVirtualHuman;
import asap.environment.EmbodimentLoader;
import asap.environment.EngineLoader;
import asap.environment.Loader;
import asap.environment.impl.JComponentEmbodiment;
import asap.utils.Environment;
import hmi.animationengine.AnimationPlayer;
import hmi.animationengine.gesturebinding.SpeechBinding;
import hmi.animationengine.loader.MixedAnimationEngineLoader;
import hmi.animationengine.motionunit.TimedMotionUnit;
import hmi.audioenvironment.AudioEnvironment;
import hmi.bml.core.SpeechBehaviour;
import hmi.elckerlyc.DefaultEngine;
import hmi.elckerlyc.DefaultPlayer;
import hmi.elckerlyc.Engine;
import hmi.elckerlyc.Planner;
import hmi.elckerlyc.Player;
import hmi.elckerlyc.planunit.MultiThreadedPlanPlayer;
import hmi.elckerlyc.planunit.PlanManager;
import hmi.elckerlyc.planunit.PlanPlayer;
import hmi.faceanimation.FaceController;
import hmi.faceengine.faceunit.TimedFaceUnit;
import hmi.faceengine.loader.FaceEngineLoader;
import hmi.faceengine.viseme.MorphVisemeBinding;
import hmi.faceengine.viseme.VisemeBinding;
import hmi.faceengine.viseme.VisemeToMorphMapping;
import hmi.speechengine.DirectTTSUnitFactory;
import hmi.speechengine.TTSPlanner;
import hmi.speechengine.TimedTTSUnit;
import hmi.speechengine.TimedTTSUnitFactory;
import hmi.speechengine.WavTTSUnitFactory;
import hmi.speechengine.ttsbinding.MaryTTSBinding;
import hmi.speechengine.ttsbinding.SAPITTSBinding;
import hmi.speechengine.ttsbinding.TTSBinding;
import hmi.tts.util.PhonemeToVisemeMapping;
import hmi.tts.util.XMLPhonemeToVisemeMapping;
import hmi.util.Resources;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechEngineLoader
implements EngineLoader {
    private static Logger logger = LoggerFactory.getLogger((String)SpeechEngineLoader.class.getName());
    private XMLStructureAdapter adapter = new XMLStructureAdapter();
    private JComponentEmbodiment jce = null;
    private MixedAnimationEngineLoader ael = null;
    private AudioEnvironment aue = null;
    private FaceEngineLoader fel = null;
    private JComboBox voiceList = null;
    private JPanel speechUIPanel = null;
    private boolean initUI = false;
    private Engine engine = null;
    private PlanManager<TimedTTSUnit> speechPlanManager = null;
    private Player speechPlayer = null;
    private PlanPlayer speechPlanPlayer = null;
    private Planner<TimedTTSUnit> speechPlanner = null;
    private MorphVisemeBinding visemebinding = null;
    private Voicetype voicetype = null;
    private String voicename = "";
    private Factory factory = null;
    String marydir = "MARYTTS";
    String id = "";
    SpeechBinding speechbinding = null;
    AsapVirtualHuman theVirtualHuman = null;

    public void readXML(XMLTokenizer tokenizer, String newId, AsapVirtualHuman avh, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        this.theVirtualHuman = avh;
        for (Loader loader : requiredLoaders) {
            if (loader instanceof MixedAnimationEngineLoader) {
                this.ael = (MixedAnimationEngineLoader)loader;
            }
            if (loader instanceof FaceEngineLoader) {
                this.fel = (FaceEngineLoader)loader;
            }
            if (!(loader instanceof EmbodimentLoader) || !(((EmbodimentLoader)loader).getEmbodiment() instanceof JComponentEmbodiment)) continue;
            this.jce = (JComponentEmbodiment)((EmbodimentLoader)loader).getEmbodiment();
        }
        for (Loader loader : environments) {
            if (!(loader instanceof AudioEnvironment)) continue;
            this.aue = (AudioEnvironment)loader;
        }
        if (this.aue == null) {
            throw tokenizer.getXMLScanException("Speechengineloaxder requires audioenvironment.");
        }
        logger.debug("Reading SpeechEngine");
        while (!tokenizer.atETag("Loader")) {
            logger.debug("Reading Section");
            this.readSection(tokenizer);
        }
        this.constructEngine(tokenizer);
    }

    public void unload() {
    }

    protected void readSection(XMLTokenizer tokenizer) throws IOException {
        HashMap attrMap = null;
        if (tokenizer.atSTag("SpeechBinding")) {
            logger.debug("Reading Speechbinding");
            attrMap = tokenizer.getAttributes();
            this.speechbinding = new SpeechBinding(new Resources(this.adapter.getOptionalAttribute("basedir", attrMap, "")));
            try {
                this.speechbinding.readXML((Reader)new Resources(this.adapter.getOptionalAttribute("resources", attrMap, "")).getReader(this.adapter.getRequiredAttribute("filename", attrMap, tokenizer)));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Cannnot load SpeechBinding: " + e);
            }
            tokenizer.takeEmptyElement("SpeechBinding");
        } else if (tokenizer.atSTag("MorphVisemeBinding")) {
            logger.debug("Reading MorphVisemeBinding");
            attrMap = tokenizer.getAttributes();
            VisemeToMorphMapping mapping = new VisemeToMorphMapping();
            mapping.readXML((Reader)new Resources(this.adapter.getOptionalAttribute("resources", attrMap, "")).getReader(this.adapter.getRequiredAttribute("filename", attrMap, tokenizer)));
            this.visemebinding = new MorphVisemeBinding(mapping);
            tokenizer.takeEmptyElement("MorphVisemeBinding");
        } else if (tokenizer.atSTag("Voice")) {
            logger.debug("Reading Voice");
            attrMap = tokenizer.getAttributes();
            this.voicename = "";
            String type = this.adapter.getRequiredAttribute("voicetype", attrMap, tokenizer);
            this.voicetype = Voicetype.NOVOICE;
            this.factory = Factory.DIRECT_TTS;
            if (type.equals("SAPI5")) {
                this.voicetype = Voicetype.SAPI5;
                this.voicename = this.adapter.getOptionalAttribute("voicename", attrMap, "");
                String factoryString = this.adapter.getOptionalAttribute("factory", attrMap, "WAV_TTS");
                if (factoryString.equals("DIRECT_TTS")) {
                    this.factory = Factory.DIRECT_TTS;
                } else if (factoryString.equals("WAV_TTS")) {
                    this.factory = Factory.WAV_TTS;
                }
            } else if (type.equals("MARY")) {
                this.voicetype = Voicetype.MARY;
                this.voicename = this.adapter.getOptionalAttribute("voicename", attrMap, "");
                String factoryString = this.adapter.getOptionalAttribute("factory", attrMap, "WAV_TTS");
                if (factoryString.equals("DIRECT_TTS")) {
                    this.factory = Factory.DIRECT_TTS;
                } else if (factoryString.equals("WAV_TTS")) {
                    this.factory = Factory.WAV_TTS;
                }
                String localMaryDir = this.adapter.getOptionalAttribute("localmarydir", attrMap);
                this.marydir = this.adapter.getOptionalAttribute("marydir", attrMap);
                if (this.marydir == null) {
                    if (localMaryDir == null) {
                        throw tokenizer.getXMLScanException("neither marydir nor localmarydir specified.");
                    }
                    String spr = System.getProperty("shared.project.root");
                    if (spr == null) {
                        throw tokenizer.getXMLScanException("the use of the localmarydir setting requires a shared.project.root system variable (often: -Dshared.project.root=\"../..\" but this may depend on your system setup).");
                    }
                    this.marydir = System.getProperty("shared.project.root") + "/" + localMaryDir;
                }
            }
            tokenizer.takeEmptyElement("Voice");
        } else if (tokenizer.atSTag("SpeechUI")) {
            if (this.jce == null) {
                throw tokenizer.getXMLScanException("Cannot add SpeechUI when no JComponentEmbodiment is set");
            }
            this.initUI = true;
            tokenizer.takeSTag("SpeechUI");
            tokenizer.takeETag("SpeechUI");
        } else {
            throw tokenizer.getXMLScanException("Unknown tag in Loader content");
        }
    }

    private void constructEngine(XMLTokenizer tokenizer) {
        this.speechPlanManager = new PlanManager();
        this.speechPlanPlayer = new MultiThreadedPlanPlayer(this.theVirtualHuman.getElckerlycRealizer().getFeedbackManager(), this.speechPlanManager);
        this.speechPlayer = new DefaultPlayer(this.speechPlanPlayer);
        this.speechPlanner = null;
        FaceController faceController = null;
        AnimationPlayer animationPlayer = null;
        PlanManager facePlanManager = null;
        PlanManager animationPlanManager = null;
        if (this.ael != null) {
            animationPlayer = this.ael.getAnimationPlayer();
            animationPlanManager = this.ael.getPlanManager();
        }
        if (this.fel != null) {
            faceController = this.fel.getFaceController();
            facePlanManager = this.fel.getPlanManager();
        }
        switch (this.voicetype) {
            case MARY: {
                TTSBinding ttsBin;
                try {
                    XMLPhonemeToVisemeMapping vm = new XMLPhonemeToVisemeMapping();
                    vm.readXML((Reader)new Resources("Humanoids/shared/phoneme2viseme/").getReader("sampade2ikp.xml"));
                    ttsBin = new MaryTTSBinding(this.marydir, (PhonemeToVisemeMapping)vm);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (this.voicename != null) {
                    ttsBin.setVoice(this.voicename);
                }
                this.speechPlanner = this.getTTSPlanner(faceController, animationPlayer, (PlanManager<TimedFaceUnit>)facePlanManager, (PlanManager<TimedMotionUnit>)animationPlanManager, ttsBin);
                break;
            }
            case SAPI5: {
                TTSBinding ttsBin = new SAPITTSBinding();
                if (this.voicename != null) {
                    ttsBin.setVoice(this.voicename);
                }
                ttsBin.speak(SpeechBehaviour.class, "");
                this.speechPlanner = this.getTTSPlanner(faceController, animationPlayer, (PlanManager<TimedFaceUnit>)facePlanManager, (PlanManager<TimedMotionUnit>)animationPlanManager, ttsBin);
                break;
            }
            default: {
                logger.warn("cannot initialize this voice, wrong type.");
                return;
            }
        }
        this.engine = new DefaultEngine(this.speechPlanner, this.speechPlayer, this.speechPlanManager);
        this.engine.setId(this.id);
        this.theVirtualHuman.getElckerlycRealizer().addEngine(this.engine);
        if (this.initUI && this.voicetype != Voicetype.NOVOICE) {
            final TTSPlanner ttsp = (TTSPlanner)this.speechPlanner;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpeechEngineLoader.this.voiceList = new JComboBox<String>(ttsp.getVoices());
                    SpeechEngineLoader.this.voiceList.setEditable(false);
                    SpeechEngineLoader.this.voiceList.setSelectedItem(SpeechEngineLoader.this.voicename);
                    SpeechEngineLoader.this.voiceList.addActionListener(new VoiceSelectionListener());
                    SpeechEngineLoader.this.speechUIPanel = new JPanel();
                    SpeechEngineLoader.this.speechUIPanel.add(new JLabel("Voice:"));
                    SpeechEngineLoader.this.speechUIPanel.add(Box.createRigidArea(new Dimension(5, 0)));
                    SpeechEngineLoader.this.speechUIPanel.add(SpeechEngineLoader.this.voiceList);
                    SpeechEngineLoader.this.jce.addJComponent((JComponent)SpeechEngineLoader.this.speechUIPanel);
                }
            });
        }
    }

    private TTSPlanner getTTSPlanner(FaceController faceController, AnimationPlayer animationPlayer, PlanManager<TimedFaceUnit> facePlanManager, PlanManager<TimedMotionUnit> animationPlanManager, TTSBinding ttsBin) {
        TimedTTSUnitFactory ttsFactory = null;
        switch (this.factory) {
            case DIRECT_TTS: {
                ttsFactory = new DirectTTSUnitFactory(this.theVirtualHuman.getElckerlycRealizer().getFeedbackManager());
                break;
            }
            case WAV_TTS: {
                ttsFactory = new WavTTSUnitFactory(this.theVirtualHuman.getElckerlycRealizer().getFeedbackManager(), this.aue.getSoundManager());
                break;
            }
            default: {
                System.err.println("cannot initialize this factory, wrong type.");
                return null;
            }
        }
        return new TTSPlanner(this.theVirtualHuman.getElckerlycRealizer().getFeedbackManager(), ttsFactory, ttsBin, faceController, (VisemeBinding)this.visemebinding, animationPlayer, this.speechbinding, this.speechPlanManager, facePlanManager, animationPlanManager);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Player getPlayer() {
        return this.speechPlayer;
    }

    public Planner<TimedTTSUnit> getSpeechPlanner() {
        return this.speechPlanner;
    }

    public PlanManager<TimedTTSUnit> getPlanManager() {
        return this.speechPlanManager;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    class VoiceSelectionListener
    implements ActionListener {
        VoiceSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (SpeechEngineLoader.this.voicetype) {
                case NOVOICE: {
                    return;
                }
                case MARY: 
                case SAPI5: {
                    if (!(SpeechEngineLoader.this.speechPlanner instanceof TTSPlanner)) break;
                    ((TTSPlanner)SpeechEngineLoader.this.speechPlanner).setSpeaker((String)SpeechEngineLoader.this.voiceList.getSelectedItem());
                    break;
                }
                default: {
                    System.err.println("cannot initialize this voice, wrong type");
                    return;
                }
            }
        }
    }

    public static enum Factory {
        DIRECT_TTS,
        WAV_TTS;

    }

    public static enum Voicetype {
        NOVOICE,
        SAPI5,
        MARY;

    }
}

