/*
 * Decompiled with CFR 0.152.
 */
package hmi.speechengine;

import com.google.common.collect.Sets;
import hmi.audioengine.WavUnit;
import hmi.audioengine.WavUnitImpl;
import hmi.audioengine.WavUnitPlayException;
import hmi.audioenvironment.SoundManager;
import hmi.audioenvironment.WavCreationException;
import hmi.bml.core.Behaviour;
import hmi.bml.core.SpeechBehaviour;
import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.planunit.TimedPlanUnit;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayException;
import hmi.speechengine.SpeechUnitPlanningException;
import hmi.speechengine.TimedTTSUnit;
import hmi.speechengine.ttsbinding.TTSBinding;
import hmi.tts.Bookmark;
import hmi.tts.TimingInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedWavTTSUnit
extends TimedTTSUnit {
    private static final Logger log = LoggerFactory.getLogger(TimedWavTTSUnit.class);
    protected WavUnit wavUnit;
    private final SoundManager soundManager;
    private final String voiceId;
    private File tempFile;
    @GuardedBy(value="this")
    private Set<Bookmark> progressHandled = Sets.newHashSet();

    public TimedWavTTSUnit(FeedbackManager bfm, SoundManager sm, BMLBlockPeg bbPeg, String text, String voiceId, String bmlId, String id, TTSBinding ttsBin, Class<? extends Behaviour> behClass) {
        super(bfm, bbPeg, text, bmlId, id, ttsBin, behClass);
        this.soundManager = sm;
        this.voiceId = voiceId;
    }

    public TimedWavTTSUnit(FeedbackManager bfm, SoundManager sm, BMLBlockPeg bbPeg, String text, String id, String voiceId, String bmlId, TTSBinding ttsBin) {
        super(bfm, bbPeg, text, bmlId, id, ttsBin, SpeechBehaviour.class);
        this.soundManager = sm;
        this.voiceId = voiceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendProgress(double playTime, double time) {
        ArrayList<BMLSyncPointProgressFeedback> sppfs = new ArrayList<BMLSyncPointProgressFeedback>();
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            for (Bookmark b : this.bookmarks) {
                if (!(playTime >= (double)b.getOffset() / 1000.0) || this.progressHandled.contains(b)) continue;
                String behaviorId = this.getId();
                String syncId = b.getName();
                double bmlBlockTime = time - this.bmlBlockPeg.getValue();
                sppfs.add(new BMLSyncPointProgressFeedback(this.getBMLId(), behaviorId, syncId, bmlBlockTime, time));
                this.progressHandled.add(b);
            }
        }
        this.feedback(sppfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playUnit(double time) throws TimedPlanUnitPlayException {
        double playTime = time - this.getStartTime();
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            try {
                this.wavUnit.play(playTime);
            }
            catch (WavUnitPlayException e) {
                throw new TimedPlanUnitPlayException(e.getLocalizedMessage(), (TimedPlanUnit)this, (Exception)((Object)e));
            }
        }
        this.sendProgress(playTime, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUnit(double time) {
        log.debug("StopTimedWavUnit {}:{}", (Object)this.getBMLId(), (Object)this.getId());
        this.sendProgress(time - this.getStartTime(), time);
        if (time >= this.getEndTime()) {
            this.sendEndProgress(time);
        }
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            log.debug("StopTimedWavUnit in sync block)");
            this.wavUnit.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        this.sendStartProgress(time);
        this.bmlStartTime = time;
        log.debug("Time: {}, relative startTime: {}", (Object)time, (Object)(time - this.getStartTime()));
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            if (this.wavUnit == null) {
                throw new TimedPlanUnitPlayException("null wavUnit", (TimedPlanUnit)this);
            }
            this.wavUnit.start(time - this.getStartTime());
        }
    }

    @Override
    protected synchronized void setupCache() throws SpeechUnitPlanningException {
        try {
            try {
                this.wavUnit = new WavUnitImpl(this.soundManager.createWav(this.tempFile.toURI().toURL().openStream(), this.voiceId));
            }
            catch (WavCreationException e) {
                throw new SpeechUnitPlanningException(e.getLocalizedMessage(), (TimedPlanUnit)this, (Exception)((Object)e));
            }
        }
        catch (IOException ex) {
            throw new SpeechUnitPlanningException(ex.getLocalizedMessage(), (TimedPlanUnit)this, ex);
        }
        finally {
            if (this.tempFile != null && !this.tempFile.delete()) {
                log.warn("Couldn't delete temp file in WavTTSUnit: {}", (Object)this.tempFile.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TimingInfo getTiming() throws SpeechUnitPlanningException {
        String fileName = this.getBMLId() + "-" + this.getId();
        TimedWavTTSUnit timedWavTTSUnit = this;
        synchronized (timedWavTTSUnit) {
            TimingInfo ti = null;
            try {
                this.tempFile = File.createTempFile(fileName, ".wav");
            }
            catch (IOException e) {
                throw new SpeechUnitPlanningException(e.getLocalizedMessage(), (TimedPlanUnit)this, e);
            }
            try {
                ti = this.ttsBinding.speakToFile(this.getBehaviourClass(), this.speechText, this.tempFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new SpeechUnitPlanningException(e.getLocalizedMessage(), (TimedPlanUnit)this, e);
            }
            this.progressHandled.clear();
            return ti;
        }
    }

    public void setFloatParameterValue(String parameter, float value) throws ParameterException {
        log.debug("TimedWavTTSUnit Setting parameter {} value {}", (Object)parameter, (Object)Float.valueOf(value));
        try {
            this.wavUnit.setParameterValue(parameter, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    public void setParameterValue(String paramId, String value) throws ParameterException {
        try {
            this.wavUnit.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    public float getFloatParameterValue(String paramId) throws ParameterException {
        try {
            return this.wavUnit.getFloatParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    public String getParameterValue(String paramId) throws ParameterException {
        try {
            return this.wavUnit.getParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }
}

