/*
 * Decompiled with CFR 0.152.
 */
package hmi.speechengine;

import hmi.bml.feedback.BMLSyncPointProgressFeedback;
import hmi.elckerlyc.feedback.FeedbackManager;
import hmi.elckerlyc.feedback.NullFeedbackManager;
import hmi.elckerlyc.pegboard.BMLBlockPeg;
import hmi.elckerlyc.pegboard.TimePeg;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.elckerlyc.planunit.TimedPlanUnitPlayException;
import hmi.speechengine.TextOutput;
import hmi.speechengine.TimedAbstractSpeechUnit;
import hmi.tts.util.BMLTextUtil;
import hmi.tts.util.SyncAndOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedTextSpeechUnit
extends TimedAbstractSpeechUnit {
    private final String[] words;
    private TextOutput output;
    private final Map<String, Integer> syncMap = new HashMap<String, Integer>();
    private Map<String, TimePeg> pegs = new HashMap<String, TimePeg>();
    private static final double SPEECH_RATE = 2.0;
    private ArrayList<String> progressHandled = new ArrayList();
    private ArrayList<String> syncs = new ArrayList();
    private Logger logger = LoggerFactory.getLogger((String)TimedTextSpeechUnit.class.getName());

    public List<String> getSyncs() {
        return this.syncs;
    }

    public TimePeg getTimePeg(String s) {
        return this.pegs.get(s);
    }

    public List<String> getAvailableSyncs() {
        ArrayList<String> availableSyncs = new ArrayList<String>();
        availableSyncs.add("start");
        for (String syncId : this.syncs) {
            availableSyncs.add(syncId);
        }
        availableSyncs.add("end");
        return availableSyncs;
    }

    public double getTime(String s) {
        TimePeg p = this.pegs.get(s);
        if (p == null) {
            return -1.7976931348623157E308;
        }
        return p.getGlobalValue();
    }

    public void setTimePeg(String sync, TimePeg sp) {
        if (this.syncs.contains(sync)) {
            this.pegs.put(sync, sp);
            this.logger.debug("Adding sync {}", (Object)sync);
        }
        if (sync.equals("start")) {
            this.setStart(sp);
        } else if (sync.equals("end")) {
            this.setEnd(sp);
        } else {
            this.logger.warn("Can't set TimePeg for sync {}, only setting " + this.syncs + "is allowed", (Object)sync);
        }
    }

    public TimedTextSpeechUnit(BMLBlockPeg bbPeg, String text, String bmlId, String id, TextOutput output) {
        this((FeedbackManager)NullFeedbackManager.getInstance(), bbPeg, text, bmlId, id, output);
    }

    public TimedTextSpeechUnit(FeedbackManager bfm, BMLBlockPeg bbPeg, String text, String bmlId, String id, TextOutput output) {
        super(bfm, bbPeg, text, bmlId, id);
        this.syncs.add("start");
        this.syncMap.put("start", 0);
        this.logger.debug("text: {}", (Object)text);
        String textNoSync = BMLTextUtil.stripSyncs((String)text);
        this.words = textNoSync.split(" ");
        List syncAndOffsets = BMLTextUtil.getSyncAndOffsetList((String)text, (int)this.words.length);
        for (SyncAndOffset s : syncAndOffsets) {
            this.syncs.add(s.getSync());
            this.syncMap.put(s.getSync(), s.getOffset());
        }
        this.output = output;
        this.speechText = textNoSync;
        this.syncs.add("end");
        this.syncMap.put("end", this.words.length);
        this.logger.debug("speechText: {}", (Object)this.speechText);
    }

    public double getPreferedDuration() {
        return (double)this.words.length * 0.5;
    }

    public boolean hasValidTiming() {
        double prevTime = 0.0;
        for (String sync : this.syncs) {
            TimePeg p = this.pegs.get(sync);
            if (p == null || p.getGlobalValue() == -1.7976931348623157E308) continue;
            this.logger.debug("Checking time of {}: {}", (Object)sync, (Object)p.getGlobalValue());
            if (p.getGlobalValue() < prevTime) {
                return false;
            }
            prevTime = p.getGlobalValue();
        }
        return true;
    }

    public void setFloatParameterValue(String parameter, float value) throws ParameterException {
        try {
            this.output.setFloatParameterValue(parameter, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    public void setParameterValue(String paramId, String value) throws ParameterException {
        try {
            this.output.setParameterValue(paramId, value);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }

    public void stopUnit(double time) {
        this.sendProgress(this.getRelativeTime(time), time);
        if (time >= this.getEndTime()) {
            this.sendEndProgress(time);
        }
        this.progressHandled.clear();
        this.output.setText(this.speechText);
    }

    public double getRelativeTime(double time) {
        double canDuration;
        double realDuration;
        double t;
        double startSegmentTime = this.getStartTime();
        double startKeyTime = 0.0;
        double endSegmentTime = this.getEndTime();
        double endKeyTime = 1.0;
        for (String sync : this.syncs) {
            TimePeg s = this.pegs.get(sync);
            if (s == null || s.getGlobalValue() == -1.7976931348623157E308) continue;
            if (s.getGlobalValue() <= time) {
                startSegmentTime = s.getGlobalValue();
                startKeyTime = this.getRelativeTime(sync);
                continue;
            }
            endSegmentTime = s.getGlobalValue();
            endKeyTime = this.getRelativeTime(sync);
            break;
        }
        if (endSegmentTime == -1.7976931348623157E308) {
            endSegmentTime = startSegmentTime;
            endKeyTime = startKeyTime;
        }
        if ((t = (time - startSegmentTime) / (realDuration = endSegmentTime - startSegmentTime) * (canDuration = endKeyTime - startKeyTime) + startKeyTime) > 1.0) {
            t = 1.0;
        }
        return t;
    }

    public double getRelativeTime(String sync) {
        return (double)this.syncMap.get(sync).intValue() / (double)this.words.length;
    }

    public void playUnit(double time) {
        double t = this.getRelativeTime(time);
        String str = this.speechText.substring(0, (int)Math.round(t * (double)this.speechText.length()));
        this.output.setText(str);
        this.sendProgress(t, time);
    }

    public void sendProgress(double playTime, double time) {
        for (String sync : this.syncMap.keySet()) {
            double t = this.getRelativeTime(sync);
            if (!(playTime > t) || this.progressHandled.contains(sync)) continue;
            String bmlId = this.getBMLId();
            String behaviorId = this.getId();
            double bmlBlockTime = time - this.bmlBlockPeg.getValue();
            this.feedback(new BMLSyncPointProgressFeedback(bmlId, behaviorId, sync, bmlBlockTime, time));
            this.progressHandled.add(sync);
        }
    }

    @Override
    protected void sendStartProgress(double time) {
        super.sendStartProgress(time);
        this.progressHandled.add("start");
    }

    @Override
    public void sendEndProgress(double time) {
        super.sendEndProgress(time);
        this.progressHandled.add("end");
    }

    protected void startUnit(double time) throws TimedPlanUnitPlayException {
        this.sendStartProgress(time);
    }

    public float getFloatParameterValue(String paramId) throws ParameterException {
        try {
            return this.output.getFloatParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitFloatParameterNotFoundException(e);
        }
    }

    public String getParameterValue(String paramId) throws ParameterException {
        try {
            return this.output.getParameterValue(paramId);
        }
        catch (ParameterNotFoundException e) {
            throw this.wrapIntoPlanUnitParameterNotFoundException(e);
        }
    }
}

