/*
 * Decompiled with CFR 0.152.
 */
package hmi.speechengine.ttsbinding;

import hmi.bml.core.Behaviour;
import hmi.elckerlyc.planunit.ParameterException;
import hmi.elckerlyc.planunit.ParameterNotFoundException;
import hmi.tts.AbstractTTSGenerator;
import hmi.tts.TTSBridge;
import hmi.tts.TTSCallback;
import hmi.tts.TimingInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TTSBinding {
    protected AbstractTTSGenerator ttsGenerator;
    protected List<Class<? extends Behaviour>> supportedBehaviours = new ArrayList<Class<? extends Behaviour>>();
    protected Map<Class<? extends Behaviour>, TTSBridge> ttsBridgeMap = new HashMap<Class<? extends Behaviour>, TTSBridge>();

    public List<Class<? extends Behaviour>> getSupportedBMLDescriptionExtensions() {
        return this.supportedBehaviours;
    }

    public void setParameterValue(String parameter, String value) throws ParameterException {
        throw new ParameterNotFoundException(parameter);
    }

    public void setFloatParameterValue(String parameter, float value) throws ParameterException {
        throw new ParameterNotFoundException(parameter);
    }

    public float getFloatParameterValue(String parameter) throws ParameterException {
        throw new ParameterNotFoundException(parameter);
    }

    public String getParameterValue(String parameter) throws ParameterException {
        throw new ParameterNotFoundException(parameter);
    }

    public TimingInfo speak(Class<? extends Behaviour> behClass, String text) {
        TTSBridge bridge = this.ttsBridgeMap.get(behClass);
        if (bridge != null) {
            return bridge.speak(text);
        }
        return null;
    }

    public TimingInfo speakToFile(Class<? extends Behaviour> behClass, String text, String filename) throws IOException {
        TTSBridge bridge = this.ttsBridgeMap.get(behClass);
        if (bridge != null) {
            return bridge.speakToFile(text, filename);
        }
        return null;
    }

    public TimingInfo getTiming(Class<? extends Behaviour> behClass, String text) {
        TTSBridge bridge = this.ttsBridgeMap.get(behClass);
        if (bridge != null) {
            return bridge.getTiming(text);
        }
        return null;
    }

    public void setCallback(TTSCallback cb) {
        this.ttsGenerator.setCallback(cb);
    }

    public void setVoice(String voice) {
        this.ttsGenerator.setVoice(voice);
    }

    public String[] getVoices() {
        return this.ttsGenerator.getVoices();
    }

    public abstract void cleanup();
}

